/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.autofill.FillEventHistory;
import android.service.autofill.UserData;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.KeyEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import android.view.autofill.ParcelableMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;
import sun.misc.Cleaner;

public class AutofillManager {
    private static final String TAG = "AutofillManager";
    public static final String EXTRA_ASSIST_STRUCTURE = "android.view.autofill.extra.ASSIST_STRUCTURE";
    public static final String EXTRA_AUTHENTICATION_RESULT = "android.view.autofill.extra.AUTHENTICATION_RESULT";
    public static final String EXTRA_CLIENT_STATE = "android.view.autofill.extra.CLIENT_STATE";
    public static final String EXTRA_RESTORE_SESSION_TOKEN = "android.view.autofill.extra.RESTORE_SESSION_TOKEN";
    private static final String SESSION_ID_TAG = "android:sessionId";
    private static final String STATE_TAG = "android:state";
    private static final String LAST_AUTOFILLED_DATA_TAG = "android:lastAutoFilledData";
    public static final int ACTION_START_SESSION = 1;
    public static final int ACTION_VIEW_ENTERED = 2;
    public static final int ACTION_VIEW_EXITED = 3;
    public static final int ACTION_VALUE_CHANGED = 4;
    public static final int FLAG_ADD_CLIENT_ENABLED = 1;
    public static final int FLAG_ADD_CLIENT_DEBUG = 2;
    public static final int FLAG_ADD_CLIENT_VERBOSE = 4;
    private static final int AUTHENTICATION_ID_DATASET_ID_MASK = 65535;
    private static final int AUTHENTICATION_ID_DATASET_ID_SHIFT = 16;
    public static final int AUTHENTICATION_ID_DATASET_ID_UNDEFINED = 65535;
    public static final int PENDING_UI_OPERATION_CANCEL = 1;
    public static final int PENDING_UI_OPERATION_RESTORE = 2;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_SHOWING_SAVE_UI = 3;
    public static final int STATE_DISABLED_BY_SERVICE = 4;
    public static final int STATE_UNKNOWN_COMPAT_MODE = 5;
    public static final int FC_SERVICE_TIMEOUT = 5000;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    public static final int NO_SESSION = Integer.MIN_VALUE;
    private final IAutoFillManager mService;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private IAutoFillManagerClient mServiceClient;
    @GuardedBy(value="mLock")
    private Cleaner mServiceClientCleaner;
    @GuardedBy(value="mLock")
    private AutofillCallback mCallback;
    private final Context mContext;
    @GuardedBy(value="mLock")
    private int mSessionId = Integer.MIN_VALUE;
    @GuardedBy(value="mLock")
    private int mState = 0;
    @GuardedBy(value="mLock")
    private boolean mEnabled;
    @GuardedBy(value="mLock")
    private ParcelableMap mLastAutofilledData;
    @GuardedBy(value="mLock")
    private TrackedViews mTrackedViews;
    @GuardedBy(value="mLock")
    private ArraySet<AutofillId> mFillableIds;
    private AutofillId mIdShownFillUi;
    @GuardedBy(value="mLock")
    private ArraySet<AutofillId> mEnteredIds;
    @GuardedBy(value="mLock")
    private AutofillId mSaveTriggerId;
    @GuardedBy(value="mLock")
    private boolean mOnInvisibleCalled;
    @GuardedBy(value="mLock")
    private boolean mSaveOnFinish;
    @GuardedBy(value="mLock")
    private CompatibilityBridge mCompatibilityBridge;
    public static final int SET_STATE_FLAG_ENABLED = 1;
    public static final int SET_STATE_FLAG_RESET_SESSION = 2;
    public static final int SET_STATE_FLAG_RESET_CLIENT = 4;
    public static final int SET_STATE_FLAG_DEBUG = 8;
    public static final int SET_STATE_FLAG_VERBOSE = 16;

    public static int makeAuthenticationId(int requestId, int datasetId) {
        return requestId << 16 | datasetId & 0xFFFF;
    }

    public static int getRequestIdFromAuthenticationId(int authRequestId) {
        return authRequestId >> 16;
    }

    public static int getDatasetIdFromAuthenticationId(int authRequestId) {
        return authRequestId & 0xFFFF;
    }

    public AutofillManager(Context context, IAutoFillManager service) {
        this.mContext = Preconditions.checkNotNull(context, "context cannot be null");
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCompatibilityMode() {
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sDebug) {
                Slog.d(TAG, "creating CompatibilityBridge for " + this.mContext);
            }
            this.mCompatibilityBridge = new CompatibilityBridge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(Bundle savedInstanceState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLastAutofilledData = (ParcelableMap)savedInstanceState.getParcelable(LAST_AUTOFILLED_DATA_TAG);
            if (this.isActiveLocked()) {
                Log.w(TAG, "New session was started before onCreate()");
                return;
            }
            this.mSessionId = savedInstanceState.getInt(SESSION_ID_TAG, Integer.MIN_VALUE);
            this.mState = savedInstanceState.getInt(STATE_TAG, 0);
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.ensureServiceClientAddedIfNeededLocked();
                AutofillClient client = this.getClient();
                if (client != null) {
                    try {
                        boolean sessionWasRestored = this.mService.restoreSession(this.mSessionId, client.autofillClientGetActivityToken(), this.mServiceClient.asBinder());
                        if (!sessionWasRestored) {
                            Log.w(TAG, "Session " + this.mSessionId + " could not be restored");
                            this.mSessionId = Integer.MIN_VALUE;
                            this.mState = 0;
                        } else {
                            if (Helper.sDebug) {
                                Log.d(TAG, "session " + this.mSessionId + " was restored");
                            }
                            client.autofillClientResetableStateAvailable();
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Could not figure out if there was an autofill session", e);
                    }
                }
            }
        }
    }

    public void onVisibleForAutofill() {
        Choreographer.getInstance().postCallback(3, () -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mEnabled && this.isActiveLocked() && this.mTrackedViews != null) {
                    this.mTrackedViews.onVisibleForAutofillChangedLocked();
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInvisibleForAutofill() {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnInvisibleCalled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSaveInstanceState(Bundle outState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                outState.putInt(SESSION_ID_TAG, this.mSessionId);
            }
            if (this.mState != 0) {
                outState.putInt(STATE_TAG, this.mState);
            }
            if (this.mLastAutofilledData != null) {
                outState.putParcelable(LAST_AUTOFILLED_DATA_TAG, this.mLastAutofilledData);
            }
        }
    }

    @GuardedBy(value="mLock")
    public boolean isCompatibilityModeEnabledLocked() {
        return this.mCompatibilityBridge != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        if (!this.hasAutofillFeature()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDisabledByServiceLocked()) {
                return false;
            }
            this.ensureServiceClientAddedIfNeededLocked();
            return this.mEnabled;
        }
    }

    public FillEventHistory getFillEventHistory() {
        try {
            return this.mService.getFillEventHistory();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public void requestAutofill(View view) {
        this.notifyViewEntered(view, 1);
    }

    public void requestAutofill(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 1);
    }

    public void notifyViewEntered(View view) {
        this.notifyViewEntered(view, 0);
    }

    @GuardedBy(value="mLock")
    private boolean shouldIgnoreViewEnteredLocked(AutofillId id2, int flags) {
        if (this.isDisabledByServiceLocked()) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ") on state " + this.getStateAsStringLocked() + " because disabled by svc");
            }
            return true;
        }
        if (this.isFinishedLocked() && (flags & 1) == 0 && this.mEnteredIds != null && this.mEnteredIds.contains(id2)) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ") on state " + this.getStateAsStringLocked() + " because view was already entered: " + this.mEnteredIds);
            }
            return true;
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "not ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ", state " + this.getStateAsStringLocked() + ", enteredIds=" + this.mEnteredIds);
        }
        return false;
    }

    private boolean isClientVisibleForAutofillLocked() {
        AutofillClient client = this.getClient();
        return client != null && client.autofillClientIsVisibleForAutofill();
    }

    private boolean isClientDisablingEnterExitEvent() {
        AutofillClient client = this.getClient();
        return client != null && client.isDisablingEnterExitEventForAutofill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewEntered(View view, int flags) {
        AutofillCallback callback;
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callback = this.notifyViewEnteredLocked(view, flags);
        }
        if (callback != null) {
            this.mCallback.onAutofillEvent(view, 3);
        }
    }

    @GuardedBy(value="mLock")
    private AutofillCallback notifyViewEnteredLocked(View view, int flags) {
        AutofillId id2 = view.getAutofillId();
        if (this.shouldIgnoreViewEnteredLocked(id2, flags)) {
            return null;
        }
        AutofillCallback callback = null;
        this.ensureServiceClientAddedIfNeededLocked();
        if (!this.mEnabled) {
            if (this.mCallback != null) {
                callback = this.mCallback;
            }
        } else if (!this.isClientDisablingEnterExitEvent()) {
            AutofillValue value = view.getAutofillValue();
            if (!this.isActiveLocked()) {
                this.startSessionLocked(id2, null, value, flags);
            } else {
                this.updateSessionLocked(id2, null, value, 2, flags);
            }
            this.addEnteredIdLocked(id2);
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewExited(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyViewExitedLocked(view);
        }
    }

    @GuardedBy(value="mLock")
    void notifyViewExitedLocked(View view) {
        this.ensureServiceClientAddedIfNeededLocked();
        if (this.mEnabled && this.isActiveLocked() && !this.isClientDisablingEnterExitEvent()) {
            AutofillId id2 = view.getAutofillId();
            this.updateSessionLocked(id2, null, null, 3, 0);
        }
    }

    public void notifyViewVisibilityChanged(View view, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, 0, isVisible, false);
    }

    public void notifyViewVisibilityChanged(View view, int virtualId, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, virtualId, isVisible, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewVisibilityChangedInternal(View view, int virtualId, boolean isVisible, boolean virtual) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2;
                AutofillId autofillId = id2 = virtual ? AutofillManager.getAutofillId(view, virtualId) : view.getAutofillId();
                if (Helper.sVerbose) {
                    Log.v(TAG, "visibility changed for " + id2 + ": " + isVisible);
                }
                if (!isVisible && this.mFillableIds != null && this.mFillableIds.contains(id2)) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "Hidding UI when view " + id2 + " became invisible");
                    }
                    this.requestHideFillUi(id2, view);
                }
                if (this.mTrackedViews != null) {
                    this.mTrackedViews.notifyViewVisibilityChangedLocked(id2, isVisible);
                } else if (Helper.sVerbose) {
                    Log.v(TAG, "Ignoring visibility change on " + id2 + ": no tracked views");
                }
            }
        }
    }

    public void notifyViewEntered(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewEntered(View view, int virtualId, Rect bounds, int flags) {
        AutofillCallback callback;
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callback = this.notifyViewEnteredLocked(view, virtualId, bounds, flags);
        }
        if (callback != null) {
            callback.onAutofillEvent(view, virtualId, 3);
        }
    }

    @GuardedBy(value="mLock")
    private AutofillCallback notifyViewEnteredLocked(View view, int virtualId, Rect bounds, int flags) {
        AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
        AutofillCallback callback = null;
        if (this.shouldIgnoreViewEnteredLocked(id2, flags)) {
            return callback;
        }
        this.ensureServiceClientAddedIfNeededLocked();
        if (!this.mEnabled) {
            if (this.mCallback != null) {
                callback = this.mCallback;
            }
        } else if (!this.isClientDisablingEnterExitEvent()) {
            if (!this.isActiveLocked()) {
                this.startSessionLocked(id2, bounds, null, flags);
            } else {
                this.updateSessionLocked(id2, bounds, null, 2, flags);
            }
            this.addEnteredIdLocked(id2);
        }
        return callback;
    }

    @GuardedBy(value="mLock")
    private void addEnteredIdLocked(AutofillId id2) {
        if (this.mEnteredIds == null) {
            this.mEnteredIds = new ArraySet(1);
        }
        this.mEnteredIds.add(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewExited(View view, int virtualId) {
        if (Helper.sVerbose) {
            Log.v(TAG, "notifyViewExited(" + view.getAutofillId() + ", " + virtualId);
        }
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyViewExitedLocked(view, virtualId);
        }
    }

    @GuardedBy(value="mLock")
    private void notifyViewExitedLocked(View view, int virtualId) {
        this.ensureServiceClientAddedIfNeededLocked();
        if (this.mEnabled && this.isActiveLocked() && !this.isClientDisablingEnterExitEvent()) {
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, null, 3, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyValueChanged(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillId id2 = null;
        boolean valueWasRead = false;
        AutofillValue value = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastAutofilledData == null) {
                view.setAutofilled(false);
            } else {
                id2 = view.getAutofillId();
                if (this.mLastAutofilledData.containsKey(id2)) {
                    value = view.getAutofillValue();
                    valueWasRead = true;
                    if (Objects.equals(this.mLastAutofilledData.get(id2), value)) {
                        view.setAutofilled(true);
                    } else {
                        view.setAutofilled(false);
                        this.mLastAutofilledData.remove(id2);
                    }
                } else {
                    view.setAutofilled(false);
                }
            }
            if (!this.mEnabled || !this.isActiveLocked()) {
                if (Helper.sVerbose) {
                    Log.v(TAG, "notifyValueChanged(" + view.getAutofillId() + "): ignoring on state " + this.getStateAsStringLocked());
                }
                return;
            }
            if (id2 == null) {
                id2 = view.getAutofillId();
            }
            if (!valueWasRead) {
                value = view.getAutofillValue();
            }
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyValueChanged(View view, int virtualId, AutofillValue value) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                if (Helper.sVerbose) {
                    Log.v(TAG, "notifyValueChanged(" + view.getAutofillId() + ":" + virtualId + "): ignoring on state " + this.getStateAsStringLocked());
                }
                return;
            }
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    public void notifyViewClicked(View view) {
        this.notifyViewClicked(view.getAutofillId());
    }

    public void notifyViewClicked(View view, int virtualId) {
        this.notifyViewClicked(AutofillManager.getAutofillId(view, virtualId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewClicked(AutofillId id2) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "notifyViewClicked(): id=" + id2 + ", trigger=" + this.mSaveTriggerId);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                return;
            }
            if (this.mSaveTriggerId != null && this.mSaveTriggerId.equals(id2)) {
                if (Helper.sDebug) {
                    Log.d(TAG, "triggering commit by click of " + id2);
                }
                this.commitLocked();
                this.mMetricsLogger.write(this.newLog(1229));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityFinishing() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSaveOnFinish) {
                if (Helper.sDebug) {
                    Log.d(TAG, "onActivityFinishing(): calling commitLocked()");
                }
                this.commitLocked();
            } else {
                if (Helper.sDebug) {
                    Log.d(TAG, "onActivityFinishing(): calling cancelLocked()");
                }
                this.cancelLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "commit() called by app");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.commitLocked();
        }
    }

    @GuardedBy(value="mLock")
    private void commitLocked() {
        if (!this.mEnabled && !this.isActiveLocked()) {
            return;
        }
        this.finishSessionLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (Helper.sVerbose) {
            Log.v(TAG, "cancel() called by app");
        }
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.cancelLocked();
        }
    }

    @GuardedBy(value="mLock")
    private void cancelLocked() {
        if (!this.mEnabled && !this.isActiveLocked()) {
            return;
        }
        this.cancelSessionLocked();
    }

    public void disableOwnedAutofillServices() {
        this.disableAutofillServices();
    }

    public void disableAutofillServices() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        try {
            this.mService.disableOwnedAutofillServices(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasEnabledAutofillServices() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceEnabled(this.mContext.getUserId(), this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ComponentName getAutofillServiceComponentName() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getAutofillServiceComponentName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getUserDataId() {
        try {
            return this.mService.getUserDataId();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public UserData getUserData() {
        try {
            return this.mService.getUserData();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public void setUserData(UserData userData) {
        try {
            this.mService.setUserData(userData);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean isFieldClassificationEnabled() {
        try {
            return this.mService.isFieldClassificationEnabled();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public String getDefaultFieldClassificationAlgorithm() {
        try {
            return this.mService.getDefaultFieldClassificationAlgorithm();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public List<String> getAvailableFieldClassificationAlgorithms() {
        try {
            String[] algorithms = this.mService.getAvailableFieldClassificationAlgorithms();
            return algorithms != null ? Arrays.asList(algorithms) : Collections.emptyList();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public boolean isAutofillSupported() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceSupported(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private AutofillClient getClient() {
        AutofillClient client = this.mContext.getAutofillClient();
        if (client == null && Helper.sDebug) {
            Log.d(TAG, "No AutofillClient for " + this.mContext.getPackageName() + " on context " + this.mContext);
        }
        return client;
    }

    public boolean isAutofillUiShowing() {
        AutofillClient client = this.mContext.getAutofillClient();
        return client != null && client.autofillClientIsFillUiShowing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAuthenticationResult(int authenticationId, Intent data, View focusView) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sDebug) {
            Log.d(TAG, "onAuthenticationResult(): d=" + data);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isActiveLocked()) {
                return;
            }
            if (!this.mOnInvisibleCalled && focusView != null && focusView.canNotifyAutofillEnterExitEvent()) {
                this.notifyViewExitedLocked(focusView);
                this.notifyViewEnteredLocked(focusView, 0);
            }
            if (data == null) {
                return;
            }
            Object result = data.getParcelableExtra(EXTRA_AUTHENTICATION_RESULT);
            Bundle responseData = new Bundle();
            responseData.putParcelable(EXTRA_AUTHENTICATION_RESULT, (Parcelable)result);
            Bundle newClientState = data.getBundleExtra(EXTRA_CLIENT_STATE);
            if (newClientState != null) {
                responseData.putBundle(EXTRA_CLIENT_STATE, newClientState);
            }
            try {
                this.mService.setAuthenticationResult(responseData, this.mSessionId, authenticationId, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error delivering authentication result", e);
            }
        }
    }

    public AutofillId getNextAutofillId() {
        AutofillClient client = this.getClient();
        if (client == null) {
            return null;
        }
        AutofillId id2 = client.autofillClientGetNextAutofillId();
        if (id2 == null && Helper.sDebug) {
            Log.d(TAG, "getNextAutofillId(): client " + client + " returned null");
        }
        return id2;
    }

    private static AutofillId getAutofillId(View parent, int virtualId) {
        return new AutofillId(parent.getAutofillViewId(), virtualId);
    }

    @GuardedBy(value="mLock")
    private void startSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int flags) {
        if (Helper.sVerbose) {
            Log.v(TAG, "startSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", flags=" + flags + ", state=" + this.getStateAsStringLocked() + ", compatMode=" + this.isCompatibilityModeEnabledLocked() + ", enteredIds=" + this.mEnteredIds);
        }
        if (this.mState != 0 && !this.isFinishedLocked() && (flags & 1) == 0) {
            if (Helper.sVerbose) {
                Log.v(TAG, "not automatically starting session for " + id2 + " on state " + this.getStateAsStringLocked() + " and flags " + flags);
            }
            return;
        }
        try {
            AutofillClient client = this.getClient();
            if (client == null) {
                return;
            }
            this.mSessionId = this.mService.startSession(client.autofillClientGetActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, client.autofillClientGetComponentName(), this.isCompatibilityModeEnabledLocked());
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.mState = 1;
            }
            client.autofillClientResetableStateAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value="mLock")
    private void finishSessionLocked() {
        if (Helper.sVerbose) {
            Log.v(TAG, "finishSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.finishSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked(true);
    }

    @GuardedBy(value="mLock")
    private void cancelSessionLocked() {
        if (Helper.sVerbose) {
            Log.v(TAG, "cancelSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.cancelSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked(true);
    }

    @GuardedBy(value="mLock")
    private void resetSessionLocked(boolean resetEnteredIds) {
        this.mSessionId = Integer.MIN_VALUE;
        this.mState = 0;
        this.mTrackedViews = null;
        this.mFillableIds = null;
        this.mSaveTriggerId = null;
        this.mIdShownFillUi = null;
        if (resetEnteredIds) {
            this.mEnteredIds = null;
        }
    }

    @GuardedBy(value="mLock")
    private void updateSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int action, int flags) {
        if (Helper.sVerbose) {
            Log.v(TAG, "updateSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", action=" + action + ", flags=" + flags);
        }
        boolean restartIfNecessary = (flags & 1) != 0;
        try {
            if (restartIfNecessary) {
                AutofillClient client = this.getClient();
                if (client == null) {
                    return;
                }
                int newId = this.mService.updateOrRestartSession(client.autofillClientGetActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, client.autofillClientGetComponentName(), this.mSessionId, action, this.isCompatibilityModeEnabledLocked());
                if (newId != this.mSessionId) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "Session restarted: " + this.mSessionId + "=>" + newId);
                    }
                    this.mSessionId = newId;
                    this.mState = this.mSessionId == Integer.MIN_VALUE ? 0 : 1;
                    client.autofillClientResetableStateAvailable();
                }
            } else {
                this.mService.updateSession(this.mSessionId, id2, bounds, value, action, flags, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value="mLock")
    private void ensureServiceClientAddedIfNeededLocked() {
        if (this.getClient() == null) {
            return;
        }
        if (this.mServiceClient == null) {
            this.mServiceClient = new AutofillManagerClient(this);
            try {
                int userId = this.mContext.getUserId();
                int flags = this.mService.addClient(this.mServiceClient, userId);
                this.mEnabled = (flags & 1) != 0;
                Helper.sDebug = (flags & 2) != 0;
                Helper.sVerbose = (flags & 4) != 0;
                IAutoFillManager service = this.mService;
                IAutoFillManagerClient serviceClient = this.mServiceClient;
                this.mServiceClientCleaner = Cleaner.create((Object)this, () -> {
                    try {
                        service.removeClient(serviceClient, userId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null) {
                return;
            }
            boolean hadCallback = this.mCallback != null;
            this.mCallback = callback;
            if (!hadCallback) {
                try {
                    this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), true);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null || this.mCallback == null || callback != this.mCallback) {
                return;
            }
            this.mCallback = null;
            try {
                this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), false);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClient()) != null && client.autofillClientRequestShowFillUi(anchor, width, height, anchorBounds, presenter)) {
                callback = this.mCallback;
                this.mIdShownFillUi = id2;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 1);
            } else {
                callback.onAutofillEvent(anchor, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (sessionId == this.mSessionId && (client = this.getClient()) != null) {
                this.mOnInvisibleCalled = false;
                client.autofillClientAuthenticate(authenticationId, intent, fillInIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent keyEvent) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        Object callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClient()) != null) {
                client.autofillClientDispatchUnhandledKey(anchor, keyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int flags) {
        if (Helper.sVerbose) {
            Log.v(TAG, "setState(" + flags + ")");
        }
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.mEnabled = (flags & 1) != 0;
            if (!this.mEnabled || (flags & 2) != 0) {
                this.resetSessionLocked(true);
            }
            if ((flags & 4) != 0) {
                this.mServiceClient = null;
                if (this.mServiceClientCleaner != null) {
                    this.mServiceClientCleaner.clean();
                    this.mServiceClientCleaner = null;
                }
            }
        }
        Helper.sDebug = (flags & 8) != 0;
        Helper.sVerbose = (flags & 0x10) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAutofilledIfValuesIs(View view, AutofillValue targetValue) {
        AutofillValue currentValue = view.getAutofillValue();
        if (Objects.equals(currentValue, targetValue)) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(1);
                }
                this.mLastAutofilledData.put(view.getAutofillId(), targetValue);
            }
            view.setAutofilled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            if (sessionId != this.mSessionId) {
                return;
            }
            AutofillClient client = this.getClient();
            if (client == null) {
                return;
            }
            int itemCount = ids.size();
            int numApplied = 0;
            ArrayMap<View, SparseArray<AutofillValue>> virtualValues = null;
            View[] views = client.autofillClientFindViewsByAutofillIdTraversal(Helper.toArray(ids));
            ArrayList<AutofillId> failedIds = null;
            for (i = 0; i < itemCount; ++i) {
                AutofillId id2 = ids.get(i);
                AutofillValue value = values.get(i);
                int viewId = id2.getViewId();
                View view = views[i];
                if (view == null) {
                    Log.d(TAG, "autofill(): no View with id " + id2);
                    if (failedIds == null) {
                        failedIds = new ArrayList<AutofillId>();
                    }
                    failedIds.add(id2);
                    continue;
                }
                if (id2.isVirtual()) {
                    SparseArray<AutofillValue> valuesByParent;
                    if (virtualValues == null) {
                        virtualValues = new ArrayMap<View, SparseArray<AutofillValue>>(1);
                    }
                    if ((valuesByParent = (SparseArray<AutofillValue>)virtualValues.get(view)) == null) {
                        valuesByParent = new SparseArray<AutofillValue>(5);
                        virtualValues.put(view, valuesByParent);
                    }
                    valuesByParent.put(id2.getVirtualChildId(), value);
                    continue;
                }
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(itemCount - i);
                }
                this.mLastAutofilledData.put(id2, value);
                view.autofill(value);
                this.setAutofilledIfValuesIs(view, value);
                ++numApplied;
            }
            if (failedIds != null) {
                if (Helper.sVerbose) {
                    Log.v(TAG, "autofill(): total failed views: " + failedIds);
                }
                try {
                    this.mService.setAutofillFailure(this.mSessionId, failedIds, this.mContext.getUserId());
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
            if (virtualValues != null) {
                for (i = 0; i < virtualValues.size(); ++i) {
                    View parent = (View)virtualValues.keyAt(i);
                    SparseArray childrenValues = (SparseArray)virtualValues.valueAt(i);
                    parent.autofill(childrenValues);
                    numApplied += childrenValues.size();
                }
            }
            this.mMetricsLogger.write(this.newLog(913).addTaggedData(914, itemCount).addTaggedData(915, numApplied));
        }
    }

    private LogMaker newLog(int category) {
        AutofillClient client;
        LogMaker log = new LogMaker(category).addTaggedData(1456, this.mSessionId);
        if (this.isCompatibilityModeEnabledLocked()) {
            log.addTaggedData(1414, 1);
        }
        if ((client = this.getClient()) == null) {
            log.setPackageName(this.mContext.getPackageName());
        } else {
            log.setComponentName(client.autofillClientGetComponentName());
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTrackedViews(int sessionId, AutofillId[] trackedIds, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.mSessionId == sessionId) {
                this.mTrackedViews = saveOnAllViewsInvisible ? new TrackedViews(trackedIds) : null;
                this.mSaveOnFinish = saveOnFinish;
                if (fillableIds != null) {
                    if (this.mFillableIds == null) {
                        this.mFillableIds = new ArraySet(fillableIds.length);
                    }
                    for (AutofillId id2 : fillableIds) {
                        this.mFillableIds.add(id2);
                    }
                    if (Helper.sVerbose) {
                        Log.v(TAG, "setTrackedViews(): fillableIds=" + fillableIds + ", mFillableIds" + this.mFillableIds);
                    }
                }
                if (this.mSaveTriggerId != null && !this.mSaveTriggerId.equals(saveTriggerId)) {
                    this.setNotifyOnClickLocked(this.mSaveTriggerId, false);
                }
                if (saveTriggerId != null && !saveTriggerId.equals(this.mSaveTriggerId)) {
                    this.mSaveTriggerId = saveTriggerId;
                    this.setNotifyOnClickLocked(this.mSaveTriggerId, true);
                }
            }
        }
    }

    private void setNotifyOnClickLocked(AutofillId id2, boolean notify) {
        View view = this.findView(id2);
        if (view == null) {
            Log.w(TAG, "setNotifyOnClick(): invalid id: " + id2);
            return;
        }
        view.setNotifyAutofillManagerOnClick(notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSaveUiState(int sessionId, boolean shown) {
        if (Helper.sDebug) {
            Log.d(TAG, "setSaveUiState(" + sessionId + "): " + shown);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                Log.w(TAG, "setSaveUiState(" + sessionId + ", " + shown + ") called on existing session " + this.mSessionId + "; cancelling it");
                this.cancelSessionLocked();
            }
            if (shown) {
                this.mSessionId = sessionId;
                this.mState = 3;
            } else {
                this.mSessionId = Integer.MIN_VALUE;
                this.mState = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionFinished(int newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sVerbose) {
                Log.v(TAG, "setSessionFinished(): from " + this.getStateAsStringLocked() + " to " + AutofillManager.getStateAsString(newState));
            }
            if (newState == 5) {
                this.resetSessionLocked(true);
                this.mState = 0;
            } else {
                this.resetSessionLocked(false);
                this.mState = newState;
            }
        }
    }

    public void requestHideFillUi() {
        this.requestHideFillUi(this.mIdShownFillUi, true);
    }

    private void requestHideFillUi(AutofillId id2, boolean force) {
        View anchor;
        View view = anchor = id2 == null ? null : this.findView(id2);
        if (Helper.sVerbose) {
            Log.v(TAG, "requestHideFillUi(" + id2 + "): anchor = " + anchor);
        }
        if (anchor == null) {
            AutofillClient client;
            if (force && (client = this.getClient()) != null) {
                client.autofillClientRequestHideFillUi();
            }
            return;
        }
        this.requestHideFillUi(id2, anchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestHideFillUi(AutofillId id2, View anchor) {
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client = this.getClient();
            if (client != null && client.autofillClientRequestHideFillUi()) {
                this.mIdShownFillUi = null;
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 2);
            } else {
                callback.onAutofillEvent(anchor, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) {
        View anchor;
        if (Helper.sVerbose) {
            Log.v(TAG, "notifyNoFillUi(): sessionId=" + sessionId + ", autofillId=" + id2 + ", sessionFinishedState=" + sessionFinishedState);
        }
        if ((anchor = this.findView(id2)) == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId == sessionId && this.getClient() != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 3);
            } else {
                callback.onAutofillEvent(anchor, 3);
            }
        }
        if (sessionFinishedState != 0) {
            this.setSessionFinished(sessionFinishedState);
        }
    }

    private View findView(AutofillId autofillId) {
        AutofillClient client = this.getClient();
        if (client != null) {
            return client.autofillClientFindViewByAutofillIdTraversal(autofillId);
        }
        return null;
    }

    public boolean hasAutofillFeature() {
        return this.mService != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPendingSaveUi(int operation, IBinder token) {
        if (Helper.sVerbose) {
            Log.v(TAG, "onPendingSaveUi(" + operation + "): " + token);
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onPendingSaveUi(operation, token);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String outerPrefix, PrintWriter pw) {
        pw.print(outerPrefix);
        pw.println("AutofillManager:");
        String pfx = outerPrefix + "  ";
        pw.print(pfx);
        pw.print("sessionId: ");
        pw.println(this.mSessionId);
        pw.print(pfx);
        pw.print("state: ");
        pw.println(this.getStateAsStringLocked());
        pw.print(pfx);
        pw.print("context: ");
        pw.println(this.mContext);
        AutofillClient client = this.getClient();
        if (client != null) {
            pw.print(pfx);
            pw.print("client: ");
            pw.print(client);
            pw.print(" (");
            pw.print(client.autofillClientGetActivityToken());
            pw.println(')');
        }
        pw.print(pfx);
        pw.print("enabled: ");
        pw.println(this.mEnabled);
        pw.print(pfx);
        pw.print("hasService: ");
        pw.println(this.mService != null);
        pw.print(pfx);
        pw.print("hasCallback: ");
        pw.println(this.mCallback != null);
        pw.print(pfx);
        pw.print("onInvisibleCalled ");
        pw.println(this.mOnInvisibleCalled);
        pw.print(pfx);
        pw.print("last autofilled data: ");
        pw.println(this.mLastAutofilledData);
        pw.print(pfx);
        pw.print("tracked views: ");
        if (this.mTrackedViews == null) {
            pw.println("null");
        } else {
            String pfx2 = pfx + "  ";
            pw.println();
            pw.print(pfx2);
            pw.print("visible:");
            pw.println(this.mTrackedViews.mVisibleTrackedIds);
            pw.print(pfx2);
            pw.print("invisible:");
            pw.println(this.mTrackedViews.mInvisibleTrackedIds);
        }
        pw.print(pfx);
        pw.print("fillable ids: ");
        pw.println(this.mFillableIds);
        pw.print(pfx);
        pw.print("entered ids: ");
        pw.println(this.mEnteredIds);
        pw.print(pfx);
        pw.print("save trigger id: ");
        pw.println(this.mSaveTriggerId);
        pw.print(pfx);
        pw.print("save on finish(): ");
        pw.println(this.mSaveOnFinish);
        pw.print(pfx);
        pw.print("compat mode enabled: ");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCompatibilityBridge != null) {
                String pfx2 = pfx + "  ";
                pw.println("true");
                pw.print(pfx2);
                pw.print("windowId: ");
                pw.println(this.mCompatibilityBridge.mFocusedWindowId);
                pw.print(pfx2);
                pw.print("nodeId: ");
                pw.println(this.mCompatibilityBridge.mFocusedNodeId);
                pw.print(pfx2);
                pw.print("virtualId: ");
                pw.println(AccessibilityNodeInfo.getVirtualDescendantId(this.mCompatibilityBridge.mFocusedNodeId));
                pw.print(pfx2);
                pw.print("focusedBounds: ");
                pw.println(this.mCompatibilityBridge.mFocusedBounds);
            } else {
                pw.println("false");
            }
        }
        pw.print(pfx);
        pw.print("debug: ");
        pw.print(Helper.sDebug);
        pw.print(" verbose: ");
        pw.println(Helper.sVerbose);
    }

    @GuardedBy(value="mLock")
    private String getStateAsStringLocked() {
        return AutofillManager.getStateAsString(this.mState);
    }

    private static String getStateAsString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "FINISHED";
            }
            case 3: {
                return "SHOWING_SAVE_UI";
            }
            case 4: {
                return "DISABLED_BY_SERVICE";
            }
            case 5: {
                return "UNKNOWN_COMPAT_MODE";
            }
        }
        return "INVALID:" + state;
    }

    @GuardedBy(value="mLock")
    private boolean isActiveLocked() {
        return this.mState == 1;
    }

    @GuardedBy(value="mLock")
    private boolean isDisabledByServiceLocked() {
        return this.mState == 4;
    }

    @GuardedBy(value="mLock")
    private boolean isFinishedLocked() {
        return this.mState == 2;
    }

    private void post(Runnable runnable) {
        AutofillClient client = this.getClient();
        if (client == null) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring post() because client is null");
            }
            return;
        }
        client.autofillClientRunOnUiThread(runnable);
    }

    private static class AutofillManagerClient
    extends IAutoFillManagerClient.Stub {
        private final WeakReference<AutofillManager> mAfm;

        AutofillManagerClient(AutofillManager autofillManager) {
            this.mAfm = new WeakReference<AutofillManager>(autofillManager);
        }

        @Override
        public void setState(int flags) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setState(flags));
            }
        }

        @Override
        public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.autofill(sessionId, ids, values));
            }
        }

        @Override
        public void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.authenticate(sessionId, authenticationId, intent, fillInIntent));
            }
        }

        @Override
        public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestShowFillUi(sessionId, id2, width, height, anchorBounds, presenter));
            }
        }

        @Override
        public void requestHideFillUi(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestHideFillUi(id2, false));
            }
        }

        @Override
        public void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyNoFillUi(sessionId, id2, sessionFinishedState));
            }
        }

        @Override
        public void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent fullScreen) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.dispatchUnhandledKey(sessionId, id2, fullScreen));
            }
        }

        @Override
        public void startIntentSender(IntentSender intentSender, Intent intent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> {
                    try {
                        afm.mContext.startIntentSender(intentSender, intent, 0, 0, 0);
                    }
                    catch (IntentSender.SendIntentException e) {
                        Log.e(AutofillManager.TAG, "startIntentSender() failed for intent:" + intentSender, e);
                    }
                });
            }
        }

        @Override
        public void setTrackedViews(int sessionId, AutofillId[] ids, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setTrackedViews(sessionId, ids, saveOnAllViewsInvisible, saveOnFinish, fillableIds, saveTriggerId));
            }
        }

        @Override
        public void setSaveUiState(int sessionId, boolean shown) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSaveUiState(sessionId, shown));
            }
        }

        @Override
        public void setSessionFinished(int newState) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSessionFinished(newState));
            }
        }
    }

    public static abstract class AutofillCallback {
        public static final int EVENT_INPUT_SHOWN = 1;
        public static final int EVENT_INPUT_HIDDEN = 2;
        public static final int EVENT_INPUT_UNAVAILABLE = 3;

        public void onAutofillEvent(View view, int event) {
        }

        public void onAutofillEvent(View view, int virtualId, int event) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AutofillEventType {
        }
    }

    private class TrackedViews {
        private ArraySet<AutofillId> mVisibleTrackedIds;
        private ArraySet<AutofillId> mInvisibleTrackedIds;

        private <T> boolean isInSet(ArraySet<T> set, T value) {
            return set != null && set.contains(value);
        }

        private <T> ArraySet<T> addToSet(ArraySet<T> set, T valueToAdd) {
            if (set == null) {
                set = new ArraySet(1);
            }
            set.add(valueToAdd);
            return set;
        }

        private <T> ArraySet<T> removeFromSet(ArraySet<T> set, T valueToRemove) {
            if (set == null) {
                return null;
            }
            set.remove(valueToRemove);
            if (set.isEmpty()) {
                return null;
            }
            return set;
        }

        TrackedViews(AutofillId[] trackedIds) {
            AutofillClient client = AutofillManager.this.getClient();
            if (!ArrayUtils.isEmpty(trackedIds) && client != null) {
                boolean[] isVisible;
                if (client.autofillClientIsVisibleForAutofill()) {
                    if (Helper.sVerbose) {
                        Log.v(AutofillManager.TAG, "client is visible, check tracked ids");
                    }
                    isVisible = client.autofillClientGetViewVisibility(trackedIds);
                } else {
                    isVisible = new boolean[trackedIds.length];
                }
                int numIds = trackedIds.length;
                for (int i = 0; i < numIds; ++i) {
                    AutofillId id2 = trackedIds[i];
                    if (isVisible[i]) {
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                        continue;
                    }
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (Helper.sVerbose) {
                Log.v(AutofillManager.TAG, "TrackedViews(trackedIds=" + Arrays.toString(trackedIds) + "):  mVisibleTrackedIds=" + this.mVisibleTrackedIds + " mInvisibleTrackedIds=" + this.mInvisibleTrackedIds);
            }
            if (this.mVisibleTrackedIds == null) {
                AutofillManager.this.finishSessionLocked();
            }
        }

        @GuardedBy(value="mLock")
        void notifyViewVisibilityChangedLocked(AutofillId id2, boolean isVisible) {
            if (Helper.sDebug) {
                Log.d(AutofillManager.TAG, "notifyViewVisibilityChangedLocked(): id=" + id2 + " isVisible=" + isVisible);
            }
            if (AutofillManager.this.isClientVisibleForAutofillLocked()) {
                if (isVisible) {
                    if (this.isInSet(this.mInvisibleTrackedIds, id2)) {
                        this.mInvisibleTrackedIds = this.removeFromSet(this.mInvisibleTrackedIds, id2);
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                    }
                } else if (this.isInSet(this.mVisibleTrackedIds, id2)) {
                    this.mVisibleTrackedIds = this.removeFromSet(this.mVisibleTrackedIds, id2);
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v(AutofillManager.TAG, "No more visible ids. Invisibile = " + this.mInvisibleTrackedIds);
                }
                AutofillManager.this.finishSessionLocked();
            }
        }

        @GuardedBy(value="mLock")
        void onVisibleForAutofillChangedLocked() {
            AutofillClient client = AutofillManager.this.getClient();
            ArraySet<AutofillId> updatedVisibleTrackedIds = null;
            ArraySet<AutofillId> updatedInvisibleTrackedIds = null;
            if (client != null) {
                AutofillId id2;
                int i;
                boolean[] isVisible;
                if (Helper.sVerbose) {
                    Log.v(AutofillManager.TAG, "onVisibleForAutofillChangedLocked(): inv= " + this.mInvisibleTrackedIds + " vis=" + this.mVisibleTrackedIds);
                }
                if (this.mInvisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedInvisibleIds = new ArrayList<AutofillId>(this.mInvisibleTrackedIds);
                    isVisible = client.autofillClientGetViewVisibility(Helper.toArray(orderedInvisibleIds));
                    int numInvisibleTrackedIds = orderedInvisibleIds.size();
                    for (i = 0; i < numInvisibleTrackedIds; ++i) {
                        id2 = orderedInvisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            if (!Helper.sDebug) continue;
                            Log.d(AutofillManager.TAG, "onVisibleForAutofill() " + id2 + " became visible");
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                    }
                }
                if (this.mVisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedVisibleIds = new ArrayList<AutofillId>(this.mVisibleTrackedIds);
                    isVisible = client.autofillClientGetViewVisibility(Helper.toArray(orderedVisibleIds));
                    int numVisibleTrackedIds = orderedVisibleIds.size();
                    for (i = 0; i < numVisibleTrackedIds; ++i) {
                        id2 = orderedVisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                        if (!Helper.sDebug) continue;
                        Log.d(AutofillManager.TAG, "onVisibleForAutofill() " + id2 + " became invisible");
                    }
                }
                this.mInvisibleTrackedIds = updatedInvisibleTrackedIds;
                this.mVisibleTrackedIds = updatedVisibleTrackedIds;
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v(AutofillManager.TAG, "onVisibleForAutofillChangedLocked(): no more visible ids");
                }
                AutofillManager.this.finishSessionLocked();
            }
        }
    }

    private class CompatibilityBridge
    implements AccessibilityManager.AccessibilityPolicy {
        @GuardedBy(value="mLock")
        private final Rect mFocusedBounds = new Rect();
        @GuardedBy(value="mLock")
        private final Rect mTempBounds = new Rect();
        @GuardedBy(value="mLock")
        private int mFocusedWindowId = -1;
        @GuardedBy(value="mLock")
        private long mFocusedNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
        @GuardedBy(value="mLock")
        AccessibilityServiceInfo mCompatServiceInfo;

        CompatibilityBridge() {
            AccessibilityManager am = AccessibilityManager.getInstance(AutofillManager.this.mContext);
            am.setAccessibilityPolicy(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccessibilityServiceInfo getCompatServiceInfo() {
            Object object = AutofillManager.this.mLock;
            synchronized (object) {
                if (this.mCompatServiceInfo != null) {
                    return this.mCompatServiceInfo;
                }
                Intent intent = new Intent();
                intent.setComponent(new ComponentName("android", "com.android.server.autofill.AutofillCompatAccessibilityService"));
                ResolveInfo resolveInfo = AutofillManager.this.mContext.getPackageManager().resolveService(intent, 0x100080);
                try {
                    this.mCompatServiceInfo = new AccessibilityServiceInfo(resolveInfo, AutofillManager.this.mContext);
                }
                catch (IOException | XmlPullParserException e) {
                    Log.e(AutofillManager.TAG, "Cannot find compat autofill service:" + intent);
                    throw new IllegalStateException("Cannot find compat autofill service");
                }
                return this.mCompatServiceInfo;
            }
        }

        @Override
        public boolean isEnabled(boolean accessibilityEnabled) {
            return true;
        }

        @Override
        public int getRelevantEventTypes(int relevantEventTypes) {
            return relevantEventTypes | 8 | 0x10 | 1 | 0x800;
        }

        @Override
        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> installedServices) {
            if (installedServices == null) {
                installedServices = new ArrayList<AccessibilityServiceInfo>();
            }
            installedServices.add(this.getCompatServiceInfo());
            return installedServices;
        }

        @Override
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags, List<AccessibilityServiceInfo> enabledService) {
            if (enabledService == null) {
                enabledService = new ArrayList<AccessibilityServiceInfo>();
            }
            enabledService.add(this.getCompatServiceInfo());
            return enabledService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessibilityEvent onAccessibilityEvent(AccessibilityEvent event, boolean accessibilityEnabled, int relevantEventTypes) {
            int type = event.getEventType();
            if (Helper.sVerbose) {
                Log.v(AutofillManager.TAG, "onAccessibilityEvent(" + AccessibilityEvent.eventTypeToString(type) + "): virtualId=" + AccessibilityNodeInfo.getVirtualDescendantId(event.getSourceNodeId()) + ", client=" + AutofillManager.this.getClient());
            }
            switch (type) {
                case 8: {
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        long nodeId;
                        int windowId;
                        if (this.mFocusedWindowId == event.getWindowId() && this.mFocusedNodeId == event.getSourceNodeId()) {
                            return event;
                        }
                        if (this.mFocusedWindowId != -1 && this.mFocusedNodeId != AccessibilityNodeInfo.UNDEFINED_NODE_ID) {
                            this.notifyViewExited(this.mFocusedWindowId, this.mFocusedNodeId);
                            this.mFocusedWindowId = -1;
                            this.mFocusedNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
                            this.mFocusedBounds.set(0, 0, 0, 0);
                        }
                        if (this.notifyViewEntered(windowId = event.getWindowId(), nodeId = event.getSourceNodeId(), this.mFocusedBounds)) {
                            this.mFocusedWindowId = windowId;
                            this.mFocusedNodeId = nodeId;
                        }
                        break;
                    }
                }
                case 16: {
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        if (this.mFocusedWindowId == event.getWindowId() && this.mFocusedNodeId == event.getSourceNodeId()) {
                            this.notifyValueChanged(event.getWindowId(), event.getSourceNodeId());
                        }
                        break;
                    }
                }
                case 1: {
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        this.notifyViewClicked(event.getWindowId(), event.getSourceNodeId());
                        break;
                    }
                }
                case 2048: {
                    AutofillClient client = AutofillManager.this.getClient();
                    if (client == null) break;
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        if (client.autofillClientIsFillUiShowing()) {
                            this.notifyViewEntered(this.mFocusedWindowId, this.mFocusedNodeId, this.mFocusedBounds);
                        }
                        this.updateTrackedViewsLocked();
                        break;
                    }
                }
            }
            return accessibilityEnabled ? event : null;
        }

        private boolean notifyViewEntered(int windowId, long nodeId, Rect focusedBounds) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return false;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return false;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return false;
            }
            if (!node.isEditable()) {
                return false;
            }
            Rect newBounds = this.mTempBounds;
            node.getBoundsInScreen(newBounds);
            if (newBounds.equals(focusedBounds)) {
                return false;
            }
            focusedBounds.set(newBounds);
            AutofillManager.this.notifyViewEntered(view, virtualId, newBounds);
            return true;
        }

        private void notifyViewExited(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AutofillManager.this.notifyViewExited(view, virtualId);
        }

        private void notifyValueChanged(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return;
            }
            AutofillManager.this.notifyValueChanged(view, virtualId, AutofillValue.forText(node.getText()));
        }

        private void notifyViewClicked(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return;
            }
            AutofillManager.this.notifyViewClicked(view, virtualId);
        }

        @GuardedBy(value="mLock")
        private void updateTrackedViewsLocked() {
            if (AutofillManager.this.mTrackedViews != null) {
                AutofillManager.this.mTrackedViews.onVisibleForAutofillChangedLocked();
            }
        }

        private View findViewByAccessibilityId(int windowId, long nodeId) {
            AutofillClient client = AutofillManager.this.getClient();
            if (client == null) {
                return null;
            }
            int viewId = AccessibilityNodeInfo.getAccessibilityViewId(nodeId);
            return client.autofillClientFindViewByAccessibilityIdTraversal(viewId, windowId);
        }

        private AccessibilityNodeInfo findVirtualNodeByAccessibilityId(View view, int virtualId) {
            AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
            if (provider == null) {
                return null;
            }
            return provider.createAccessibilityNodeInfo(virtualId);
        }

        private boolean isVirtualNode(int nodeId) {
            return nodeId != -1 && nodeId != Integer.MAX_VALUE;
        }
    }

    public static interface AutofillClient {
        public void autofillClientAuthenticate(int var1, IntentSender var2, Intent var3);

        public void autofillClientResetableStateAvailable();

        public boolean autofillClientRequestShowFillUi(View var1, int var2, int var3, Rect var4, IAutofillWindowPresenter var5);

        public void autofillClientDispatchUnhandledKey(View var1, KeyEvent var2);

        public boolean autofillClientRequestHideFillUi();

        public boolean autofillClientIsFillUiShowing();

        public boolean[] autofillClientGetViewVisibility(AutofillId[] var1);

        public boolean autofillClientIsVisibleForAutofill();

        public boolean isDisablingEnterExitEventForAutofill();

        public View[] autofillClientFindViewsByAutofillIdTraversal(AutofillId[] var1);

        public View autofillClientFindViewByAutofillIdTraversal(AutofillId var1);

        public View autofillClientFindViewByAccessibilityIdTraversal(int var1, int var2);

        public void autofillClientRunOnUiThread(Runnable var1);

        public ComponentName autofillClientGetComponentName();

        public IBinder autofillClientGetActivityToken();

        public boolean autofillClientIsCompatibilityModeEnabled();

        public AutofillId autofillClientGetNextAutofillId();
    }
}

