/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.BidiRenderer;
import android.graphics.Paint_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.StaticLayout_Delegate;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.util.NativeAllocationRegistry_Delegate;

public class MeasuredParagraph_Delegate {
    private static final DelegateManager<MeasuredParagraphBuilder> sBuilderManager = new DelegateManager<MeasuredParagraphBuilder>(MeasuredParagraphBuilder.class);
    private static final DelegateManager<MeasuredParagraph_Delegate> sManager = new DelegateManager<MeasuredParagraph_Delegate>(MeasuredParagraph_Delegate.class);
    private static long sFinalizer = -1L;
    private long mNativeBuilderPtr;

    @LayoutlibDelegate
    static long nInitBuilder() {
        return sBuilderManager.addNewDelegate(new MeasuredParagraphBuilder());
    }

    @LayoutlibDelegate
    static void nAddStyleRun(long nativeBuilderPtr, long paintPtr, int start, int end, boolean isRtl) {
        MeasuredParagraphBuilder builder = sBuilderManager.getDelegate(nativeBuilderPtr);
        if (builder == null) {
            return;
        }
        builder.mRuns.add(new StyleRun(paintPtr, start, end, isRtl));
    }

    @LayoutlibDelegate
    static void nAddReplacementRun(long nativeBuilderPtr, long paintPtr, int start, int end, float width) {
        MeasuredParagraphBuilder builder = sBuilderManager.getDelegate(nativeBuilderPtr);
        if (builder == null) {
            return;
        }
        builder.mRuns.add(new ReplacementRun(start, end, width));
    }

    @LayoutlibDelegate
    static long nBuildNativeMeasuredParagraph(long nativeBuilderPtr, char[] text, boolean computeHyphenation, boolean computeLayout) {
        MeasuredParagraph_Delegate delegate = new MeasuredParagraph_Delegate();
        delegate.mNativeBuilderPtr = nativeBuilderPtr;
        return sManager.addNewDelegate(delegate);
    }

    @LayoutlibDelegate
    static void nFreeBuilder(long nativeBuilderPtr) {
        sBuilderManager.removeJavaReferenceFor(nativeBuilderPtr);
    }

    @LayoutlibDelegate
    static float nGetWidth(long nativePtr, int start, int end) {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetReleaseFunc() {
        Class<MeasuredParagraph_Delegate> clazz = MeasuredParagraph_Delegate.class;
        synchronized (MeasuredParagraph_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    @LayoutlibDelegate
    static int nGetMemoryUsage(long nativePtr) {
        return 0;
    }

    @LayoutlibDelegate
    static void nGetBounds(long nativePtr, char[] buf, int start, int end, Rect rect) {
    }

    private static float measureText(long nativePaint, char[] text, int index, int count, float[] widths, int bidiFlags) {
        Paint_Delegate paint = Paint_Delegate.getDelegate(nativePaint);
        RectF bounds = new BidiRenderer(null, paint, text).renderText(index, index + count, bidiFlags, widths, 0, false);
        return bounds.right - bounds.left;
    }

    public static void computeRuns(long measuredTextPtr, StaticLayout_Delegate.Builder staticLayoutBuilder) {
        MeasuredParagraph_Delegate delegate = sManager.getDelegate(measuredTextPtr);
        if (delegate == null) {
            return;
        }
        MeasuredParagraphBuilder builder = sBuilderManager.getDelegate(delegate.mNativeBuilderPtr);
        if (builder == null) {
            return;
        }
        for (StaticLayout_Delegate.Run run : builder.mRuns) {
            run.addTo(staticLayoutBuilder);
        }
    }

    private static class MeasuredParagraphBuilder {
        private final ArrayList<StaticLayout_Delegate.Run> mRuns = new ArrayList();

        private MeasuredParagraphBuilder() {
        }
    }

    private static class ReplacementRun
    extends StaticLayout_Delegate.Run {
        private final float mWidth;

        private ReplacementRun(int start, int end, float width) {
            super(start, end);
            this.mWidth = width;
        }

        @Override
        void addTo(StaticLayout_Delegate.Builder builder) {
            builder.mWidths[this.mStart] = this.mWidth;
            Arrays.fill(builder.mWidths, this.mStart + 1, this.mEnd, 0.0f);
        }
    }

    private static class StyleRun
    extends StaticLayout_Delegate.Run {
        private final long mNativePaint;
        private final boolean mIsRtl;

        private StyleRun(long nativePaint, int start, int end, boolean isRtl) {
            super(start, end);
            this.mNativePaint = nativePaint;
            this.mIsRtl = isRtl;
        }

        @Override
        void addTo(StaticLayout_Delegate.Builder builder) {
            int bidiFlags = this.mIsRtl ? 5 : 4;
            MeasuredParagraph_Delegate.measureText(this.mNativePaint, builder.mText, this.mStart, this.mEnd - this.mStart, builder.mWidths, bidiFlags);
        }
    }
}

