/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class ApnSetting
implements Parcelable {
    private static final String LOG_TAG = "ApnSetting";
    private static final boolean VDBG = false;
    private static final Map<String, Integer> APN_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
    private static final Map<Integer, String> APN_TYPE_INT_MAP;
    private static final Map<String, Integer> PROTOCOL_STRING_MAP;
    private static final Map<Integer, String> PROTOCOL_INT_MAP;
    private static final Map<String, Integer> MVNO_TYPE_STRING_MAP;
    private static final Map<Integer, String> MVNO_TYPE_INT_MAP;
    private static final int NOT_IN_MAP_INT = -1;
    private static final int NO_PORT_SPECIFIED = -1;
    private static final int TYPE_ALL_BUT_IA = 767;
    public static final int TYPE_DEFAULT = 17;
    public static final int TYPE_MMS = 2;
    public static final int TYPE_SUPL = 4;
    public static final int TYPE_DUN = 8;
    public static final int TYPE_HIPRI = 16;
    public static final int TYPE_FOTA = 32;
    public static final int TYPE_IMS = 64;
    public static final int TYPE_CBS = 128;
    public static final int TYPE_IA = 256;
    public static final int TYPE_EMERGENCY = 512;
    public static final int AUTH_TYPE_NONE = 0;
    public static final int AUTH_TYPE_PAP = 1;
    public static final int AUTH_TYPE_CHAP = 2;
    public static final int AUTH_TYPE_PAP_OR_CHAP = 3;
    public static final int PROTOCOL_IP = 0;
    public static final int PROTOCOL_IPV6 = 1;
    public static final int PROTOCOL_IPV4V6 = 2;
    public static final int PROTOCOL_PPP = 3;
    public static final int MVNO_TYPE_SPN = 0;
    public static final int MVNO_TYPE_IMSI = 1;
    public static final int MVNO_TYPE_GID = 2;
    public static final int MVNO_TYPE_ICCID = 3;
    private final String mEntryName;
    private final String mApnName;
    private final InetAddress mProxyAddress;
    private final int mProxyPort;
    private final Uri mMmsc;
    private final InetAddress mMmsProxyAddress;
    private final int mMmsProxyPort;
    private final String mUser;
    private final String mPassword;
    private final int mAuthType;
    private final int mApnTypeBitmask;
    private final int mId;
    private final String mOperatorNumeric;
    private final int mProtocol;
    private final int mRoamingProtocol;
    private final int mMtu;
    private final boolean mCarrierEnabled;
    private final int mNetworkTypeBitmask;
    private final int mProfileId;
    private final boolean mModemCognitive;
    private final int mMaxConns;
    private final int mWaitTime;
    private final int mMaxConnsTime;
    private final int mMvnoType;
    private final String mMvnoMatchData;
    private boolean mPermanentFailed = false;
    public static final Parcelable.Creator<ApnSetting> CREATOR;

    public int getMtu() {
        return this.mMtu;
    }

    public int getProfileId() {
        return this.mProfileId;
    }

    public boolean getModemCognitive() {
        return this.mModemCognitive;
    }

    public int getMaxConns() {
        return this.mMaxConns;
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public int getMaxConnsTime() {
        return this.mMaxConnsTime;
    }

    public String getMvnoMatchData() {
        return this.mMvnoMatchData;
    }

    public boolean getPermanentFailed() {
        return this.mPermanentFailed;
    }

    public void setPermanentFailed(boolean permanentFailed) {
        this.mPermanentFailed = permanentFailed;
    }

    public String getEntryName() {
        return this.mEntryName;
    }

    public String getApnName() {
        return this.mApnName;
    }

    public InetAddress getProxyAddress() {
        return this.mProxyAddress;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public Uri getMmsc() {
        return this.mMmsc;
    }

    public InetAddress getMmsProxyAddress() {
        return this.mMmsProxyAddress;
    }

    public int getMmsProxyPort() {
        return this.mMmsProxyPort;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getAuthType() {
        return this.mAuthType;
    }

    public int getApnTypeBitmask() {
        return this.mApnTypeBitmask;
    }

    public int getId() {
        return this.mId;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public int getRoamingProtocol() {
        return this.mRoamingProtocol;
    }

    public boolean isEnabled() {
        return this.mCarrierEnabled;
    }

    public int getNetworkTypeBitmask() {
        return this.mNetworkTypeBitmask;
    }

    public int getMvnoType() {
        return this.mMvnoType;
    }

    private ApnSetting(Builder builder) {
        this.mEntryName = builder.mEntryName;
        this.mApnName = builder.mApnName;
        this.mProxyAddress = builder.mProxyAddress;
        this.mProxyPort = builder.mProxyPort;
        this.mMmsc = builder.mMmsc;
        this.mMmsProxyAddress = builder.mMmsProxyAddress;
        this.mMmsProxyPort = builder.mMmsProxyPort;
        this.mUser = builder.mUser;
        this.mPassword = builder.mPassword;
        this.mAuthType = builder.mAuthType;
        this.mApnTypeBitmask = builder.mApnTypeBitmask;
        this.mId = builder.mId;
        this.mOperatorNumeric = builder.mOperatorNumeric;
        this.mProtocol = builder.mProtocol;
        this.mRoamingProtocol = builder.mRoamingProtocol;
        this.mMtu = builder.mMtu;
        this.mCarrierEnabled = builder.mCarrierEnabled;
        this.mNetworkTypeBitmask = builder.mNetworkTypeBitmask;
        this.mProfileId = builder.mProfileId;
        this.mModemCognitive = builder.mModemCognitive;
        this.mMaxConns = builder.mMaxConns;
        this.mWaitTime = builder.mWaitTime;
        this.mMaxConnsTime = builder.mMaxConnsTime;
        this.mMvnoType = builder.mMvnoType;
        this.mMvnoMatchData = builder.mMvnoMatchData;
    }

    public static ApnSetting makeApnSetting(int id2, String operatorNumeric, String entryName, String apnName, InetAddress proxy, int port, Uri mmsc, InetAddress mmsProxy, int mmsPort, String user, String password, int authType, int mApnTypeBitmask, int protocol, int roamingProtocol, boolean carrierEnabled, int networkTypeBitmask, int profileId, boolean modemCognitive, int maxConns, int waitTime, int maxConnsTime, int mtu, int mvnoType, String mvnoMatchData) {
        return new Builder().setId(id2).setOperatorNumeric(operatorNumeric).setEntryName(entryName).setApnName(apnName).setProxyAddress(proxy).setProxyPort(port).setMmsc(mmsc).setMmsProxyAddress(mmsProxy).setMmsProxyPort(mmsPort).setUser(user).setPassword(password).setAuthType(authType).setApnTypeBitmask(mApnTypeBitmask).setProtocol(protocol).setRoamingProtocol(roamingProtocol).setCarrierEnabled(carrierEnabled).setNetworkTypeBitmask(networkTypeBitmask).setProfileId(profileId).setModemCognitive(modemCognitive).setMaxConns(maxConns).setWaitTime(waitTime).setMaxConnsTime(maxConnsTime).setMtu(mtu).setMvnoType(mvnoType).setMvnoMatchData(mvnoMatchData).build();
    }

    public static ApnSetting makeApnSetting(Cursor cursor) {
        int apnTypesBitmask = ApnSetting.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
        int networkTypeBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("network_type_bitmask"));
        if (networkTypeBitmask == 0) {
            int bearerBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("bearer_bitmask"));
            networkTypeBitmask = ServiceState.convertBearerBitmaskToNetworkTypeBitmask(bearerBitmask);
        }
        return ApnSetting.makeApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), ApnSetting.inetAddressFromString(cursor.getString(cursor.getColumnIndexOrThrow("proxy"))), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("port"))), ApnSetting.UriFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsc"))), ApnSetting.inetAddressFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy"))), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsport"))), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), apnTypesBitmask, ApnSetting.nullToNotInMapInt(PROTOCOL_STRING_MAP.get(cursor.getString(cursor.getColumnIndexOrThrow("protocol")))), ApnSetting.nullToNotInMapInt(PROTOCOL_STRING_MAP.get(cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")))), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_enabled")) == 1, networkTypeBitmask, cursor.getInt(cursor.getColumnIndexOrThrow("profile_id")), cursor.getInt(cursor.getColumnIndexOrThrow("modem_cognitive")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("max_conns")), cursor.getInt(cursor.getColumnIndexOrThrow("wait_time")), cursor.getInt(cursor.getColumnIndexOrThrow("max_conns_time")), cursor.getInt(cursor.getColumnIndexOrThrow("mtu")), ApnSetting.nullToNotInMapInt(MVNO_TYPE_STRING_MAP.get(cursor.getString(cursor.getColumnIndexOrThrow("mvno_type")))), cursor.getString(cursor.getColumnIndexOrThrow("mvno_match_data")));
    }

    public static ApnSetting makeApnSetting(ApnSetting apn) {
        return ApnSetting.makeApnSetting(apn.mId, apn.mOperatorNumeric, apn.mEntryName, apn.mApnName, apn.mProxyAddress, apn.mProxyPort, apn.mMmsc, apn.mMmsProxyAddress, apn.mMmsProxyPort, apn.mUser, apn.mPassword, apn.mAuthType, apn.mApnTypeBitmask, apn.mProtocol, apn.mRoamingProtocol, apn.mCarrierEnabled, apn.mNetworkTypeBitmask, apn.mProfileId, apn.mModemCognitive, apn.mMaxConns, apn.mWaitTime, apn.mMaxConnsTime, apn.mMtu, apn.mMvnoType, apn.mMvnoMatchData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ApnSettingV4] ").append(this.mEntryName).append(", ").append(this.mId).append(", ").append(this.mOperatorNumeric).append(", ").append(this.mApnName).append(", ").append(ApnSetting.inetAddressToString(this.mProxyAddress)).append(", ").append(ApnSetting.UriToString(this.mMmsc)).append(", ").append(ApnSetting.inetAddressToString(this.mMmsProxyAddress)).append(", ").append(ApnSetting.portToString(this.mMmsProxyPort)).append(", ").append(ApnSetting.portToString(this.mProxyPort)).append(", ").append(this.mAuthType).append(", ");
        Object[] types = this.deParseTypes(this.mApnTypeBitmask).split(",");
        sb.append(TextUtils.join((CharSequence)" | ", types)).append(", ");
        sb.append(", ").append(this.mProtocol);
        sb.append(", ").append(this.mRoamingProtocol);
        sb.append(", ").append(this.mCarrierEnabled);
        sb.append(", ").append(this.mProfileId);
        sb.append(", ").append(this.mModemCognitive);
        sb.append(", ").append(this.mMaxConns);
        sb.append(", ").append(this.mWaitTime);
        sb.append(", ").append(this.mMaxConnsTime);
        sb.append(", ").append(this.mMtu);
        sb.append(", ").append(this.mMvnoType);
        sb.append(", ").append(this.mMvnoMatchData);
        sb.append(", ").append(this.mPermanentFailed);
        sb.append(", ").append(this.mNetworkTypeBitmask);
        return sb.toString();
    }

    public boolean hasMvnoParams() {
        return this.mMvnoType != -1 && !TextUtils.isEmpty(this.mMvnoMatchData);
    }

    public boolean canHandleType(int type) {
        return this.mCarrierEnabled && (this.mApnTypeBitmask & type) == type;
    }

    private boolean typeSameAny(ApnSetting first, ApnSetting second) {
        return (first.mApnTypeBitmask & second.mApnTypeBitmask) != 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return this.mEntryName.equals(other.mEntryName) && Objects.equals(this.mId, other.mId) && Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) && Objects.equals(this.mApnName, other.mApnName) && Objects.equals(this.mProxyAddress, other.mProxyAddress) && Objects.equals(this.mMmsc, other.mMmsc) && Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) && Objects.equals(this.mMmsProxyPort, other.mMmsProxyPort) && Objects.equals(this.mProxyPort, other.mProxyPort) && Objects.equals(this.mUser, other.mUser) && Objects.equals(this.mPassword, other.mPassword) && Objects.equals(this.mAuthType, other.mAuthType) && Objects.equals(this.mApnTypeBitmask, other.mApnTypeBitmask) && Objects.equals(this.mProtocol, other.mProtocol) && Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mModemCognitive, other.mModemCognitive) && Objects.equals(this.mMaxConns, other.mMaxConns) && Objects.equals(this.mWaitTime, other.mWaitTime) && Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) && Objects.equals(this.mMtu, other.mMtu) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask);
    }

    public boolean equals(Object o, boolean isDataRoaming) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return !(!this.mEntryName.equals(other.mEntryName) || !Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) || !Objects.equals(this.mApnName, other.mApnName) || !Objects.equals(this.mProxyAddress, other.mProxyAddress) || !Objects.equals(this.mMmsc, other.mMmsc) || !Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) || !Objects.equals(this.mMmsProxyPort, other.mMmsProxyPort) || !Objects.equals(this.mProxyPort, other.mProxyPort) || !Objects.equals(this.mUser, other.mUser) || !Objects.equals(this.mPassword, other.mPassword) || !Objects.equals(this.mAuthType, other.mAuthType) || !Objects.equals(this.mApnTypeBitmask, other.mApnTypeBitmask) || !isDataRoaming && !Objects.equals(this.mProtocol, other.mProtocol) || isDataRoaming && !Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) || !Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) || !Objects.equals(this.mProfileId, other.mProfileId) || !Objects.equals(this.mModemCognitive, other.mModemCognitive) || !Objects.equals(this.mMaxConns, other.mMaxConns) || !Objects.equals(this.mWaitTime, other.mWaitTime) || !Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) || !Objects.equals(this.mMtu, other.mMtu) || !Objects.equals(this.mMvnoType, other.mMvnoType) || !Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData));
    }

    public boolean similar(ApnSetting other) {
        return !this.canHandleType(8) && !other.canHandleType(8) && Objects.equals(this.mApnName, other.mApnName) && !this.typeSameAny(this, other) && this.xorEquals(this.mProxyAddress, other.mProxyAddress) && this.xorEqualsPort(this.mProxyPort, other.mProxyPort) && this.xorEquals(this.mProtocol, other.mProtocol) && this.xorEquals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && this.xorEquals(this.mMmsc, other.mMmsc) && this.xorEquals(this.mMmsProxyAddress, other.mMmsProxyAddress) && this.xorEqualsPort(this.mMmsProxyPort, other.mMmsProxyPort) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask);
    }

    private boolean xorEquals(String first, String second) {
        return Objects.equals(first, second) || TextUtils.isEmpty(first) || TextUtils.isEmpty(second);
    }

    private boolean xorEquals(Object first, Object second) {
        return first == null || second == null || first.equals(second);
    }

    private boolean xorEqualsPort(int first, int second) {
        return first == -1 || second == -1 || Objects.equals(first, second);
    }

    private String deParseTypes(int apnTypeBitmask) {
        ArrayList<String> types = new ArrayList<String>();
        for (Integer type : APN_TYPE_INT_MAP.keySet()) {
            if ((apnTypeBitmask & type) != type) continue;
            types.add(APN_TYPE_INT_MAP.get(type));
        }
        return TextUtils.join((CharSequence)",", types);
    }

    private String nullToEmpty(String stringValue) {
        return stringValue == null ? "" : stringValue;
    }

    public ContentValues toContentValues() {
        ContentValues apnValue = new ContentValues();
        apnValue.put("numeric", this.nullToEmpty(this.mOperatorNumeric));
        apnValue.put("name", this.nullToEmpty(this.mEntryName));
        apnValue.put("apn", this.nullToEmpty(this.mApnName));
        apnValue.put("proxy", this.mProxyAddress == null ? "" : ApnSetting.inetAddressToString(this.mProxyAddress));
        apnValue.put("port", ApnSetting.portToString(this.mProxyPort));
        apnValue.put("mmsc", this.mMmsc == null ? "" : ApnSetting.UriToString(this.mMmsc));
        apnValue.put("mmsport", ApnSetting.portToString(this.mMmsProxyPort));
        apnValue.put("mmsproxy", this.mMmsProxyAddress == null ? "" : ApnSetting.inetAddressToString(this.mMmsProxyAddress));
        apnValue.put("user", this.nullToEmpty(this.mUser));
        apnValue.put("password", this.nullToEmpty(this.mPassword));
        apnValue.put("authtype", this.mAuthType);
        String apnType = this.deParseTypes(this.mApnTypeBitmask);
        apnValue.put("type", this.nullToEmpty(apnType));
        apnValue.put("protocol", this.nullToEmpty(PROTOCOL_INT_MAP.get(this.mProtocol)));
        apnValue.put("roaming_protocol", this.nullToEmpty(PROTOCOL_INT_MAP.get(this.mRoamingProtocol)));
        apnValue.put("carrier_enabled", this.mCarrierEnabled);
        apnValue.put("mvno_type", this.nullToEmpty(MVNO_TYPE_INT_MAP.get(this.mMvnoType)));
        apnValue.put("network_type_bitmask", this.mNetworkTypeBitmask);
        return apnValue;
    }

    public static int parseTypes(String types) {
        if (TextUtils.isEmpty(types)) {
            return 767;
        }
        int result = 0;
        for (String str : types.split(",")) {
            Integer type = APN_TYPE_STRING_MAP.get(str);
            if (type == null) continue;
            result |= type.intValue();
        }
        return result;
    }

    private static Uri UriFromString(String uri) {
        return TextUtils.isEmpty(uri) ? null : Uri.parse(uri);
    }

    private static String UriToString(Uri uri) {
        return uri == null ? "" : uri.toString();
    }

    private static InetAddress inetAddressFromString(String inetAddress) {
        if (TextUtils.isEmpty(inetAddress)) {
            return null;
        }
        try {
            return InetAddress.getByName(inetAddress);
        }
        catch (UnknownHostException e) {
            Log.e(LOG_TAG, "Can't parse InetAddress from string: unknown host.");
            return null;
        }
    }

    private static String inetAddressToString(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        String inetAddressString = inetAddress.toString();
        if (TextUtils.isEmpty(inetAddressString)) {
            return null;
        }
        String hostName = inetAddressString.substring(0, inetAddressString.indexOf("/"));
        String address = inetAddressString.substring(inetAddressString.indexOf("/") + 1);
        if (TextUtils.isEmpty(hostName) && TextUtils.isEmpty(address)) {
            return null;
        }
        return TextUtils.isEmpty(hostName) ? address : hostName;
    }

    private static int portFromString(String strPort) {
        int port = -1;
        if (!TextUtils.isEmpty(strPort)) {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                Log.e(LOG_TAG, "Can't parse port from String");
            }
        }
        return port;
    }

    private static String portToString(int port) {
        return port == -1 ? "" : Integer.toString(port);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mOperatorNumeric);
        dest.writeString(this.mEntryName);
        dest.writeString(this.mApnName);
        dest.writeValue(this.mProxyAddress);
        dest.writeInt(this.mProxyPort);
        dest.writeValue(this.mMmsc);
        dest.writeValue(this.mMmsProxyAddress);
        dest.writeInt(this.mMmsProxyPort);
        dest.writeString(this.mUser);
        dest.writeString(this.mPassword);
        dest.writeInt(this.mAuthType);
        dest.writeInt(this.mApnTypeBitmask);
        dest.writeInt(this.mProtocol);
        dest.writeInt(this.mRoamingProtocol);
        dest.writeInt(this.mCarrierEnabled ? 1 : 0);
        dest.writeInt(this.mMvnoType);
        dest.writeInt(this.mNetworkTypeBitmask);
    }

    private static ApnSetting readFromParcel(Parcel in) {
        int id2 = in.readInt();
        String operatorNumeric = in.readString();
        String entryName = in.readString();
        String apnName = in.readString();
        InetAddress proxy = (InetAddress)in.readValue(InetAddress.class.getClassLoader());
        int port = in.readInt();
        Uri mmsc = (Uri)in.readValue(Uri.class.getClassLoader());
        InetAddress mmsProxy = (InetAddress)in.readValue(InetAddress.class.getClassLoader());
        int mmsPort = in.readInt();
        String user = in.readString();
        String password = in.readString();
        int authType = in.readInt();
        int apnTypesBitmask = in.readInt();
        int protocol = in.readInt();
        int roamingProtocol = in.readInt();
        boolean carrierEnabled = in.readInt() > 0;
        int mvnoType = in.readInt();
        int networkTypeBitmask = in.readInt();
        return ApnSetting.makeApnSetting(id2, operatorNumeric, entryName, apnName, proxy, port, mmsc, mmsProxy, mmsPort, user, password, authType, apnTypesBitmask, protocol, roamingProtocol, carrierEnabled, networkTypeBitmask, 0, false, 0, 0, 0, 0, mvnoType, null);
    }

    private static int nullToNotInMapInt(Integer value) {
        return value == null ? -1 : value;
    }

    static {
        APN_TYPE_STRING_MAP.put("*", 767);
        APN_TYPE_STRING_MAP.put("default", 17);
        APN_TYPE_STRING_MAP.put("mms", 2);
        APN_TYPE_STRING_MAP.put("supl", 4);
        APN_TYPE_STRING_MAP.put("dun", 8);
        APN_TYPE_STRING_MAP.put("hipri", 16);
        APN_TYPE_STRING_MAP.put("fota", 32);
        APN_TYPE_STRING_MAP.put("ims", 64);
        APN_TYPE_STRING_MAP.put("cbs", 128);
        APN_TYPE_STRING_MAP.put("ia", 256);
        APN_TYPE_STRING_MAP.put("emergency", 512);
        APN_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        APN_TYPE_INT_MAP.put(17, "default");
        APN_TYPE_INT_MAP.put(2, "mms");
        APN_TYPE_INT_MAP.put(4, "supl");
        APN_TYPE_INT_MAP.put(8, "dun");
        APN_TYPE_INT_MAP.put(16, "hipri");
        APN_TYPE_INT_MAP.put(32, "fota");
        APN_TYPE_INT_MAP.put(64, "ims");
        APN_TYPE_INT_MAP.put(128, "cbs");
        APN_TYPE_INT_MAP.put(256, "ia");
        APN_TYPE_INT_MAP.put(512, "emergency");
        PROTOCOL_STRING_MAP = new ArrayMap<String, Integer>();
        PROTOCOL_STRING_MAP.put("IP", 0);
        PROTOCOL_STRING_MAP.put("IPV6", 1);
        PROTOCOL_STRING_MAP.put("IPV4V6", 2);
        PROTOCOL_STRING_MAP.put("PPP", 3);
        PROTOCOL_INT_MAP = new ArrayMap<Integer, String>();
        PROTOCOL_INT_MAP.put(0, "IP");
        PROTOCOL_INT_MAP.put(1, "IPV6");
        PROTOCOL_INT_MAP.put(2, "IPV4V6");
        PROTOCOL_INT_MAP.put(3, "PPP");
        MVNO_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
        MVNO_TYPE_STRING_MAP.put("spn", 0);
        MVNO_TYPE_STRING_MAP.put("imsi", 1);
        MVNO_TYPE_STRING_MAP.put("gid", 2);
        MVNO_TYPE_STRING_MAP.put("iccid", 3);
        MVNO_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        MVNO_TYPE_INT_MAP.put(0, "spn");
        MVNO_TYPE_INT_MAP.put(1, "imsi");
        MVNO_TYPE_INT_MAP.put(2, "gid");
        MVNO_TYPE_INT_MAP.put(3, "iccid");
        CREATOR = new Parcelable.Creator<ApnSetting>(){

            @Override
            public ApnSetting createFromParcel(Parcel in) {
                return ApnSetting.readFromParcel(in);
            }

            public ApnSetting[] newArray(int size) {
                return new ApnSetting[size];
            }
        };
    }

    public static class Builder {
        private String mEntryName;
        private String mApnName;
        private InetAddress mProxyAddress;
        private int mProxyPort = -1;
        private Uri mMmsc;
        private InetAddress mMmsProxyAddress;
        private int mMmsProxyPort = -1;
        private String mUser;
        private String mPassword;
        private int mAuthType;
        private int mApnTypeBitmask;
        private int mId;
        private String mOperatorNumeric;
        private int mProtocol = -1;
        private int mRoamingProtocol = -1;
        private int mMtu;
        private int mNetworkTypeBitmask;
        private boolean mCarrierEnabled;
        private int mProfileId;
        private boolean mModemCognitive;
        private int mMaxConns;
        private int mWaitTime;
        private int mMaxConnsTime;
        private int mMvnoType = -1;
        private String mMvnoMatchData;

        private Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        public Builder setProfileId(int profileId) {
            this.mProfileId = profileId;
            return this;
        }

        public Builder setModemCognitive(boolean modemCognitive) {
            this.mModemCognitive = modemCognitive;
            return this;
        }

        public Builder setMaxConns(int maxConns) {
            this.mMaxConns = maxConns;
            return this;
        }

        public Builder setWaitTime(int waitTime) {
            this.mWaitTime = waitTime;
            return this;
        }

        public Builder setMaxConnsTime(int maxConnsTime) {
            this.mMaxConnsTime = maxConnsTime;
            return this;
        }

        public Builder setMvnoMatchData(String mvnoMatchData) {
            this.mMvnoMatchData = mvnoMatchData;
            return this;
        }

        public Builder setEntryName(String entryName) {
            this.mEntryName = entryName;
            return this;
        }

        public Builder setApnName(String apnName) {
            this.mApnName = apnName;
            return this;
        }

        public Builder setProxyAddress(InetAddress proxy) {
            this.mProxyAddress = proxy;
            return this;
        }

        public Builder setProxyPort(int port) {
            this.mProxyPort = port;
            return this;
        }

        public Builder setMmsc(Uri mmsc) {
            this.mMmsc = mmsc;
            return this;
        }

        public Builder setMmsProxyAddress(InetAddress mmsProxy) {
            this.mMmsProxyAddress = mmsProxy;
            return this;
        }

        public Builder setMmsProxyPort(int mmsPort) {
            this.mMmsProxyPort = mmsPort;
            return this;
        }

        public Builder setUser(String user) {
            this.mUser = user;
            return this;
        }

        public Builder setPassword(String password) {
            this.mPassword = password;
            return this;
        }

        public Builder setAuthType(int authType) {
            this.mAuthType = authType;
            return this;
        }

        public Builder setApnTypeBitmask(int apnTypeBitmask) {
            this.mApnTypeBitmask = apnTypeBitmask;
            return this;
        }

        public Builder setOperatorNumeric(String operatorNumeric) {
            this.mOperatorNumeric = operatorNumeric;
            return this;
        }

        public Builder setProtocol(int protocol) {
            this.mProtocol = protocol;
            return this;
        }

        public Builder setRoamingProtocol(int roamingProtocol) {
            this.mRoamingProtocol = roamingProtocol;
            return this;
        }

        public Builder setCarrierEnabled(boolean carrierEnabled) {
            this.mCarrierEnabled = carrierEnabled;
            return this;
        }

        public Builder setNetworkTypeBitmask(int networkTypeBitmask) {
            this.mNetworkTypeBitmask = networkTypeBitmask;
            return this;
        }

        public Builder setMvnoType(int mvnoType) {
            this.mMvnoType = mvnoType;
            return this;
        }

        public ApnSetting build() {
            if ((this.mApnTypeBitmask & 0x3FF) == 0 || TextUtils.isEmpty(this.mApnName) || TextUtils.isEmpty(this.mEntryName)) {
                return null;
            }
            return new ApnSetting(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MvnoType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApnType {
    }
}

