/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.cas.V1_0;

import android.hidl.base.V1_0.DebugInfo;
import android.hidl.base.V1_0.IBase;
import android.os.HidlSupport;
import android.os.HwBinder;
import android.os.HwBlob;
import android.os.HwParcel;
import android.os.IHwBinder;
import android.os.IHwInterface;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public interface ICas
extends IBase {
    public static final String kInterfaceName = "android.hardware.cas@1.0::ICas";

    public static ICas asInterface(IHwBinder binder) {
        if (binder == null) {
            return null;
        }
        IHwInterface iface = binder.queryLocalInterface(kInterfaceName);
        if (iface != null && iface instanceof ICas) {
            return (ICas)iface;
        }
        Proxy proxy = new Proxy(binder);
        try {
            for (String descriptor : proxy.interfaceChain()) {
                if (!descriptor.equals(kInterfaceName)) continue;
                return proxy;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public static ICas castFrom(IHwInterface iface) {
        return iface == null ? null : ICas.asInterface(iface.asBinder());
    }

    @Override
    public IHwBinder asBinder();

    public static ICas getService(String serviceName, boolean retry) throws RemoteException {
        return ICas.asInterface(HwBinder.getService(kInterfaceName, serviceName, retry));
    }

    public static ICas getService(boolean retry) throws RemoteException {
        return ICas.getService("default", retry);
    }

    public static ICas getService(String serviceName) throws RemoteException {
        return ICas.asInterface(HwBinder.getService(kInterfaceName, serviceName));
    }

    public static ICas getService() throws RemoteException {
        return ICas.getService("default");
    }

    public int setPrivateData(ArrayList<Byte> var1) throws RemoteException;

    public void openSession(openSessionCallback var1) throws RemoteException;

    public int closeSession(ArrayList<Byte> var1) throws RemoteException;

    public int setSessionPrivateData(ArrayList<Byte> var1, ArrayList<Byte> var2) throws RemoteException;

    public int processEcm(ArrayList<Byte> var1, ArrayList<Byte> var2) throws RemoteException;

    public int processEmm(ArrayList<Byte> var1) throws RemoteException;

    public int sendEvent(int var1, int var2, ArrayList<Byte> var3) throws RemoteException;

    public int provision(String var1) throws RemoteException;

    public int refreshEntitlements(int var1, ArrayList<Byte> var2) throws RemoteException;

    public int release() throws RemoteException;

    @Override
    public ArrayList<String> interfaceChain() throws RemoteException;

    @Override
    public String interfaceDescriptor() throws RemoteException;

    @Override
    public ArrayList<byte[]> getHashChain() throws RemoteException;

    @Override
    public void setHALInstrumentation() throws RemoteException;

    @Override
    public boolean linkToDeath(IHwBinder.DeathRecipient var1, long var2) throws RemoteException;

    @Override
    public void ping() throws RemoteException;

    @Override
    public DebugInfo getDebugInfo() throws RemoteException;

    @Override
    public void notifySyspropsChanged() throws RemoteException;

    @Override
    public boolean unlinkToDeath(IHwBinder.DeathRecipient var1) throws RemoteException;

    public static abstract class Stub
    extends HwBinder
    implements ICas {
        @Override
        public IHwBinder asBinder() {
            return this;
        }

        @Override
        public ArrayList<String> interfaceChain() {
            return new ArrayList<String>(Arrays.asList(ICas.kInterfaceName, "android.hidl.base@1.0::IBase"));
        }

        @Override
        public String interfaceDescriptor() {
            return ICas.kInterfaceName;
        }

        @Override
        public ArrayList<byte[]> getHashChain() {
            return new ArrayList<byte[]>(Arrays.asList({14, 101, 107, -95, -70, -63, 20, 97, -95, 112, -106, -17, 117, 43, 105, -46, 75, 0, 13, -126, 14, -11, 101, 47, 1, 80, -96, -7, 115, 29, 84, -62}, {-67, -38, -74, 24, 77, 122, 52, 109, -90, -96, 125, -64, -126, -116, -15, -102, 105, 111, 76, -86, 54, 17, -59, 31, 46, 20, 86, 90, 20, -76, 15, -39}));
        }

        @Override
        public void setHALInstrumentation() {
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) {
            return true;
        }

        @Override
        public void ping() {
        }

        @Override
        public DebugInfo getDebugInfo() {
            DebugInfo info = new DebugInfo();
            info.pid = HidlSupport.getPidIfSharable();
            info.ptr = 0L;
            info.arch = 0;
            return info;
        }

        @Override
        public void notifySyspropsChanged() {
            HwBinder.enableInstrumentation();
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) {
            return true;
        }

        @Override
        public IHwInterface queryLocalInterface(String descriptor) {
            if (ICas.kInterfaceName.equals(descriptor)) {
                return this;
            }
            return null;
        }

        public void registerAsService(String serviceName) throws RemoteException {
            this.registerService(serviceName);
        }

        public String toString() {
            return this.interfaceDescriptor() + "@Stub";
        }

        @Override
        public void onTransact(int _hidl_code, HwParcel _hidl_request, final HwParcel _hidl_reply, int _hidl_flags) throws RemoteException {
            switch (_hidl_code) {
                case 1: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    ArrayList<Byte> pvtData = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.setPrivateData(pvtData);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 2: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    this.openSession(new openSessionCallback(){

                        @Override
                        public void onValues(int status, ArrayList<Byte> sessionId) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeInt32(status);
                            _hidl_reply.writeInt8Vector(sessionId);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 3: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    ArrayList<Byte> sessionId = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.closeSession(sessionId);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 4: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    ArrayList<Byte> sessionId = _hidl_request.readInt8Vector();
                    ArrayList<Byte> pvtData = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.setSessionPrivateData(sessionId, pvtData);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 5: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    ArrayList<Byte> sessionId = _hidl_request.readInt8Vector();
                    ArrayList<Byte> ecm = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.processEcm(sessionId, ecm);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 6: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    ArrayList<Byte> emm = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.processEmm(emm);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 7: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    int event = _hidl_request.readInt32();
                    int arg = _hidl_request.readInt32();
                    ArrayList<Byte> eventData = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.sendEvent(event, arg, eventData);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 8: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    String provisionString = _hidl_request.readString();
                    int _hidl_out_status = this.provision(provisionString);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 9: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    int refreshType = _hidl_request.readInt32();
                    ArrayList<Byte> refreshData = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.refreshEntitlements(refreshType, refreshData);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 10: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(ICas.kInterfaceName);
                    int _hidl_out_status = this.release();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 256067662: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<String> _hidl_out_descriptors = this.interfaceChain();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_descriptors);
                    _hidl_reply.send();
                    break;
                }
                case 256131655: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 256136003: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    String _hidl_out_descriptor = this.interfaceDescriptor();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeString(_hidl_out_descriptor);
                    _hidl_reply.send();
                    break;
                }
                case 256398152: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<byte[]> _hidl_out_hashchain = this.getHashChain();
                    _hidl_reply.writeStatus(0);
                    HwBlob _hidl_blob = new HwBlob(16);
                    int _hidl_vec_size = _hidl_out_hashchain.size();
                    _hidl_blob.putInt32(8L, _hidl_vec_size);
                    _hidl_blob.putBool(12L, false);
                    HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
                    for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                        long _hidl_array_offset_1 = _hidl_index_0 * 32;
                        childBlob.putInt8Array(_hidl_array_offset_1, _hidl_out_hashchain.get(_hidl_index_0));
                        _hidl_array_offset_1 += 32L;
                    }
                    _hidl_blob.putBlob(0L, childBlob);
                    _hidl_reply.writeBuffer(_hidl_blob);
                    _hidl_reply.send();
                    break;
                }
                case 256462420: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.setHALInstrumentation();
                    break;
                }
                case 256660548: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
                case 256921159: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.ping();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 257049926: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    DebugInfo _hidl_out_info = this.getDebugInfo();
                    _hidl_reply.writeStatus(0);
                    _hidl_out_info.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 257120595: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.notifySyspropsChanged();
                    break;
                }
                case 0xF555444: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
            }
        }
    }

    public static class Proxy
    implements ICas {
        private IHwBinder mRemote;

        public Proxy(IHwBinder remote) {
            this.mRemote = Objects.requireNonNull(remote);
        }

        @Override
        public IHwBinder asBinder() {
            return this.mRemote;
        }

        public String toString() {
            try {
                return this.interfaceDescriptor() + "@Proxy";
            }
            catch (RemoteException remoteException) {
                return "[class or subclass of android.hardware.cas@1.0::ICas]@Proxy";
            }
        }

        public boolean equals(Object other) {
            return HidlSupport.interfacesEqual(this, other);
        }

        public int hashCode() {
            return this.asBinder().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int setPrivateData(ArrayList<Byte> pvtData) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeInt8Vector(pvtData);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(1, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void openSession(openSessionCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(2, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int _hidl_out_status = _hidl_reply.readInt32();
                ArrayList<Byte> _hidl_out_sessionId = _hidl_reply.readInt8Vector();
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_sessionId);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int closeSession(ArrayList<Byte> sessionId) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeInt8Vector(sessionId);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(3, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int setSessionPrivateData(ArrayList<Byte> sessionId, ArrayList<Byte> pvtData) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeInt8Vector(sessionId);
            _hidl_request.writeInt8Vector(pvtData);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(4, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processEcm(ArrayList<Byte> sessionId, ArrayList<Byte> ecm) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeInt8Vector(sessionId);
            _hidl_request.writeInt8Vector(ecm);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(5, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processEmm(ArrayList<Byte> emm) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeInt8Vector(emm);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(6, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int sendEvent(int event, int arg, ArrayList<Byte> eventData) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeInt32(event);
            _hidl_request.writeInt32(arg);
            _hidl_request.writeInt8Vector(eventData);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(7, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int provision(String provisionString) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeString(provisionString);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(8, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int refreshEntitlements(int refreshType, ArrayList<Byte> refreshData) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            _hidl_request.writeInt32(refreshType);
            _hidl_request.writeInt8Vector(refreshData);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(9, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int release() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ICas.kInterfaceName);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(10, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<String> interfaceChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                ArrayList<String> _hidl_out_descriptors;
                this.mRemote.transact(256067662, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<String> arrayList = _hidl_out_descriptors = _hidl_reply.readStringVector();
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String interfaceDescriptor() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                String _hidl_out_descriptor;
                this.mRemote.transact(256136003, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                String string2 = _hidl_out_descriptor = _hidl_reply.readString();
                return string2;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<byte[]> getHashChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256398152, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<byte[]> _hidl_out_hashchain = new ArrayList<byte[]>();
                HwBlob _hidl_blob = _hidl_reply.readBuffer(16L);
                int _hidl_vec_size = _hidl_blob.getInt32(8L);
                HwBlob childBlob = _hidl_reply.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
                _hidl_out_hashchain.clear();
                for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                    byte[] _hidl_vec_element = new byte[32];
                    long _hidl_array_offset_1 = _hidl_index_0 * 32;
                    childBlob.copyToInt8Array(_hidl_array_offset_1, _hidl_vec_element, 32);
                    _hidl_array_offset_1 += 32L;
                    _hidl_out_hashchain.add(_hidl_vec_element);
                }
                ArrayList<byte[]> arrayList = _hidl_out_hashchain;
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void setHALInstrumentation() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256462420, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) throws RemoteException {
            return this.mRemote.linkToDeath(recipient, cookie);
        }

        @Override
        public void ping() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256921159, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DebugInfo getDebugInfo() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257049926, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                DebugInfo _hidl_out_info = new DebugInfo();
                _hidl_out_info.readFromParcel(_hidl_reply);
                DebugInfo debugInfo = _hidl_out_info;
                return debugInfo;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void notifySyspropsChanged() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257120595, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) throws RemoteException {
            return this.mRemote.unlinkToDeath(recipient);
        }
    }

    @FunctionalInterface
    public static interface openSessionCallback {
        public void onValues(int var1, ArrayList<Byte> var2);
    }
}

