/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.HardwareBuffer;
import android.hardware.Sensor;
import android.hardware.SensorAdditionalInfo;
import android.hardware.SensorDirectChannel;
import android.hardware.SensorEvent;
import android.hardware.SensorEventCallback;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.os.Looper;
import android.os.MemoryFile;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemSensorManager
extends SensorManager {
    private static final boolean DEBUG_DYNAMIC_SENSOR = true;
    private static final int MIN_DIRECT_CHANNEL_BUFFER_SIZE = 104;
    private static final int MAX_LISTENER_COUNT = 128;
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static boolean sNativeClassInited = false;
    @GuardedBy(value="sLock")
    private static InjectEventQueue sInjectEventQueue = null;
    private final ArrayList<Sensor> mFullSensorsList = new ArrayList();
    private List<Sensor> mFullDynamicSensorsList = new ArrayList<Sensor>();
    private boolean mDynamicSensorListDirty = true;
    private final HashMap<Integer, Sensor> mHandleToSensor = new HashMap();
    private final HashMap<SensorEventListener, SensorEventQueue> mSensorListeners = new HashMap();
    private final HashMap<TriggerEventListener, TriggerEventQueue> mTriggerListeners = new HashMap();
    private HashMap<SensorManager.DynamicSensorCallback, Handler> mDynamicSensorCallbacks = new HashMap();
    private BroadcastReceiver mDynamicSensorBroadcastReceiver;
    private final Looper mMainLooper;
    private final int mTargetSdkLevel;
    private final Context mContext;
    private final long mNativeInstance;

    private static void nativeClassInit() {
        OverrideMethod.invokeV("android.hardware.SystemSensorManager#nativeClassInit()V", true, null);
    }

    private static long nativeCreate(String string2) {
        return OverrideMethod.invokeL("android.hardware.SystemSensorManager#nativeCreate(Ljava/lang/String;)J", true, null);
    }

    private static boolean nativeGetSensorAtIndex(long l, Sensor sensor, int n) {
        return OverrideMethod.invokeI("android.hardware.SystemSensorManager#nativeGetSensorAtIndex(JLandroid/hardware/Sensor;I)Z", true, null) != 0;
    }

    private static void nativeGetDynamicSensors(long l, List<Sensor> list) {
        OverrideMethod.invokeV("android.hardware.SystemSensorManager#nativeGetDynamicSensors(JLjava/util/List;)V", true, null);
    }

    private static boolean nativeIsDataInjectionEnabled(long l) {
        return OverrideMethod.invokeI("android.hardware.SystemSensorManager#nativeIsDataInjectionEnabled(J)Z", true, null) != 0;
    }

    private static int nativeCreateDirectChannel(long l, long l2, int n, int n2, HardwareBuffer hardwareBuffer) {
        return OverrideMethod.invokeI("android.hardware.SystemSensorManager#nativeCreateDirectChannel(JJIILandroid/hardware/HardwareBuffer;)I", true, null);
    }

    private static void nativeDestroyDirectChannel(long l, int n) {
        OverrideMethod.invokeV("android.hardware.SystemSensorManager#nativeDestroyDirectChannel(JI)V", true, null);
    }

    private static int nativeConfigDirectChannel(long l, int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.hardware.SystemSensorManager#nativeConfigDirectChannel(JIII)I", true, null);
    }

    private static int nativeSetOperationParameter(long l, int n, int n2, float[] fArray, int[] nArray) {
        return OverrideMethod.invokeI("android.hardware.SystemSensorManager#nativeSetOperationParameter(JII[F[I)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemSensorManager(Context context, Looper mainLooper) {
        Sensor sensor;
        Object object = sLock;
        synchronized (object) {
            if (!sNativeClassInited) {
                sNativeClassInited = true;
                SystemSensorManager.nativeClassInit();
            }
        }
        this.mMainLooper = mainLooper;
        this.mTargetSdkLevel = context.getApplicationInfo().targetSdkVersion;
        this.mContext = context;
        this.mNativeInstance = SystemSensorManager.nativeCreate(context.getOpPackageName());
        int index = 0;
        while (SystemSensorManager.nativeGetSensorAtIndex(this.mNativeInstance, sensor = new Sensor(), index)) {
            this.mFullSensorsList.add(sensor);
            this.mHandleToSensor.put(sensor.getHandle(), sensor);
            ++index;
        }
    }

    @Override
    protected List<Sensor> getFullSensorList() {
        return this.mFullSensorsList;
    }

    @Override
    protected List<Sensor> getFullDynamicSensorList() {
        this.setupDynamicSensorBroadcastReceiver();
        this.updateDynamicSensorList();
        return this.mFullDynamicSensorsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean registerListenerImpl(SensorEventListener listener, Sensor sensor, int delayUs, Handler handler, int maxBatchReportLatencyUs, int reservedFlags) {
        if (listener == null || sensor == null) {
            Log.e("SensorManager", "sensor or listener is null");
            return false;
        }
        if (sensor.getReportingMode() == 2) {
            Log.e("SensorManager", "Trigger Sensors should use the requestTriggerSensor.");
            return false;
        }
        if (maxBatchReportLatencyUs < 0 || delayUs < 0) {
            Log.e("SensorManager", "maxBatchReportLatencyUs and delayUs should be non-negative");
            return false;
        }
        if (this.mSensorListeners.size() >= 128) {
            throw new IllegalStateException("register failed, the sensor listeners size has exceeded the maximum limit 128");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                String fullClassName;
                Looper looper = handler != null ? handler.getLooper() : this.mMainLooper;
                queue = new SensorEventQueue(listener, looper, this, fullClassName = listener.getClass().getEnclosingClass() != null ? listener.getClass().getEnclosingClass().getName() : listener.getClass().getName());
                if (!queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs)) {
                    queue.dispose();
                    return false;
                }
                this.mSensorListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregisterListenerImpl(SensorEventListener listener, Sensor sensor) {
        if (sensor != null && sensor.getReportingMode() == 2) {
            return;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            boolean result;
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue != null && (result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, true)) && !queue.hasSensors()) {
                this.mSensorListeners.remove(listener);
                queue.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean requestTriggerSensorImpl(TriggerEventListener listener, Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("sensor cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (sensor.getReportingMode() != 2) {
            return false;
        }
        if (this.mTriggerListeners.size() >= 128) {
            throw new IllegalStateException("request failed, the trigger listeners size has exceeded the maximum limit 128");
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue == null) {
                String fullClassName = listener.getClass().getEnclosingClass() != null ? listener.getClass().getEnclosingClass().getName() : listener.getClass().getName();
                queue = new TriggerEventQueue(listener, this.mMainLooper, this, fullClassName);
                if (!queue.addSensor(sensor, 0, 0)) {
                    queue.dispose();
                    return false;
                }
                this.mTriggerListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cancelTriggerSensorImpl(TriggerEventListener listener, Sensor sensor, boolean disable) {
        if (sensor != null && sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue != null) {
                boolean result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, disable);
                if (result && !queue.hasSensors()) {
                    this.mTriggerListeners.remove(listener);
                    queue.dispose();
                }
                return result;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flushImpl(SensorEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                return false;
            }
            return queue.flush() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean initDataInjectionImpl(boolean enable) {
        Object object = sLock;
        synchronized (object) {
            if (enable) {
                boolean isDataInjectionModeEnabled = SystemSensorManager.nativeIsDataInjectionEnabled(this.mNativeInstance);
                if (!isDataInjectionModeEnabled) {
                    Log.e("SensorManager", "Data Injection mode not enabled");
                    return false;
                }
                if (sInjectEventQueue == null) {
                    try {
                        sInjectEventQueue = new InjectEventQueue(this.mMainLooper, this, this.mContext.getPackageName());
                    }
                    catch (RuntimeException e) {
                        Log.e("SensorManager", "Cannot create InjectEventQueue: " + e);
                    }
                }
                return sInjectEventQueue != null;
            }
            if (sInjectEventQueue != null) {
                sInjectEventQueue.dispose();
                sInjectEventQueue = null;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean injectSensorDataImpl(Sensor sensor, float[] values, int accuracy, long timestamp) {
        Object object = sLock;
        synchronized (object) {
            if (sInjectEventQueue == null) {
                Log.e("SensorManager", "Data injection mode not activated before calling injectSensorData");
                return false;
            }
            int ret = sInjectEventQueue.injectSensorData(sensor.getHandle(), values, accuracy, timestamp);
            if (ret != 0) {
                sInjectEventQueue.dispose();
                sInjectEventQueue = null;
            }
            return ret == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupSensorConnection(Sensor sensor) {
        this.mHandleToSensor.remove(sensor.getHandle());
        if (sensor.getReportingMode() == 2) {
            HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
            synchronized (hashMap) {
                HashMap<TriggerEventListener, TriggerEventQueue> triggerListeners = new HashMap<TriggerEventListener, TriggerEventQueue>(this.mTriggerListeners);
                for (TriggerEventListener l : triggerListeners.keySet()) {
                    Log.i("SensorManager", "removed trigger listener" + l.toString() + " due to sensor disconnection");
                    this.cancelTriggerSensorImpl(l, sensor, true);
                }
            }
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            HashMap<SensorEventListener, SensorEventQueue> sensorListeners = new HashMap<SensorEventListener, SensorEventQueue>(this.mSensorListeners);
            for (SensorEventListener l : sensorListeners.keySet()) {
                Log.i("SensorManager", "removed event listener" + l.toString() + " due to sensor disconnection");
                this.unregisterListenerImpl(l, sensor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDynamicSensorList() {
        List<Sensor> list = this.mFullDynamicSensorsList;
        synchronized (list) {
            if (this.mDynamicSensorListDirty) {
                ArrayList<Sensor> list2 = new ArrayList<Sensor>();
                SystemSensorManager.nativeGetDynamicSensors(this.mNativeInstance, list2);
                ArrayList<Sensor> updatedList = new ArrayList<Sensor>();
                final ArrayList<Sensor> addedList = new ArrayList<Sensor>();
                final ArrayList<Sensor> removedList = new ArrayList<Sensor>();
                boolean changed = SystemSensorManager.diffSortedSensorList(this.mFullDynamicSensorsList, list2, updatedList, addedList, removedList);
                if (changed) {
                    Log.i("SensorManager", "DYNS dynamic sensor list cached should be updated");
                    this.mFullDynamicSensorsList = updatedList;
                    for (Sensor s : addedList) {
                        this.mHandleToSensor.put(s.getHandle(), s);
                    }
                    Handler mainHandler = new Handler(this.mContext.getMainLooper());
                    for (Map.Entry<SensorManager.DynamicSensorCallback, Handler> entry : this.mDynamicSensorCallbacks.entrySet()) {
                        final SensorManager.DynamicSensorCallback callback = entry.getKey();
                        Handler handler = entry.getValue() == null ? mainHandler : entry.getValue();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                for (Sensor s : addedList) {
                                    callback.onDynamicSensorConnected(s);
                                }
                                for (Sensor s : removedList) {
                                    callback.onDynamicSensorDisconnected(s);
                                }
                            }
                        });
                    }
                    for (Sensor s : removedList) {
                        this.cleanupSensorConnection(s);
                    }
                }
                this.mDynamicSensorListDirty = false;
            }
        }
    }

    private void setupDynamicSensorBroadcastReceiver() {
        if (this.mDynamicSensorBroadcastReceiver == null) {
            this.mDynamicSensorBroadcastReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    if (intent.getAction() == "android.intent.action.DYNAMIC_SENSOR_CHANGED") {
                        Log.i("SensorManager", "DYNS received DYNAMIC_SENSOR_CHANED broadcast");
                        SystemSensorManager.this.mDynamicSensorListDirty = true;
                        SystemSensorManager.this.updateDynamicSensorList();
                    }
                }
            };
            IntentFilter filter = new IntentFilter("dynamic_sensor_change");
            filter.addAction("android.intent.action.DYNAMIC_SENSOR_CHANGED");
            this.mContext.registerReceiver(this.mDynamicSensorBroadcastReceiver, filter);
        }
    }

    private void teardownDynamicSensorBroadcastReceiver() {
        this.mDynamicSensorCallbacks.clear();
        this.mContext.unregisterReceiver(this.mDynamicSensorBroadcastReceiver);
        this.mDynamicSensorBroadcastReceiver = null;
    }

    @Override
    protected void registerDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback, Handler handler) {
        Log.i("SensorManager", "DYNS Register dynamic sensor callback");
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (this.mDynamicSensorCallbacks.containsKey(callback)) {
            return;
        }
        this.setupDynamicSensorBroadcastReceiver();
        this.mDynamicSensorCallbacks.put(callback, handler);
    }

    @Override
    protected void unregisterDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback) {
        Log.i("SensorManager", "Removing dynamic sensor listerner");
        this.mDynamicSensorCallbacks.remove(callback);
    }

    private static boolean diffSortedSensorList(List<Sensor> oldList, List<Sensor> newList, List<Sensor> updated, List<Sensor> added, List<Sensor> removed) {
        boolean changed = false;
        int i = 0;
        int j = 0;
        while (true) {
            if (j < oldList.size() && (i >= newList.size() || newList.get(i).getHandle() > oldList.get(j).getHandle())) {
                changed = true;
                if (removed != null) {
                    removed.add(oldList.get(j));
                }
                ++j;
                continue;
            }
            if (i < newList.size() && (j >= oldList.size() || newList.get(i).getHandle() < oldList.get(j).getHandle())) {
                changed = true;
                if (added != null) {
                    added.add(newList.get(i));
                }
                if (updated != null) {
                    updated.add(newList.get(i));
                }
                ++i;
                continue;
            }
            if (i >= newList.size() || j >= oldList.size() || newList.get(i).getHandle() != oldList.get(j).getHandle()) break;
            if (updated != null) {
                updated.add(oldList.get(j));
            }
            ++i;
            ++j;
        }
        return changed;
    }

    @Override
    protected int configureDirectChannelImpl(SensorDirectChannel channel, Sensor sensor, int rate) {
        if (!channel.isOpen()) {
            throw new IllegalStateException("channel is closed");
        }
        if (rate < 0 || rate > 3) {
            throw new IllegalArgumentException("rate parameter invalid");
        }
        if (sensor == null && rate != 0) {
            throw new IllegalArgumentException("when sensor is null, rate can only be DIRECT_RATE_STOP");
        }
        int sensorHandle = sensor == null ? -1 : sensor.getHandle();
        int ret = SystemSensorManager.nativeConfigDirectChannel(this.mNativeInstance, channel.getNativeHandle(), sensorHandle, rate);
        if (rate == 0) {
            return ret == 0 ? 1 : 0;
        }
        return ret > 0 ? ret : 0;
    }

    @Override
    protected SensorDirectChannel createDirectChannelImpl(MemoryFile memoryFile, HardwareBuffer hardwareBuffer) {
        int type;
        int id2;
        long size;
        if (memoryFile != null) {
            int fd;
            try {
                fd = memoryFile.getFileDescriptor().getInt$();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("MemoryFile object is not valid");
            }
            if (memoryFile.length() < 104) {
                throw new IllegalArgumentException("Size of MemoryFile has to be greater than 104");
            }
            size = memoryFile.length();
            id2 = SystemSensorManager.nativeCreateDirectChannel(this.mNativeInstance, size, 1, fd, null);
            if (id2 <= 0) {
                throw new UncheckedIOException(new IOException("create MemoryFile direct channel failed " + id2));
            }
            type = 1;
        } else if (hardwareBuffer != null) {
            if (hardwareBuffer.getFormat() != 33) {
                throw new IllegalArgumentException("Format of HardwareBuffer must be BLOB");
            }
            if (hardwareBuffer.getHeight() != 1) {
                throw new IllegalArgumentException("Height of HardwareBuffer must be 1");
            }
            if (hardwareBuffer.getWidth() < 104) {
                throw new IllegalArgumentException("Width if HaradwareBuffer must be greater than 104");
            }
            if ((hardwareBuffer.getUsage() & 0x800000L) == 0L) {
                throw new IllegalArgumentException("HardwareBuffer must set usage flag USAGE_SENSOR_DIRECT_DATA");
            }
            size = hardwareBuffer.getWidth();
            id2 = SystemSensorManager.nativeCreateDirectChannel(this.mNativeInstance, size, 2, -1, hardwareBuffer);
            if (id2 <= 0) {
                throw new UncheckedIOException(new IOException("create HardwareBuffer direct channel failed " + id2));
            }
            type = 2;
        } else {
            throw new NullPointerException("shared memory object cannot be null");
        }
        return new SensorDirectChannel(this, id2, type, size);
    }

    @Override
    protected void destroyDirectChannelImpl(SensorDirectChannel channel) {
        if (channel != null) {
            SystemSensorManager.nativeDestroyDirectChannel(this.mNativeInstance, channel.getNativeHandle());
        }
    }

    @Override
    protected boolean setOperationParameterImpl(SensorAdditionalInfo parameter) {
        int handle = -1;
        if (parameter.sensor != null) {
            handle = parameter.sensor.getHandle();
        }
        return SystemSensorManager.nativeSetOperationParameter(this.mNativeInstance, handle, parameter.type, parameter.floatValues, parameter.intValues) == 0;
    }

    class InjectEventQueue
    extends BaseEventQueue {
        public InjectEventQueue(Looper looper, SystemSensorManager manager, String packageName) {
            super(looper, manager, 1, packageName);
        }

        int injectSensorData(int handle, float[] values, int accuracy, long timestamp) {
            return this.injectSensorDataBase(handle, values, accuracy, timestamp);
        }

        @Override
        protected void dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
        }

        @Override
        protected void dispatchFlushCompleteEvent(int handle) {
        }

        @Override
        protected void addSensorEvent(Sensor sensor) {
        }

        @Override
        protected void removeSensorEvent(Sensor sensor) {
        }
    }

    static class TriggerEventQueue
    extends BaseEventQueue {
        private final TriggerEventListener mListener;
        private final SparseArray<TriggerEvent> mTriggerEvents = new SparseArray();

        public TriggerEventQueue(TriggerEventListener listener, Looper looper, SystemSensorManager manager, String packageName) {
            super(looper, manager, 0, packageName);
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSensorEvent(Sensor sensor) {
            TriggerEvent t = new TriggerEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSensorEvent(Sensor sensor) {
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
            Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
            if (sensor == null) {
                return;
            }
            TriggerEvent t = null;
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                t = this.mTriggerEvents.get(handle);
            }
            if (t == null) {
                Log.e("SensorManager", "Error: Trigger Event is null for Sensor: " + sensor);
                return;
            }
            System.arraycopy(values, 0, t.values, 0, t.values.length);
            t.timestamp = timestamp;
            t.sensor = sensor;
            this.mManager.cancelTriggerSensorImpl(this.mListener, sensor, false);
            this.mListener.onTrigger(t);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int handle) {
        }
    }

    static class SensorEventQueue
    extends BaseEventQueue {
        private final SensorEventListener mListener;
        private final SparseArray<SensorEvent> mSensorsEvents = new SparseArray();

        public SensorEventQueue(SensorEventListener listener, Looper looper, SystemSensorManager manager, String packageName) {
            super(looper, manager, 0, packageName);
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSensorEvent(Sensor sensor) {
            SensorEvent t = new SensorEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSensorEvent(Sensor sensor) {
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchSensorEvent(int handle, float[] values, int inAccuracy, long timestamp) {
            Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
            if (sensor == null) {
                return;
            }
            SensorEvent t = null;
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                t = this.mSensorsEvents.get(handle);
            }
            if (t == null) {
                return;
            }
            System.arraycopy(values, 0, t.values, 0, t.values.length);
            t.timestamp = timestamp;
            t.accuracy = inAccuracy;
            t.sensor = sensor;
            int accuracy = this.mSensorAccuracies.get(handle);
            if (t.accuracy >= 0 && accuracy != t.accuracy) {
                this.mSensorAccuracies.put(handle, t.accuracy);
                this.mListener.onAccuracyChanged(t.sensor, t.accuracy);
            }
            this.mListener.onSensorChanged(t);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int handle) {
            if (this.mListener instanceof SensorEventListener2) {
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) {
                    return;
                }
                ((SensorEventListener2)this.mListener).onFlushCompleted(sensor);
            }
        }

        @Override
        protected void dispatchAdditionalInfoEvent(int handle, int type, int serial, float[] floatValues, int[] intValues) {
            if (this.mListener instanceof SensorEventCallback) {
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) {
                    return;
                }
                SensorAdditionalInfo info = new SensorAdditionalInfo(sensor, type, serial, intValues, floatValues);
                ((SensorEventCallback)this.mListener).onSensorAdditionalInfo(info);
            }
        }
    }

    private static abstract class BaseEventQueue {
        private long mNativeSensorEventQueue;
        private final SparseBooleanArray mActiveSensors = new SparseBooleanArray();
        protected final SparseIntArray mSensorAccuracies = new SparseIntArray();
        private final CloseGuard mCloseGuard = CloseGuard.get();
        protected final SystemSensorManager mManager;
        protected static final int OPERATING_MODE_NORMAL = 0;
        protected static final int OPERATING_MODE_DATA_INJECTION = 1;

        private static long nativeInitBaseEventQueue(long l, WeakReference<BaseEventQueue> weakReference, MessageQueue messageQueue, String string2, int n, String string3) {
            return OverrideMethod.invokeL("android.hardware.SystemSensorManager$BaseEventQueue#nativeInitBaseEventQueue(JLjava/lang/ref/WeakReference;Landroid/os/MessageQueue;Ljava/lang/String;ILjava/lang/String;)J", true, null);
        }

        private static int nativeEnableSensor(long l, int n, int n2, int n3) {
            return OverrideMethod.invokeI("android.hardware.SystemSensorManager$BaseEventQueue#nativeEnableSensor(JIII)I", true, null);
        }

        private static int nativeDisableSensor(long l, int n) {
            return OverrideMethod.invokeI("android.hardware.SystemSensorManager$BaseEventQueue#nativeDisableSensor(JI)I", true, null);
        }

        private static void nativeDestroySensorEventQueue(long l) {
            OverrideMethod.invokeV("android.hardware.SystemSensorManager$BaseEventQueue#nativeDestroySensorEventQueue(J)V", true, null);
        }

        private static int nativeFlushSensor(long l) {
            return OverrideMethod.invokeI("android.hardware.SystemSensorManager$BaseEventQueue#nativeFlushSensor(J)I", true, null);
        }

        private static int nativeInjectSensorData(long l, int n, float[] fArray, int n2, long l2) {
            return OverrideMethod.invokeI("android.hardware.SystemSensorManager$BaseEventQueue#nativeInjectSensorData(JI[FIJ)I", true, null);
        }

        BaseEventQueue(Looper looper, SystemSensorManager manager, int mode, String packageName) {
            if (packageName == null) {
                packageName = "";
            }
            this.mNativeSensorEventQueue = BaseEventQueue.nativeInitBaseEventQueue(manager.mNativeInstance, new WeakReference<BaseEventQueue>(this), looper.getQueue(), packageName, mode, manager.mContext.getOpPackageName());
            this.mCloseGuard.open("dispose");
            this.mManager = manager;
        }

        public void dispose() {
            this.dispose(false);
        }

        public boolean addSensor(Sensor sensor, int delayUs, int maxBatchReportLatencyUs) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                return false;
            }
            this.mActiveSensors.put(handle, true);
            this.addSensorEvent(sensor);
            if (this.enableSensor(sensor, delayUs, maxBatchReportLatencyUs) != 0 && (maxBatchReportLatencyUs == 0 || maxBatchReportLatencyUs > 0 && this.enableSensor(sensor, delayUs, 0) != 0)) {
                this.removeSensor(sensor, false);
                return false;
            }
            return true;
        }

        public boolean removeAllSensors() {
            for (int i = 0; i < this.mActiveSensors.size(); ++i) {
                if (!this.mActiveSensors.valueAt(i)) continue;
                int handle = this.mActiveSensors.keyAt(i);
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) continue;
                this.disableSensor(sensor);
                this.mActiveSensors.put(handle, false);
                this.removeSensorEvent(sensor);
            }
            return true;
        }

        public boolean removeSensor(Sensor sensor, boolean disable) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                if (disable) {
                    this.disableSensor(sensor);
                }
                this.mActiveSensors.put(sensor.getHandle(), false);
                this.removeSensorEvent(sensor);
                return true;
            }
            return false;
        }

        public int flush() {
            if (this.mNativeSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeFlushSensor(this.mNativeSensorEventQueue);
        }

        public boolean hasSensors() {
            return this.mActiveSensors.indexOfValue(true) >= 0;
        }

        protected void finalize() throws Throwable {
            try {
                this.dispose(true);
            }
            finally {
                super.finalize();
            }
        }

        private void dispose(boolean finalized) {
            if (this.mCloseGuard != null) {
                if (finalized) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.mCloseGuard.close();
            }
            if (this.mNativeSensorEventQueue != 0L) {
                BaseEventQueue.nativeDestroySensorEventQueue(this.mNativeSensorEventQueue);
                this.mNativeSensorEventQueue = 0L;
            }
        }

        private int enableSensor(Sensor sensor, int rateUs, int maxBatchReportLatencyUs) {
            if (this.mNativeSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeEnableSensor(this.mNativeSensorEventQueue, sensor.getHandle(), rateUs, maxBatchReportLatencyUs);
        }

        protected int injectSensorDataBase(int handle, float[] values, int accuracy, long timestamp) {
            return BaseEventQueue.nativeInjectSensorData(this.mNativeSensorEventQueue, handle, values, accuracy, timestamp);
        }

        private int disableSensor(Sensor sensor) {
            if (this.mNativeSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeDisableSensor(this.mNativeSensorEventQueue, sensor.getHandle());
        }

        protected abstract void dispatchSensorEvent(int var1, float[] var2, int var3, long var4);

        protected abstract void dispatchFlushCompleteEvent(int var1);

        protected void dispatchAdditionalInfoEvent(int handle, int type, int serial, float[] floatValues, int[] intValues) {
        }

        protected abstract void addSensorEvent(Sensor var1);

        protected abstract void removeSensorEvent(Sensor var1);
    }
}

