/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Parcel;
import android.os.Parcelable;

public class PackageInfo
implements Parcelable {
    public String packageName;
    public String[] splitNames;
    @Deprecated
    public int versionCode;
    public int versionCodeMajor;
    public String versionName;
    public int baseRevisionCode;
    public int[] splitRevisionCodes;
    public String sharedUserId;
    public int sharedUserLabel;
    public ApplicationInfo applicationInfo;
    public long firstInstallTime;
    public long lastUpdateTime;
    public int[] gids;
    public ActivityInfo[] activities;
    public ActivityInfo[] receivers;
    public ServiceInfo[] services;
    public ProviderInfo[] providers;
    public InstrumentationInfo[] instrumentation;
    public PermissionInfo[] permissions;
    public String[] requestedPermissions;
    public int[] requestedPermissionsFlags;
    public static final int REQUESTED_PERMISSION_REQUIRED = 1;
    public static final int REQUESTED_PERMISSION_GRANTED = 2;
    @Deprecated
    public Signature[] signatures;
    public SigningInfo signingInfo;
    public ConfigurationInfo[] configPreferences;
    public FeatureInfo[] reqFeatures;
    public FeatureGroupInfo[] featureGroups;
    public static final int INSTALL_LOCATION_UNSPECIFIED = -1;
    public static final int INSTALL_LOCATION_AUTO = 0;
    public static final int INSTALL_LOCATION_INTERNAL_ONLY = 1;
    public static final int INSTALL_LOCATION_PREFER_EXTERNAL = 2;
    public int installLocation = 1;
    public boolean isStub;
    public boolean coreApp;
    public boolean requiredForAllUsers;
    public String restrictedAccountType;
    public String requiredAccountType;
    public String overlayTarget;
    public String overlayCategory;
    public int overlayPriority;
    boolean mOverlayIsStatic;
    public int compileSdkVersion;
    public String compileSdkVersionCodename;
    public static final Parcelable.Creator<PackageInfo> CREATOR = new Parcelable.Creator<PackageInfo>(){

        @Override
        public PackageInfo createFromParcel(Parcel source) {
            return new PackageInfo(source);
        }

        public PackageInfo[] newArray(int size) {
            return new PackageInfo[size];
        }
    };

    public long getLongVersionCode() {
        return PackageInfo.composeLongVersionCode(this.versionCodeMajor, this.versionCode);
    }

    public void setLongVersionCode(long longVersionCode) {
        this.versionCodeMajor = (int)(longVersionCode >> 32);
        this.versionCode = (int)longVersionCode;
    }

    public static long composeLongVersionCode(int major, int minor) {
        return (long)major << 32 | (long)minor & 0xFFFFFFFFL;
    }

    public PackageInfo() {
    }

    public boolean isOverlayPackage() {
        return this.overlayTarget != null;
    }

    public boolean isStaticOverlayPackage() {
        return this.overlayTarget != null && this.mOverlayIsStatic;
    }

    public String toString() {
        return "PackageInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeString(this.packageName);
        dest.writeStringArray(this.splitNames);
        dest.writeInt(this.versionCode);
        dest.writeInt(this.versionCodeMajor);
        dest.writeString(this.versionName);
        dest.writeInt(this.baseRevisionCode);
        dest.writeIntArray(this.splitRevisionCodes);
        dest.writeString(this.sharedUserId);
        dest.writeInt(this.sharedUserLabel);
        if (this.applicationInfo != null) {
            dest.writeInt(1);
            this.applicationInfo.writeToParcel(dest, parcelableFlags);
        } else {
            dest.writeInt(0);
        }
        dest.writeLong(this.firstInstallTime);
        dest.writeLong(this.lastUpdateTime);
        dest.writeIntArray(this.gids);
        dest.writeTypedArray(this.activities, parcelableFlags | 2);
        dest.writeTypedArray(this.receivers, parcelableFlags | 2);
        dest.writeTypedArray(this.services, parcelableFlags | 2);
        dest.writeTypedArray(this.providers, parcelableFlags | 2);
        dest.writeTypedArray(this.instrumentation, parcelableFlags);
        dest.writeTypedArray(this.permissions, parcelableFlags);
        dest.writeStringArray(this.requestedPermissions);
        dest.writeIntArray(this.requestedPermissionsFlags);
        dest.writeTypedArray(this.signatures, parcelableFlags);
        dest.writeTypedArray(this.configPreferences, parcelableFlags);
        dest.writeTypedArray(this.reqFeatures, parcelableFlags);
        dest.writeTypedArray(this.featureGroups, parcelableFlags);
        dest.writeInt(this.installLocation);
        dest.writeInt(this.isStub ? 1 : 0);
        dest.writeInt(this.coreApp ? 1 : 0);
        dest.writeInt(this.requiredForAllUsers ? 1 : 0);
        dest.writeString(this.restrictedAccountType);
        dest.writeString(this.requiredAccountType);
        dest.writeString(this.overlayTarget);
        dest.writeString(this.overlayCategory);
        dest.writeInt(this.overlayPriority);
        dest.writeBoolean(this.mOverlayIsStatic);
        dest.writeInt(this.compileSdkVersion);
        dest.writeString(this.compileSdkVersionCodename);
        if (this.signingInfo != null) {
            dest.writeInt(1);
            this.signingInfo.writeToParcel(dest, parcelableFlags);
        } else {
            dest.writeInt(0);
        }
    }

    private PackageInfo(Parcel source) {
        this.packageName = source.readString();
        this.splitNames = source.createStringArray();
        this.versionCode = source.readInt();
        this.versionCodeMajor = source.readInt();
        this.versionName = source.readString();
        this.baseRevisionCode = source.readInt();
        this.splitRevisionCodes = source.createIntArray();
        this.sharedUserId = source.readString();
        this.sharedUserLabel = source.readInt();
        int hasApp = source.readInt();
        if (hasApp != 0) {
            this.applicationInfo = ApplicationInfo.CREATOR.createFromParcel(source);
        }
        this.firstInstallTime = source.readLong();
        this.lastUpdateTime = source.readLong();
        this.gids = source.createIntArray();
        this.activities = source.createTypedArray(ActivityInfo.CREATOR);
        this.receivers = source.createTypedArray(ActivityInfo.CREATOR);
        this.services = source.createTypedArray(ServiceInfo.CREATOR);
        this.providers = source.createTypedArray(ProviderInfo.CREATOR);
        this.instrumentation = source.createTypedArray(InstrumentationInfo.CREATOR);
        this.permissions = source.createTypedArray(PermissionInfo.CREATOR);
        this.requestedPermissions = source.createStringArray();
        this.requestedPermissionsFlags = source.createIntArray();
        this.signatures = source.createTypedArray(Signature.CREATOR);
        this.configPreferences = source.createTypedArray(ConfigurationInfo.CREATOR);
        this.reqFeatures = source.createTypedArray(FeatureInfo.CREATOR);
        this.featureGroups = source.createTypedArray(FeatureGroupInfo.CREATOR);
        this.installLocation = source.readInt();
        this.isStub = source.readInt() != 0;
        this.coreApp = source.readInt() != 0;
        this.requiredForAllUsers = source.readInt() != 0;
        this.restrictedAccountType = source.readString();
        this.requiredAccountType = source.readString();
        this.overlayTarget = source.readString();
        this.overlayCategory = source.readString();
        this.overlayPriority = source.readInt();
        this.mOverlayIsStatic = source.readBoolean();
        this.compileSdkVersion = source.readInt();
        this.compileSdkVersionCodename = source.readString();
        int hasSigningInfo = source.readInt();
        if (hasSigningInfo != 0) {
            this.signingInfo = SigningInfo.CREATOR.createFromParcel(source);
        }
        if (this.applicationInfo != null) {
            this.propagateApplicationInfo(this.applicationInfo, this.activities);
            this.propagateApplicationInfo(this.applicationInfo, this.receivers);
            this.propagateApplicationInfo(this.applicationInfo, this.services);
            this.propagateApplicationInfo(this.applicationInfo, this.providers);
        }
    }

    private void propagateApplicationInfo(ApplicationInfo appInfo, ComponentInfo[] components) {
        if (components != null) {
            for (ComponentInfo ci : components) {
                ci.applicationInfo = appInfo;
            }
        }
    }
}

