/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.net.Uri;
import java.util.ArrayList;
import java.util.List;

public class UriMatcher {
    public static final int NO_MATCH = -1;
    private static final int EXACT = 0;
    private static final int NUMBER = 1;
    private static final int TEXT = 2;
    private int mCode;
    private int mWhich;
    private String mText;
    private ArrayList<UriMatcher> mChildren;

    public UriMatcher(int code) {
        this.mCode = code;
        this.mWhich = -1;
        this.mChildren = new ArrayList();
        this.mText = null;
    }

    private UriMatcher() {
        this.mCode = -1;
        this.mWhich = -1;
        this.mChildren = new ArrayList();
        this.mText = null;
    }

    public void addURI(String authority, String path, int code) {
        if (code < 0) {
            throw new IllegalArgumentException("code " + code + " is invalid: it must be positive");
        }
        String[] tokens = null;
        if (path != null) {
            String newPath = path;
            if (path.length() > 1 && path.charAt(0) == '/') {
                newPath = path.substring(1);
            }
            tokens = newPath.split("/");
        }
        int numTokens = tokens != null ? tokens.length : 0;
        UriMatcher node = this;
        for (int i = -1; i < numTokens; ++i) {
            UriMatcher child;
            int j;
            String token = i < 0 ? authority : tokens[i];
            ArrayList<UriMatcher> children = node.mChildren;
            int numChildren = children.size();
            for (j = 0; j < numChildren; ++j) {
                child = children.get(j);
                if (!token.equals(child.mText)) continue;
                node = child;
                break;
            }
            if (j != numChildren) continue;
            child = new UriMatcher();
            child.mWhich = token.equals("#") ? 1 : (token.equals("*") ? 2 : 0);
            child.mText = token;
            node.mChildren.add(child);
            node = child;
        }
        node.mCode = code;
    }

    public int match(Uri uri) {
        List<String> pathSegments = uri.getPathSegments();
        int li = pathSegments.size();
        UriMatcher node = this;
        if (li == 0 && uri.getAuthority() == null) {
            return this.mCode;
        }
        for (int i = -1; i < li; ++i) {
            String u = i < 0 ? uri.getAuthority() : pathSegments.get(i);
            ArrayList<UriMatcher> list = node.mChildren;
            if (list == null) break;
            node = null;
            int lj = list.size();
            for (int j = 0; j < lj; ++j) {
                UriMatcher n = list.get(j);
                block0 : switch (n.mWhich) {
                    case 0: {
                        if (!n.mText.equals(u)) break;
                        node = n;
                        break;
                    }
                    case 1: {
                        int lk = u.length();
                        for (int k = 0; k < lk; ++k) {
                            char c = u.charAt(k);
                            if (c < '0' || c > '9') break block0;
                        }
                        node = n;
                        break;
                    }
                    case 2: {
                        node = n;
                    }
                }
                if (node != null) break;
            }
            if (node != null) continue;
            return -1;
        }
        return node.mCode;
    }
}

