/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;

public class WindowConfiguration
implements Parcelable,
Comparable<WindowConfiguration> {
    private Rect mBounds = new Rect();
    private Rect mAppBounds;
    @WindowingMode
    private int mWindowingMode;
    public static final int WINDOWING_MODE_UNDEFINED = 0;
    public static final int WINDOWING_MODE_FULLSCREEN = 1;
    public static final int WINDOWING_MODE_PINNED = 2;
    public static final int WINDOWING_MODE_SPLIT_SCREEN_PRIMARY = 3;
    public static final int WINDOWING_MODE_SPLIT_SCREEN_SECONDARY = 4;
    public static final int WINDOWING_MODE_FULLSCREEN_OR_SPLIT_SCREEN_SECONDARY = 4;
    public static final int WINDOWING_MODE_FREEFORM = 5;
    @ActivityType
    private int mActivityType;
    public static final int ACTIVITY_TYPE_UNDEFINED = 0;
    public static final int ACTIVITY_TYPE_STANDARD = 1;
    public static final int ACTIVITY_TYPE_HOME = 2;
    public static final int ACTIVITY_TYPE_RECENTS = 3;
    public static final int ACTIVITY_TYPE_ASSISTANT = 4;
    public static final int WINDOW_CONFIG_BOUNDS = 1;
    public static final int WINDOW_CONFIG_APP_BOUNDS = 2;
    public static final int WINDOW_CONFIG_WINDOWING_MODE = 4;
    public static final int WINDOW_CONFIG_ACTIVITY_TYPE = 8;
    public static final int PINNED_WINDOWING_MODE_ELEVATION_IN_DIP = 5;
    public static final Parcelable.Creator<WindowConfiguration> CREATOR = new Parcelable.Creator<WindowConfiguration>(){

        @Override
        public WindowConfiguration createFromParcel(Parcel in) {
            return new WindowConfiguration(in);
        }

        public WindowConfiguration[] newArray(int size) {
            return new WindowConfiguration[size];
        }
    };

    public WindowConfiguration() {
        this.unset();
    }

    public WindowConfiguration(WindowConfiguration configuration) {
        this.setTo(configuration);
    }

    private WindowConfiguration(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mBounds, flags);
        dest.writeParcelable(this.mAppBounds, flags);
        dest.writeInt(this.mWindowingMode);
        dest.writeInt(this.mActivityType);
    }

    private void readFromParcel(Parcel source) {
        this.mBounds = (Rect)source.readParcelable(Rect.class.getClassLoader());
        this.mAppBounds = (Rect)source.readParcelable(Rect.class.getClassLoader());
        this.mWindowingMode = source.readInt();
        this.mActivityType = source.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setBounds(Rect rect) {
        if (rect == null) {
            this.mBounds.setEmpty();
            return;
        }
        this.mBounds.set(rect);
    }

    public void setAppBounds(Rect rect) {
        if (rect == null) {
            this.mAppBounds = null;
            return;
        }
        this.setAppBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setAppBounds(int left, int top, int right, int bottom) {
        if (this.mAppBounds == null) {
            this.mAppBounds = new Rect();
        }
        this.mAppBounds.set(left, top, right, bottom);
    }

    public Rect getAppBounds() {
        return this.mAppBounds;
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    public void setWindowingMode(@WindowingMode int windowingMode) {
        this.mWindowingMode = windowingMode;
    }

    @WindowingMode
    public int getWindowingMode() {
        return this.mWindowingMode;
    }

    public void setActivityType(@ActivityType int activityType) {
        if (this.mActivityType == activityType) {
            return;
        }
        if (ActivityThread.isSystem() && this.mActivityType != 0 && activityType != 0) {
            throw new IllegalStateException("Can't change activity type once set: " + this + " activityType=" + WindowConfiguration.activityTypeToString(activityType));
        }
        this.mActivityType = activityType;
    }

    @ActivityType
    public int getActivityType() {
        return this.mActivityType;
    }

    public void setTo(WindowConfiguration other) {
        this.setBounds(other.mBounds);
        this.setAppBounds(other.mAppBounds);
        this.setWindowingMode(other.mWindowingMode);
        this.setActivityType(other.mActivityType);
    }

    public void unset() {
        this.setToDefaults();
    }

    public void setToDefaults() {
        this.setAppBounds(null);
        this.setBounds(null);
        this.setWindowingMode(0);
        this.setActivityType(0);
    }

    @WindowConfig
    public int updateFrom(WindowConfiguration delta) {
        int changed = 0;
        if (!delta.mBounds.isEmpty() && !delta.mBounds.equals(this.mBounds)) {
            changed |= 1;
            this.setBounds(delta.mBounds);
        }
        if (delta.mAppBounds != null && !delta.mAppBounds.equals(this.mAppBounds)) {
            changed |= 2;
            this.setAppBounds(delta.mAppBounds);
        }
        if (delta.mWindowingMode != 0 && this.mWindowingMode != delta.mWindowingMode) {
            changed |= 4;
            this.setWindowingMode(delta.mWindowingMode);
        }
        if (delta.mActivityType != 0 && this.mActivityType != delta.mActivityType) {
            changed |= 8;
            this.setActivityType(delta.mActivityType);
        }
        return changed;
    }

    @WindowConfig
    public long diff(WindowConfiguration other, boolean compareUndefined) {
        long changes = 0L;
        if (!this.mBounds.equals(other.mBounds)) {
            changes |= 1L;
        }
        if (!(!compareUndefined && other.mAppBounds == null || this.mAppBounds == other.mAppBounds || this.mAppBounds != null && this.mAppBounds.equals(other.mAppBounds))) {
            changes |= 2L;
        }
        if ((compareUndefined || other.mWindowingMode != 0) && this.mWindowingMode != other.mWindowingMode) {
            changes |= 4L;
        }
        if ((compareUndefined || other.mActivityType != 0) && this.mActivityType != other.mActivityType) {
            changes |= 8L;
        }
        return changes;
    }

    @Override
    public int compareTo(WindowConfiguration that) {
        int n = 0;
        if (this.mAppBounds == null && that.mAppBounds != null) {
            return 1;
        }
        if (this.mAppBounds != null && that.mAppBounds == null) {
            return -1;
        }
        if (this.mAppBounds != null && that.mAppBounds != null) {
            n = this.mAppBounds.left - that.mAppBounds.left;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.top - that.mAppBounds.top;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.right - that.mAppBounds.right;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.bottom - that.mAppBounds.bottom;
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.mBounds.left - that.mBounds.left) != 0) {
            return n;
        }
        n = this.mBounds.top - that.mBounds.top;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.right - that.mBounds.right;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.bottom - that.mBounds.bottom;
        if (n != 0) {
            return n;
        }
        n = this.mWindowingMode - that.mWindowingMode;
        if (n != 0) {
            return n;
        }
        n = this.mActivityType - that.mActivityType;
        if (n != 0) {
            return n;
        }
        return n;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (!(that instanceof WindowConfiguration)) {
            return false;
        }
        return this.compareTo((WindowConfiguration)that) == 0;
    }

    public int hashCode() {
        int result = 0;
        if (this.mAppBounds != null) {
            result = 31 * result + this.mAppBounds.hashCode();
        }
        result = 31 * result + this.mBounds.hashCode();
        result = 31 * result + this.mWindowingMode;
        result = 31 * result + this.mActivityType;
        return result;
    }

    public String toString() {
        return "{ mBounds=" + this.mBounds + " mAppBounds=" + this.mAppBounds + " mWindowingMode=" + WindowConfiguration.windowingModeToString(this.mWindowingMode) + " mActivityType=" + WindowConfiguration.activityTypeToString(this.mActivityType) + "}";
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long fieldId) {
        long token = protoOutputStream.start(fieldId);
        if (this.mAppBounds != null) {
            this.mAppBounds.writeToProto(protoOutputStream, 0x10B00000001L);
        }
        protoOutputStream.write(1120986464258L, this.mWindowingMode);
        protoOutputStream.write(1120986464259L, this.mActivityType);
        protoOutputStream.end(token);
    }

    public boolean hasWindowShadow() {
        return this.tasksAreFloating();
    }

    public boolean hasWindowDecorCaption() {
        return this.mWindowingMode == 5;
    }

    public boolean canResizeTask() {
        return this.mWindowingMode == 5;
    }

    public boolean persistTaskBounds() {
        return this.mWindowingMode == 5;
    }

    public boolean tasksAreFloating() {
        return WindowConfiguration.isFloating(this.mWindowingMode);
    }

    public static boolean isFloating(int windowingMode) {
        return windowingMode == 5 || windowingMode == 2;
    }

    public boolean canReceiveKeys() {
        return this.mWindowingMode != 2;
    }

    public boolean isAlwaysOnTop() {
        return this.mWindowingMode == 2;
    }

    public boolean keepVisibleDeadAppWindowOnScreen() {
        return this.mWindowingMode != 2;
    }

    public boolean useWindowFrameForBackdrop() {
        return this.mWindowingMode == 5 || this.mWindowingMode == 2;
    }

    public boolean windowsAreScaleable() {
        return this.mWindowingMode == 2;
    }

    public boolean hasMovementAnimations() {
        return this.mWindowingMode != 2;
    }

    public boolean supportSplitScreenWindowingMode() {
        return WindowConfiguration.supportSplitScreenWindowingMode(this.mActivityType);
    }

    public static boolean supportSplitScreenWindowingMode(int activityType) {
        return activityType != 4;
    }

    public static String windowingModeToString(@WindowingMode int windowingMode) {
        switch (windowingMode) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "fullscreen";
            }
            case 2: {
                return "pinned";
            }
            case 3: {
                return "split-screen-primary";
            }
            case 4: {
                return "split-screen-secondary";
            }
            case 5: {
                return "freeform";
            }
        }
        return String.valueOf(windowingMode);
    }

    public static String activityTypeToString(@ActivityType int applicationType) {
        switch (applicationType) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "standard";
            }
            case 2: {
                return "home";
            }
            case 3: {
                return "recents";
            }
            case 4: {
                return "assistant";
            }
        }
        return String.valueOf(applicationType);
    }

    public static @interface WindowConfig {
    }

    public static @interface ActivityType {
    }

    public static @interface WindowingMode {
    }
}

