/*
 * Decompiled with CFR 0.152.
 */
package app.artyomd.injector;

import android.content.Context;
import android.util.Log;
import app.artyomd.injector.DexInjector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class DexUtils {
    private static final String TAG = DexUtils.class.getSimpleName();
    private static final int BUFFER_SIZE = 8192;

    public static void loadDex(Context context, List<File> list) {
        try {
            File optimizedDir = context.getDir("outdex", 0);
            DexInjector.installSecondaryDexes(context.getClassLoader(), optimizedDir, list);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareDex(Context context, File dexInternalStoragePath, String secondaryDexName) {
        BufferedInputStream bufferedInputStream = null;
        OutputStream dexWriter = null;
        if (!dexInternalStoragePath.exists()) {
            dexInternalStoragePath.getParentFile().mkdirs();
            try {
                dexInternalStoragePath.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
        try {
            int len;
            bufferedInputStream = new BufferedInputStream(context.getAssets().open(secondaryDexName));
            dexWriter = new BufferedOutputStream(new FileOutputStream(dexInternalStoragePath));
            byte[] buf = new byte[8192];
            while ((len = bufferedInputStream.read(buf, 0, 8192)) > 0) {
                dexWriter.write(buf, 0, len);
            }
            dexWriter.flush();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        finally {
            if (dexWriter != null) {
                try {
                    dexWriter.close();
                }
                catch (IOException ex) {
                    Log.e((String)TAG, (String)ex.toString());
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException ex) {
                    Log.e((String)TAG, (String)ex.toString());
                }
            }
        }
    }
}

