/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.qr;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.alan.alansdk.Alan;
import com.alan.alansdk.R;
import com.alan.alansdk.qr.BarcodeEvent;
import com.budiyev.android.codescanner.CodeScanner;
import com.budiyev.android.codescanner.CodeScannerView;
import com.budiyev.android.codescanner.DecodeCallback;
import com.google.zxing.Result;
import org.greenrobot.eventbus.EventBus;

public class QRScanActivity
extends AppCompatActivity {
    private CodeScanner mCodeScanner;
    private static final int PERMISSION_REQUEST_CODE = 101;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_qr_scan);
        TextView versionView = (TextView)this.findViewById(R.id.version_text);
        versionView.setText((CharSequence)Alan.getInstance((Context)this).getVersion());
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)101);
        } else {
            this.initCodeScanner();
        }
    }

    private void initCodeScanner() {
        CodeScannerView scannerView = (CodeScannerView)this.findViewById(R.id.scanner_view);
        this.mCodeScanner = new CodeScanner((Context)this, scannerView);
        this.mCodeScanner.setDecodeCallback(new DecodeCallback(){

            public void onDecoded(final @NonNull Result result) {
                QRScanActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        QRScanActivity.this.onBarcodeRecognized(result.getText());
                    }
                });
            }
        });
        this.mCodeScanner.startPreview();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (grantResults[0] == 0) {
            this.initCodeScanner();
        }
    }

    protected void onPause() {
        if (this.mCodeScanner != null) {
            this.mCodeScanner.releaseResources();
        }
        super.onPause();
    }

    private void onBarcodeRecognized(String barcode) {
        Intent result = new Intent();
        result.putExtra("BARCODE", barcode);
        if (Alan.QR_EVENT_BUS_ENABLED) {
            EventBus.getDefault().post((Object)new BarcodeEvent(barcode));
        }
        this.setResult(-1, result);
        this.finish();
    }
}

