/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.logging;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;

public class AlanLogger {
    private static final String LOG_FILE_NAME = "alan_logs.txt";
    public static boolean SHOULD_LOG = false;
    public static boolean LOG_2_FILE = false;
    private static List<String> logs = new LinkedList<String>();
    private static File logFile;
    private static FileWriter logWriter;

    private AlanLogger() {
    }

    public static void init(Context context) {
        AlanLogger.createLogFile(context);
    }

    private static String extractTag() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String tag = stackTraceElements[4].getClassName();
        return tag;
    }

    public static void d(String msg) {
    }

    public static void i(String msg) {
        if (SHOULD_LOG) {
            Log.i((String)AlanLogger.extractTag(), (String)msg);
        }
        if (LOG_2_FILE) {
            AlanLogger.log2File(LogLevel.BASIC, msg);
        }
    }

    public static void w(String msg) {
        if (SHOULD_LOG) {
            Log.w((String)AlanLogger.extractTag(), (String)msg);
        }
        if (LOG_2_FILE) {
            AlanLogger.log2File(LogLevel.BASIC, msg);
        }
    }

    public static void e(String msg) {
        if (SHOULD_LOG) {
            Log.e((String)AlanLogger.extractTag(), (String)msg);
        }
        if (LOG_2_FILE) {
            AlanLogger.log2File(LogLevel.BASIC, msg);
        }
    }

    public static void event(String msg) {
        if (SHOULD_LOG) {
            Log.i((String)AlanLogger.extractTag(), (String)msg);
        }
        if (LOG_2_FILE) {
            AlanLogger.log2File(LogLevel.EVENTS, msg);
        }
    }

    public static void e(Exception e) {
        AlanLogger.e(e.getMessage());
    }

    private static void createLogFile(Context context) {
        File file = new File(context.getFilesDir(), "logs");
        if (!file.exists()) {
            file.mkdir();
        }
        if ((logFile = new File(file, LOG_FILE_NAME)).exists()) {
            logFile.delete();
        }
        try {
            logFile.createNewFile();
            logWriter = new FileWriter(logFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void log2File(LogLevel logLevel, String body) {
        try {
            logWriter.append("\n");
            logWriter.append(logLevel.prefix);
            logWriter.append(body);
            logWriter.flush();
            logs.add(logLevel.prefix + body);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onDestroy() {
        try {
            logWriter.flush();
            logWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logs = null;
    }

    public static String readLogsFromFile(LogLevel logLevel) {
        StringBuilder text = new StringBuilder();
        if (logs != null && logs.size() > 0) {
            for (String str : logs) {
                if (logLevel != LogLevel.BASIC && str.startsWith(LogLevel.BASIC.prefix)) continue;
                text.append(str.substring(2));
                text.append("\n\n");
            }
        }
        return text.toString();
    }

    public static enum LogLevel {
        BASIC("B/"),
        EVENTS("E/");

        String prefix;

        private LogLevel(String prefix) {
            this.prefix = prefix;
        }
    }
}

