/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.alan.alansdk.button.animations.AnimationConfig;

public class ButtonXAnimation {
    private final View button;

    public ButtonXAnimation(View buttonView) {
        this.button = buttonView;
    }

    public void animate(float newX) {
        AnimatorSet anim = new AnimatorSet();
        ObjectAnimator setXAnimation = this.getXAnimation(this.button, newX);
        anim.play((Animator)setXAnimation);
        anim.start();
    }

    private ObjectAnimator getXAnimation(View view, float target) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)view, (String)"x", (float[])new float[]{view.getX(), target});
        animation.setDuration((long)AnimationConfig.BUTTON_X_ANIMATION_TIME);
        animation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}

