/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.alan.alansdk.button.GradientButton;
import com.alan.alansdk.button.animations.AnimationConfig;
import com.alan.alansdk.button.animations.BaseAnimation;

public class BackgroundAnimation
extends BaseAnimation {
    private GradientButton bgView;
    private static final long NORMAL_TIME = 12000L;
    private static final long RESPONDING_TIME = 6000L;
    private STATE state = STATE.NORMAL;

    public BackgroundAnimation(GradientButton bg) {
        this.bgView = bg;
    }

    public void setState(STATE state) {
        this.state = state;
        this.stopAnimation();
        this.anim = null;
    }

    public void startNormalAnimation() {
        this.setState(STATE.NORMAL);
        this.startAnimation();
    }

    public void startRespondingAnimation() {
        this.setState(STATE.RESPONDING);
        this.startAnimation();
    }

    @Override
    protected AnimatorSet buildAnimator() {
        this.anim = new AnimatorSet();
        if (this.state == STATE.NORMAL) {
            ObjectAnimator bgAnimation = this.getAnimation(this.bgView, 12000L);
            this.anim.play((Animator)bgAnimation);
        } else {
            ObjectAnimator bgAnimation = this.getAnimation(this.bgView, 6000L);
            ObjectAnimator bgScaleXAnimation = this.getScaleAnimation(this.bgView, "scaleX");
            ObjectAnimator bgScaleYAnimation = this.getScaleAnimation(this.bgView, "scaleY");
            this.anim.playTogether(new Animator[]{bgAnimation, bgScaleXAnimation, bgScaleYAnimation});
        }
        return this.anim;
    }

    private ObjectAnimator getScaleAnimation(View view, String property) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)view, (String)property, (float[])new float[]{1.0f, 1.1f});
        animation.setDuration((long)AnimationConfig.BACKGROUND_SCALE_ANIMATION_TIME);
        animation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(-1);
        animation.setRepeatMode(2);
        return animation;
    }

    private ObjectAnimator getAnimation(View view, long time) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        animation.setDuration(time);
        animation.setRepeatCount(-1);
        return animation;
    }

    @Override
    public void stopAnimation() {
        super.stopAnimation();
        this.bgView.setScaleX(1.0f);
        this.bgView.setScaleY(1.0f);
    }

    public static enum STATE {
        NORMAL,
        RESPONDING;

    }
}

