/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.alan.alansdk.Alan;
import com.alan.alansdk.AlanCallback;
import com.alan.alansdk.AlanConfig;
import com.alan.alansdk.AlanSDK;
import com.alan.alansdk.AlanState;
import com.alan.alansdk.R;
import com.alan.alansdk.ScriptMethodCallback;
import com.alan.alansdk.alanbase.ConnectionState;
import com.alan.alansdk.alanbase.SdkParams;
import com.alan.alansdk.button.AlanButtonInteractionListener;
import com.alan.alansdk.button.AlanStateListener;
import com.alan.alansdk.button.ColorManager;
import com.alan.alansdk.button.GradientButton;
import com.alan.alansdk.button.StateHandler;
import com.alan.alansdk.button.animations.ButtonXAnimation;
import com.alan.alansdk.button.animations.HintHideAnimation;
import com.alan.alansdk.logging.AlanLogger;
import com.alan.alansdk.qr.BarcodeEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class AlanButton
extends FrameLayout
implements AlanSDK {
    private static final String TAG = "AlanButton";
    public static final int BUTTON_LEFT = 1;
    public static final int BUTTON_RIGHT = 2;
    public static final Integer REQUEST_CODE_AUDIO_PERMISSIONS = 9009;
    private StateHandler stateHandler;
    public View button;
    private int buttonPosition;
    private boolean explicitButtonVisibility;
    private View hintPanelLeft;
    private TextView hintTextLeft;
    private View hintPanelRight;
    private TextView hintTextRight;
    private GradientButton gradientBg;
    private Point displaySize;
    private Alan sdk;
    private AlanStateListener stateListener;
    private ColorManager colorManager;
    public AlanButtonInteractionListener buttonInteractionListener;
    private HintHideAnimation hintHideAnimation;
    private ButtonXAnimation buttonXAnimation;
    private boolean showHintPanel = true;
    View activeHintPanel;
    TextView activeHintText;
    public boolean stopStick = false;
    private Set<AlanCallback> buttonCallbacks = new LinkedHashSet<AlanCallback>();
    private float oldX = -100.0f;
    private static final long QR_PRESS_TIME = TimeUnit.SECONDS.toMillis(5L);
    private static final float DRAG_TRESHOLD = 100.0f;
    private boolean clickState = false;
    private boolean dragState = false;
    private float startX = 0.0f;
    private float startY = 0.0f;
    private float deltaX = 0.0f;
    private float deltaY = 0.0f;
    private boolean isQrMode = false;
    private QrTimerTask qrTimerTask;
    private Timer qrTimer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlanButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AlanButton, 0, 0);
        try {
            this.buttonPosition = a.getInt(R.styleable.AlanButton_button_horizontal_align, 2);
        }
        finally {
            a.recycle();
        }
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.addView(inflater.inflate(R.layout.alan_button, null));
        this.gradientBg = (GradientButton)this.findViewById(R.id.button_background);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        this.displaySize = new Point();
        display.getSize(this.displaySize);
        this.buttonInteractionListener = new AlanButtonInteractionListener(){

            @Override
            public void onQRTime() {
                Alan.openQRScanner(AlanButton.this.getActivity());
            }
        };
        this.colorManager = new ColorManager(this.getContext());
        this.stateListener = new AlanStateListener(this, this.colorManager);
        EventBus.getDefault().register((Object)this);
        this.init();
        this.setWillNotDraw(false);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        AlanLogger.e("on save instance");
        if (this.sdk != null) {
            this.sdk.onBackground();
        }
        return super.onSaveInstanceState();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        AlanLogger.e("on restore instance");
        if (this.sdk != null) {
            this.sdk.onForeground();
        }
    }

    @Subscribe(threadMode=ThreadMode.ASYNC)
    public void onBarcodeEvent(BarcodeEvent event) {
        SdkParams data = Alan.extractParamsFromBarcode(event.getPayload());
        if (data == null) {
            return;
        }
        this.sdk.unregisterCallback(this.stateListener);
        this.initWithConfig(data.toConfig());
    }

    private void setSDK(Alan sdk) {
        this.sdk = sdk;
        this.showHintPanel = !sdk.hideHintPanel();
    }

    public boolean initWithConfig(AlanConfig config) {
        this.setSDK(Alan.getInstance(this.getContext().getApplicationContext()));
        this.sdk.registerCallback(this.stateListener);
        return this.sdk.initWithConfig(config);
    }

    public void initWithSDK(Alan alan) {
        if (this.sdk != null) {
            this.sdk.deactivate();
            this.sdk.clearCallbacks();
            this.sdk = null;
        }
        this.setSDK(alan);
        this.sdk.registerCallback(this.stateListener);
    }

    @Deprecated
    public boolean initSDK(@Nullable String server, String projectId, @Nullable String dialogId, @Nullable String authJson) {
        AlanConfig config = AlanConfig.builder().setServer(server).setProjectId(projectId).setDialogId(dialogId).setDataObject(authJson).build();
        return this.initWithConfig(config);
    }

    @Deprecated
    public boolean initSDK(String server, String projectId, @Nullable String dialogId) {
        return this.initSDK(null, projectId, dialogId, null);
    }

    @Deprecated
    public boolean initSDK(String projectId, String dialogId) {
        return this.initSDK(null, projectId, dialogId, null);
    }

    @Deprecated
    public boolean initSDK(String projectId) {
        return this.initSDK(null, projectId, null, null);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.sdk != null) {
            this.sdk.unregisterCallback(this.stateListener);
        }
        EventBus.getDefault().unregister((Object)this);
    }

    private void init() {
        this.stateHandler = new StateHandler(this.getContext().getApplicationContext(), this, this.colorManager);
        this.button = this.findViewById(R.id.button_container);
        this.buttonXAnimation = new ButtonXAnimation(this.button);
        this.hintPanelLeft = this.findViewById(R.id.hint_panel_left);
        this.hintTextLeft = (TextView)this.findViewById(R.id.hint_text);
        this.hintPanelRight = this.findViewById(R.id.hint_panel_right);
        this.hintTextRight = (TextView)this.findViewById(R.id.hint_text_right);
        this.hintPanelRight.setTag((Object)"RIGHT");
        this.hintPanelLeft.setTag((Object)"LEFT");
        this.setElevation(20.0f);
        this.setSDK(Alan.getInstance(this.getContext().getApplicationContext()));
        this.showHintPanel = this.sdk.hideHintPanel();
        if (!this.showHintPanel) {
            this.hintPanelLeft.setVisibility(8);
            this.hintPanelRight.setVisibility(8);
        }
        this.button.setOnTouchListener((View.OnTouchListener)new ButtonTouchListener());
        if (this.sdk.getConnectionState() != ConnectionState.CONNECTED) {
            this.gradientBg.setColors(this.colorManager.getDisconnectedColor().getFirstColor(), this.colorManager.getDisconnectedColor().getSecondColor());
            this.stateHandler.setDisconnectedState();
        } else {
            this.gradientBg.setColors(this.colorManager.getIdleColor().getFirstColor(), this.colorManager.getIdleColor().getSecondColor());
            this.setState(AlanState.ONLINE, true);
        }
        this.sdk.registerCallback(this.stateListener);
    }

    void reset() {
        if (this.stateHandler.getState() == AlanState.ONLINE) {
            this.stateHandler.setIdleState();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.stopStick) {
            this.oldX = this.button.getX();
            return;
        }
        if (this.button.getX() != this.oldX || this.activeHintText == null && this.showHintPanel) {
            this.resetHintPanelState();
            this.stickToEdge(this.buttonPosition);
        }
    }

    private void reLayoutChildren(final View view) {
        this.post(new Runnable(){

            @Override
            public void run() {
                view.measure(View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000));
                view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            }
        });
    }

    private void toggleHintVisibility() {
        if (this.showHintPanel) {
            this.showHintPanel();
        } else {
            this.hideHintPanel();
        }
    }

    public void setHintPanelVisibility(boolean hintVisibility) {
        this.showHintPanel = hintVisibility;
    }

    private void toggleAlan() {
        if (this.sdk == null) {
            return;
        }
        if (!this.checkAudioPermissions()) {
            AlanLogger.w("No audio permissions. Request RECORD_AUDIO first!");
            this.requestAudioPermissions();
            return;
        }
        this.sdk.toggle();
    }

    private boolean checkAudioPermissions() {
        return ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.RECORD_AUDIO") == 0;
    }

    public void requestAudioPermissions() {
        Activity hostedActivity;
        if (Build.VERSION.SDK_INT >= 23 && (hostedActivity = this.getActivity()) != null) {
            hostedActivity.requestPermissions(new String[]{"android.permission.RECORD_AUDIO"}, REQUEST_CODE_AUDIO_PERMISSIONS.intValue());
        }
    }

    private Activity getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public boolean performClick() {
        this.toggleAlan();
        return super.performClick();
    }

    public boolean performLongClick() {
        return super.performLongClick();
    }

    private void setButtonPosition(float x, float y) {
        this.button.setX(x);
        this.setY(y);
    }

    private void stickToEdge() {
        int screenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.buttonPosition = this.button.getX() + (float)(this.button.getWidth() / 2) < (float)(screenWidth / 2) ? 1 : 2;
        this.stickToEdge(this.buttonPosition);
    }

    private void stickToEdge(int align) {
        this.buttonPosition = align;
        if (this.stopStick) {
            return;
        }
        switch (align) {
            case 1: {
                this.buttonXAnimation.animate(0.0f);
                break;
            }
            case 2: {
                this.buttonXAnimation.animate(this.getWidth() - this.button.getWidth());
                break;
            }
            default: {
                AlanLogger.e("Unknown button alignment");
            }
        }
    }

    public void setButtonAlign(int buttonAlign) {
        this.stickToEdge(buttonAlign);
    }

    public void setState(AlanState alanState) {
        if (alanState == AlanState.ONLINE) {
            this.showHintPanel = !this.sdk.hideHintPanel();
        }
        this.setState(alanState, false);
    }

    public void setDisconnectedState() {
        this.stateHandler.setDisconnectedState();
    }

    public void setState(AlanState alanState, boolean force) {
        this.stateHandler.setState(alanState);
        this.post(new Runnable(){

            @Override
            public void run() {
                AlanButton.this.invalidate();
            }
        });
    }

    public AlanState getState() {
        return this.stateHandler.getState();
    }

    public void hideHintPanel() {
        if (this.activeHintPanel != null && this.activeHintPanel.getAlpha() == 1.0f) {
            this.hintHideAnimation.startAnimation();
        }
    }

    void showHintPanel() {
        if (this.activeHintPanel == null) {
            return;
        }
        this.activeHintPanel.setAlpha(1.0f);
        if (this.activeHintPanel.getVisibility() != 0) {
            this.activeHintPanel.setVisibility(0);
        }
    }

    private void resetHintPanelState() {
        this.oldX = this.button.getX();
        if (!this.showHintPanel) {
            return;
        }
        if (this.button.getX() < 100.0f) {
            this.activeHintPanel = this.hintPanelRight;
            this.activeHintText = this.hintTextRight;
        } else {
            this.activeHintPanel = this.hintPanelLeft;
            this.activeHintText = this.hintTextLeft;
        }
        this.hintHideAnimation = new HintHideAnimation(this.activeHintPanel);
        this.reLayoutChildren((View)this);
    }

    public void hideButton() {
        this.setVisibility(8);
        this.explicitButtonVisibility = true;
    }

    public boolean hintPanelVisible() {
        return this.showHintPanel;
    }

    public void showButton() {
        if (this.sdk == null) {
            Log.w((String)TAG, (String)"Button is disabled, skipping show");
            return;
        }
        this.setVisibility(0);
    }

    void hideButtonInternal() {
        this.hideButton();
    }

    void showButtonInternal() {
        if (!this.explicitButtonVisibility) {
            this.showButton();
        }
    }

    public void disableButton() {
        this.hideButton();
    }

    public Alan getSDK() {
        return this.sdk;
    }

    public void registerCallback(AlanCallback callback) {
        if (this.sdk != null) {
            this.buttonCallbacks.add(callback);
            this.sdk.registerCallback(callback);
        }
    }

    public void removeCallback(AlanCallback callback) {
        if (this.sdk != null) {
            this.buttonCallbacks.remove(callback);
            this.sdk.unregisterCallback(callback);
        }
    }

    public void clearCallbacks() {
        for (AlanCallback callback : this.buttonCallbacks) {
            this.removeCallback(callback);
        }
    }

    @Override
    public void callProjectApi(String method, String jsonParams) {
        this.callProjectApi(method, jsonParams, null);
    }

    @Override
    public void callProjectApi(String method, String jsonParams, @Nullable ScriptMethodCallback callback) {
        if (this.sdk != null) {
            this.sdk.callProjectApi(method, jsonParams, callback);
        }
    }

    @Override
    public void playText(String text, @Nullable ScriptMethodCallback callback) {
        if (this.sdk != null) {
            this.sdk.playText(text, callback);
        }
    }

    @Override
    public void playText(String text) {
        this.playText(text, null);
    }

    @Override
    public void playCommand(String data, @Nullable ScriptMethodCallback callback) {
        if (this.sdk != null) {
            this.sdk.playCommand(data, callback);
        }
    }

    @Override
    public void setVisualState(String visualState) {
        if (this.sdk != null) {
            this.sdk.setVisualState(visualState);
        }
    }

    @Override
    public void activate() {
        if (this.sdk != null) {
            this.sdk.activate();
        }
    }

    @Override
    public void deactivate() {
        if (this.sdk != null) {
            this.sdk.deactivate();
        }
    }

    @Override
    public boolean isActive() {
        if (this.sdk == null) {
            return false;
        }
        return this.sdk.alanState == AlanState.LISTEN || this.sdk.alanState == AlanState.PROCESS || this.sdk.alanState == AlanState.REPLY;
    }

    class ButtonTouchListener
    implements View.OnTouchListener {
        ButtonTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    AlanButton.this.clickState = true;
                    AlanButton.this.stateHandler.setTouchedState();
                    AlanButton.this.startX = event.getRawX();
                    AlanButton.this.startY = event.getRawY();
                    AlanButton.this.deltaX = event.getRawX() - AlanButton.this.button.getX();
                    AlanButton.this.deltaY = event.getRawY() - AlanButton.this.getY();
                    AlanButton.this.qrTimer = new Timer();
                    AlanButton.this.qrTimerTask = new QrTimerTask();
                    AlanButton.this.qrTimer.schedule((TimerTask)AlanButton.this.qrTimerTask, QR_PRESS_TIME);
                    break;
                }
                case 1: {
                    AlanButton.this.stateHandler.setUntouchedState();
                    if (AlanButton.this.dragState) {
                        AlanButton.this.stopStick = false;
                        AlanButton.this.stickToEdge();
                    }
                    if (AlanButton.this.clickState) {
                        AlanButton.this.clickState = false;
                        if (!AlanButton.this.isQrMode) {
                            AlanButton.this.performClick();
                        }
                        AlanButton.this.isQrMode = false;
                    }
                    AlanButton.this.dragState = false;
                    AlanButton.this.qrTimer.cancel();
                    break;
                }
                case 2: {
                    if (!(Math.abs(event.getRawX() - AlanButton.this.startX) >= 100.0f) && !(Math.abs(event.getRawY() - AlanButton.this.startY) >= 100.0f)) break;
                    AlanButton.this.dragState = true;
                    float newX = Math.max(0.0f, Math.min(event.getRawX() - AlanButton.this.deltaX, (float)(((AlanButton)AlanButton.this).displaySize.x - AlanButton.this.button.getWidth())));
                    float newY = Math.max(0.0f, Math.min(event.getRawY() - AlanButton.this.deltaY, (float)(((AlanButton)AlanButton.this).displaySize.y - AlanButton.this.getHeight())));
                    AlanButton.this.setButtonPosition(newX, newY);
                    AlanButton.this.clickState = false;
                    AlanButton.this.qrTimer.cancel();
                    AlanButton.this.hideHintPanel();
                }
            }
            return true;
        }
    }

    class QrTimerTask
    extends TimerTask {
        QrTimerTask() {
        }

        @Override
        public void run() {
            AlanButton.this.isQrMode = true;
            AlanLogger.i("" + QR_PRESS_TIME + " seconds passed");
            if (AlanButton.this.buttonInteractionListener != null) {
                AlanButton.this.buttonInteractionListener.onQRTime();
            }
        }
    }
}

