/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.alanbase.speaker;

import android.media.AudioTrack;
import android.os.Process;
import com.alan.alansdk.alanbase.AudioConfig;
import com.alan.alansdk.alanbase.speaker.SpeakerDumpListener;
import com.alan.alansdk.logging.AlanLogger;

public class SpeakerThread
extends Thread {
    private AudioTrack audioTrack;
    private boolean shouldSpeak = false;
    private final SpeakerDumpListener callback;
    private boolean shouldStop = false;

    public SpeakerThread(SpeakerDumpListener callback) {
        this.callback = callback;
        Process.setThreadPriority((int)-19);
    }

    public void cancel() {
        this.shouldStop = true;
    }

    @Override
    public void run() {
        super.run();
        while (!this.shouldStop) {
            try {
                SpeakerThread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.readFrames();
            }
        }
    }

    public void release() {
        this.shouldSpeak = false;
        this.shouldStop = true;
        if (this.audioTrack != null) {
            this.audioTrack.flush();
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    public void stopPlaying() {
        this.shouldSpeak = false;
    }

    public void readFrames() {
        this.shouldSpeak = true;
        if (this.audioTrack == null || this.audioTrack.getState() == 0) {
            AlanLogger.w("Reading frames from null or not initialized audiotrack");
            if (this.audioTrack != null) {
                this.audioTrack.release();
            }
            this.preparePlayer();
            try {
                SpeakerThread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return;
        }
        this.audioTrack.play();
        AlanLogger.d("Audio streaming started");
        float[] buffer = this.callback.retrieveAudioBuffer();
        while (this.shouldSpeak) {
            if (buffer != null) {
                this.audioTrack.write(buffer, 0, buffer.length, 0);
            }
            buffer = this.callback.retrieveAudioBuffer();
        }
    }

    private boolean preparePlayer() {
        int bufferSize = AudioTrack.getMinBufferSize((int)AudioConfig.SAMPLE_RATE, (int)4, (int)4);
        if (bufferSize == -1 || bufferSize == -2) {
            bufferSize = AudioConfig.SAMPLE_RATE * 2;
        }
        this.audioTrack = new AudioTrack(3, AudioConfig.SAMPLE_RATE, 4, 4, bufferSize, 1);
        try {
            SpeakerThread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }
}

