/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.alanbase.recorder;

import android.os.Build;
import com.alan.alansdk.alanbase.recorder.RecordDumpListener;
import com.alan.alansdk.alanbase.recorder.RecorderApi21;
import com.alan.alansdk.alanbase.recorder.RecorderApi23;
import com.alan.alansdk.alanbase.recorder.RecorderThread;
import com.alan.alansdk.logging.AlanLogger;

public class AlanRecorder
implements RecordDumpListener {
    private RecorderThread recorderThread;

    public void stopRecording() {
        if (this.recorderThread == null || !this.recorderThread.shouldContinue) {
            return;
        }
        this.recorderThread.stopRecording();
    }

    public void startRecording() {
        if (this.recorderThread != null && this.recorderThread.isAlive()) {
            AlanLogger.i("Recorder already started");
            return;
        }
        this.recorderThread = Build.VERSION.SDK_INT >= 23 ? new RecorderApi23(this) : new RecorderApi21(this);
        this.recorderThread.start();
    }

    public void skipMillis(int millis) {
        this.recorderThread.skipMillis(millis);
    }

    @Override
    public void onRecordDump(float[] dump) {
        this.writeFrameNative(dump);
    }

    private native void writeFrameNative(float[] var1);
}

