package com.alan.alansdk.button;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class HintHiderTask extends TimerTask {

    private AlanButton button;

    public HintHiderTask(AlanButton button) {
        this.button = button;
    }

    private Timer timer;

    private volatile long stopAt = 0;
    private final long TIMEOUT = TimeUnit.SECONDS.toMillis(2);

    public synchronized void set() {
        stopAt = System.currentTimeMillis() + TIMEOUT;
    }

    public void run() {
        if (System.currentTimeMillis() >= stopAt) {
            button.getRootView().post(new Runnable() {
                @Override
                public void run() {
                    button.hideHintPanel();
                }
            });
        }
    }

    public synchronized void start() {
        set();
        timer = new Timer();
        timer.schedule(this, 0, TIMEOUT);
    }
}
