package com.alan.alansdk;

import androidx.annotation.NonNull;

import org.json.JSONObject;

public class AlanConfig  implements Cloneable {

    private String server;
    private String projectId;
    private String dialogId;
    private String authJson;

    public String getProjectId() {
        return projectId;
    }

    public String getDialogId() {
        return dialogId;
    }

    public String getDataObject() {
        return authJson;
    }

    public String getServer() {
        if (server == null || server.isEmpty()) {
            return BuildConfig.API_ENDPOINT;
        } else {
            return server;
        }
    }

    public void setAuthJson(String authJson) {
        this.authJson = authJson;
    }

    public static Builder builder() {
        return new AlanConfig().new Builder();
    }

    public class Builder {

        private Builder() {

        }

        public Builder setServer(String server) {
            if (!server.startsWith("wss://")) {
                server = "wss://" + server;
            }
            AlanConfig.this.server = server;
            return this;
        }

        public Builder setProjectId(String projectId) {
            AlanConfig.this.projectId = projectId;
            return this;
        }

        public Builder setDialogId(String dialogId) {
            AlanConfig.this.dialogId = dialogId;
            return this;
        }

        public Builder setDataObject(String authJson) {
            AlanConfig.this.authJson = authJson;
            return this;
        }

        public Builder setDataObject(JSONObject authJson) {
            AlanConfig.this.authJson = authJson.toString();
            return this;
        }

        public AlanConfig build() {
            try {
                return (AlanConfig) AlanConfig.this.clone();
            } catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    @NonNull
    @Override
    protected Object clone() throws CloneNotSupportedException {
        AlanConfig clone = new AlanConfig();
        clone.server = this.server;
        clone.projectId = this.projectId;
        clone.dialogId = this.dialogId;
        clone.authJson = this.authJson;
        return clone;
    }
}
