/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.events;

import android.graphics.Color;
import androidx.annotation.Nullable;
import com.alan.alansdk.Utils;
import com.alan.alansdk.prefs.AlanPrefs;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class EventOptions
implements Serializable {
    public static final String EVENT_NAME = "options";
    @SerializedName(value="projectName")
    public String projectName;
    @SerializedName(value="android")
    private AndroidSettings androidSettings;
    @SerializedName(value="wakewordPath")
    public String wakeWordPath;

    public String getWakeWordModelName() {
        return Utils.extractFileNameFromUrl(this.wakeWordPath);
    }

    public static EventOptions fromJson(String json) {
        Gson gson = new Gson();
        return (EventOptions)gson.fromJson(json, EventOptions.class);
    }

    public AndroidSettings getAndroidSettings() {
        if (this.androidSettings == null) {
            return new AndroidSettings();
        }
        return this.androidSettings;
    }

    public static class AndroidSettings
    implements Serializable {
        @SerializedName(value="hidden")
        public boolean isButtonHidden = false;
        @SerializedName(value="btnOptions")
        public ButtonOptions buttonOptions;
        @SerializedName(value="wakeWordEnabled")
        @Nullable
        private Boolean isWakeWordEnabled;
        @SerializedName(value="selectedBtnOptionId")
        public String btnOptionId;
        @SerializedName(value="timeout")
        @Nullable
        private Long timeout;
        @SerializedName(value="hideS2TPanel")
        private boolean hideS2TPanel = false;
        @SerializedName(value="screenshotEnabled")
        private boolean screenShotsEnabled;
        @SerializedName(value="keepMicrophoneInBackground")
        public boolean keepMicrophoneInBackground;

        public boolean isScreenShotsEnabled() {
            return this.screenShotsEnabled;
        }

        public Boolean isWakeWordEnabled() {
            if (this.isWakeWordEnabled == null) {
                return AlanPrefs.DEFAULT_WAKEWORD_STATE;
            }
            return this.isWakeWordEnabled;
        }

        public Long getTimeout() {
            if (this.timeout == null) {
                return AlanPrefs.DEFAULT_TIMEOUT;
            }
            return this.timeout;
        }

        public boolean shouldHideS2TPanel() {
            return this.hideS2TPanel;
        }

        public static class ButtonOptions
        implements Serializable {
            @SerializedName(value="idle")
            public ButtonColor idleColor;
            @SerializedName(value="listen")
            public ButtonColor listenColor;
            @SerializedName(value="process")
            public ButtonColor processColor;
            @SerializedName(value="reply")
            public ButtonColor replyColor;
        }
    }

    public static class AlanColor
    implements Serializable {
        @SerializedName(value="angle")
        public int angle;
        @SerializedName(value="color")
        public List<String> colorList;

        public int getFirstColor() {
            if (this.colorList.size() > 0) {
                return Color.parseColor((String)this.colorList.get(0));
            }
            return -16776961;
        }

        public int getSecondColor() {
            if (this.colorList.size() > 1) {
                return Color.parseColor((String)this.colorList.get(1));
            }
            return -16776961;
        }

        public AlanColor() {
        }

        public AlanColor(String color1, String color2) {
            this.angle = 45;
            this.colorList = Arrays.asList(color1, color2);
        }
    }

    public static class ButtonColor
    implements Serializable {
        @SerializedName(value="background")
        public AlanColor background;
        @SerializedName(value="shadow")
        public AlanColor shadow;
    }
}

