/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button;

import android.content.Context;
import android.os.PowerManager;
import com.alan.alansdk.logging.AlanLogger;

public class WakeLockManager {
    private Context context;
    private PowerManager.WakeLock wakeLock;

    public WakeLockManager(Context context) {
        this.context = context;
    }

    void acquireWakeLock() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            AlanLogger.w("Wakelock already acquired");
            return;
        }
        PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
        this.wakeLock = powerManager.newWakeLock(6, "AlanSDK::ButtonWakeLock");
        this.wakeLock.acquire();
        AlanLogger.d("Wakelock acquired");
    }

    void releaseWakeLock() {
        if (this.wakeLock == null || !this.wakeLock.isHeld()) {
            return;
        }
        this.wakeLock.release();
        AlanLogger.d("Wakelock released");
    }
}

