/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.alanbase.recorder;

import android.annotation.TargetApi;
import android.media.AudioRecord;
import com.alan.alansdk.alanbase.AudioConfig;
import com.alan.alansdk.alanbase.recorder.RecordDumpListener;
import com.alan.alansdk.alanbase.recorder.RecorderThread;
import com.alan.alansdk.logging.AlanLogger;
import java.util.Arrays;

@TargetApi(value=23)
public class RecorderApi23
extends RecorderThread {
    private float[] audioBuffer;
    private int samplesToSkip = 0;

    public RecorderApi23(RecordDumpListener callback) {
        super(callback);
    }

    @Override
    protected void skip(int samples) {
        this.samplesToSkip = samples;
    }

    @Override
    protected boolean prepareRecorder() {
        int bufferSize = AudioRecord.getMinBufferSize((int)AudioConfig.SAMPLE_RATE, (int)16, (int)4);
        if (bufferSize == -1 || bufferSize == -2) {
            bufferSize = AudioConfig.SAMPLE_RATE * 2;
        }
        this.audioBuffer = new float[bufferSize / 2];
        this.record = new AudioRecord(1, AudioConfig.SAMPLE_RATE, 16, 4, bufferSize);
        if (this.record.getState() != 1) {
            AlanLogger.e("Audio Record can't initialize!");
            return false;
        }
        this.shouldContinue = true;
        return this.shouldContinue;
    }

    @Override
    protected void writeFrames() {
        if (this.audioBuffer.length > 0) {
            if (this.samplesToSkip > 0) {
                int skip = Math.min(this.audioBuffer.length, this.samplesToSkip);
                this.samplesToSkip -= skip;
                if (skip >= this.audioBuffer.length) {
                    return;
                }
                float[] skippedBuffer = Arrays.copyOfRange(this.audioBuffer, skip, this.audioBuffer.length);
                this.callback.onRecordDump(skippedBuffer);
            } else {
                this.callback.onRecordDump(this.audioBuffer);
            }
        }
    }

    @Override
    protected int readBuffer() {
        return this.record.read(this.audioBuffer, 0, this.audioBuffer.length, 0);
    }
}

