/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk;

import android.content.Context;
import androidx.annotation.Nullable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Utils {
    public static String extractFileNameFromUrl(@Nullable String url) {
        int lastHashPos;
        if (url == null) {
            return "";
        }
        if (!url.startsWith("/data/user")) {
            try {
                URL resource = new URL(url);
                String host = resource.getHost();
                if (host.length() > 0 && url.endsWith(host)) {
                    return "";
                }
            }
            catch (MalformedURLException e) {
                return "";
            }
        }
        int startIndex = url.lastIndexOf(47) + 1;
        int length = url.length();
        int lastQMPos = url.lastIndexOf(63);
        if (lastQMPos == -1) {
            lastQMPos = length;
        }
        if ((lastHashPos = url.lastIndexOf(35)) == -1) {
            lastHashPos = length;
        }
        int endIndex = Math.min(lastQMPos, lastHashPos);
        return url.substring(startIndex, endIndex);
    }

    public static File getWakeWordModelFile(Context context, String modelName) {
        return new File(context.getFilesDir() + "/wakeword/" + modelName);
    }
}

