package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.content.res.Resources;
import android.widget.ImageView;

class LogoStateAnimationListener implements Animator.AnimatorListener {

    private int logoState = 0;
    private ImageView logoView;
    private Integer[] logoStates;
    private Resources resources;
    private boolean invisible = false;

    public LogoStateAnimationListener(Integer[] logoStates, ImageView logoView, int initialStateIndex) {
        this.logoView = logoView;
        this.resources = logoView.getResources();
        this.logoStates = logoStates;
        logoState = initialStateIndex;
        invisible = initialStateIndex != 0;
    }

    @Override
    public void onAnimationStart(Animator animation) {

    }

    @Override
    public void onAnimationEnd(Animator animation) {

    }

    @Override
    public void onAnimationCancel(Animator animation) {

    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        invisible = !invisible;
        if (invisible) {
            logoState += 2;
            int logo = logoStates[logoState % logoStates.length];
            logoView.setImageDrawable(resources.getDrawable(logo));
        }
    }
}