package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;

abstract public class BaseAnimation {

    protected AnimatorSet anim;

    public void startAnimation() {
        if (anim == null) {
            anim = buildAnimator();
        }
        if (!anim.isRunning()) {
            anim.start();
        }
    }

    public boolean isAnimationRunning() {
        if (anim == null) {
            return false;
        }
        return anim.isRunning();
    }

    public void stopAnimation() {
        if (anim != null && anim.isRunning()) {
            anim.cancel();
        }
    }

    abstract protected AnimatorSet buildAnimator();
}
