/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.alan.alansdk.button.animations.AnimationConfig;
import com.alan.alansdk.button.animations.BaseAnimation;

public class SpeakingBackAnimation
extends BaseAnimation {
    private View innerBgView;
    private STATE state;

    public SpeakingBackAnimation(View bg, STATE state) {
        this.innerBgView = bg;
        this.state = state;
    }

    public void setState(STATE state) {
        this.state = state;
        this.stopAnimation();
        this.anim = null;
    }

    public void startSpeakingBackAnimation() {
        this.setState(STATE.SPEAKING_BACK);
        this.startAnimation();
    }

    public void startRespondingAnimation() {
        this.setState(STATE.IDLE);
        this.startAnimation();
    }

    @Override
    protected AnimatorSet buildAnimator() {
        this.anim = new AnimatorSet();
        if (this.state == STATE.SPEAKING_BACK) {
            ObjectAnimator bgAnimationX = this.getScaleAnimation(this.innerBgView, "scaleX", true);
            ObjectAnimator bgAnimationY = this.getScaleAnimation(this.innerBgView, "scaleY", true);
            ObjectAnimator bgAnimationAlpha = this.getScaleAnimation(this.innerBgView, "alpha", true);
            this.anim.playTogether(new Animator[]{bgAnimationX, bgAnimationY, bgAnimationAlpha});
        } else {
            ObjectAnimator bgAnimationX = this.getScaleAnimation(this.innerBgView, "scaleX", false);
            ObjectAnimator bgAnimationY = this.getScaleAnimation(this.innerBgView, "scaleY", false);
            ObjectAnimator bgAnimationAlpha = this.getScaleAnimation(this.innerBgView, "alpha", false);
            this.anim.playTogether(new Animator[]{bgAnimationX, bgAnimationY, bgAnimationAlpha});
        }
        return this.anim;
    }

    private ObjectAnimator getScaleAnimation(View view, String property, boolean collapsing) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)view, (String)property, (float[])new float[]{collapsing ? 1.0f : 0.0f, collapsing ? 0.0f : 1.0f});
        animation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animation.setDuration((long)AnimationConfig.REPLY_ANIMATION_TIME);
        animation.setRepeatCount(0);
        return animation;
    }

    public static enum STATE {
        SPEAKING_BACK,
        IDLE;

    }
}

