/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.alan.alansdk.button.animations.AnimationConfig;
import com.alan.alansdk.button.animations.BaseAnimation;

public class HintHideAnimation
extends BaseAnimation {
    private View hintView;

    public HintHideAnimation(View hintView) {
        this.hintView = hintView;
    }

    @Override
    protected AnimatorSet buildAnimator() {
        this.anim = new AnimatorSet();
        ObjectAnimator fadeAnimation = this.getAlphaAnimation(this.hintView);
        this.anim.play((Animator)fadeAnimation);
        this.anim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                HintHideAnimation.this.hintView.setVisibility(8);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        return this.anim;
    }

    private ObjectAnimator getAlphaAnimation(View view) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        animation.setDuration((long)AnimationConfig.HINT_HIDE_ANIMATION_TIME);
        animation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}

