/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;
import com.alan.alansdk.button.GradientButton;
import com.alan.alansdk.button.animations.AnimationConfig;
import com.alan.alansdk.button.animations.OnAnimationEnd;
import com.alan.alansdk.events.EventOptions;

public class ButtonColorAnimation {
    private final GradientButton button;
    private EventOptions.AlanColor lastColor = null;
    protected AnimatorSet anim;
    private int firstColor;
    private int secondColor;

    public ButtonColorAnimation(GradientButton buttonBg) {
        this.button = buttonBg;
    }

    public void start(final EventOptions.AlanColor alanColor, final OnAnimationEnd callback) {
        if (this.lastColor == null) {
            this.updateViews(alanColor.getFirstColor(), alanColor.getSecondColor());
            this.lastColor = alanColor;
            return;
        }
        this.anim = new AnimatorSet();
        this.anim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ButtonColorAnimation.this.lastColor = alanColor;
                if (callback != null) {
                    callback.onAnimationEnd();
                }
                ButtonColorAnimation.this.updateViews(alanColor.getFirstColor(), alanColor.getSecondColor());
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.firstColor = this.lastColor.getFirstColor();
        this.secondColor = this.lastColor.getSecondColor();
        ValueAnimator animator = this.getColorAnimation(this.lastColor.getFirstColor(), alanColor.getFirstColor());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ButtonColorAnimation.this.firstColor = (Integer)animation.getAnimatedValue();
            }
        });
        ValueAnimator animator2 = this.getColorAnimation(this.lastColor.getSecondColor(), alanColor.getSecondColor());
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ButtonColorAnimation.this.secondColor = (Integer)animation.getAnimatedValue();
                ButtonColorAnimation.this.updateViews(ButtonColorAnimation.this.firstColor, ButtonColorAnimation.this.secondColor);
            }
        });
        this.anim.playTogether(new Animator[]{animator, animator2});
        this.anim.start();
    }

    private void updateViews(int color1, int color2) {
        this.button.setColors(color1, color2);
    }

    private ValueAnimator getColorAnimation(int startColor, int endColor) {
        ValueAnimator animation = ValueAnimator.ofArgb((int[])new int[]{startColor, endColor});
        animation.setDuration((long)AnimationConfig.BUTTON_COLOR_ANIMATION_TIME);
        animation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}

