/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.alan.alansdk.Alan;
import com.alan.alansdk.AlanState;
import com.alan.alansdk.R;
import com.alan.alansdk.button.AlanButton;
import com.alan.alansdk.button.ColorManager;
import com.alan.alansdk.button.GradientButton;
import com.alan.alansdk.button.SoundManager;
import com.alan.alansdk.button.WakeLockManager;
import com.alan.alansdk.button.animations.BackgroundAnimation;
import com.alan.alansdk.button.animations.ButtonColorAnimation;
import com.alan.alansdk.button.animations.InnerBgListenAnimation;
import com.alan.alansdk.button.animations.LogoAnimation;
import com.alan.alansdk.button.animations.OnAnimationEnd;
import com.alan.alansdk.button.animations.SpeakingBackAnimation;

public class StateHandler {
    private WakeLockManager wakeLockManager;
    private AlanState currentState;
    private SoundManager soundManager;
    private ViewGroup buttonContainer;
    private View shadow;
    private GradientButton backgroundView;
    private View innerBgTriangle;
    private ImageView innerBgCircle;
    private ImageView logoView1;
    private ImageView logoView2;
    private View logoContainer;
    private ColorManager colorManager;
    private LogoAnimation logoAnimation;
    private BackgroundAnimation backgroundAnimation;
    private SpeakingBackAnimation triangleAnimation;
    private SpeakingBackAnimation circleAnimation;
    private InnerBgListenAnimation innerBgListenAnimation;
    private ButtonColorAnimation buttonColorAnimation;

    public StateHandler(Context context, AlanButton buttonView, ColorManager colorManager) {
        this.wakeLockManager = new WakeLockManager(context);
        this.soundManager = new SoundManager(context);
        this.buttonContainer = buttonView;
        this.shadow = this.buttonContainer.findViewById(R.id.shadow);
        this.backgroundView = (GradientButton)this.buttonContainer.findViewById(R.id.button_background);
        this.logoView1 = (ImageView)this.buttonContainer.findViewById(R.id.logo_1);
        this.logoView2 = (ImageView)this.buttonContainer.findViewById(R.id.logo_2);
        this.innerBgTriangle = this.buttonContainer.findViewById(R.id.inner_bg_triangle);
        this.innerBgCircle = (ImageView)this.buttonContainer.findViewById(R.id.inner_bg_circle);
        this.buttonContainer = (ViewGroup)this.buttonContainer.findViewById(R.id.button_container);
        this.logoAnimation = new LogoAnimation(this.logoView1, this.logoView2);
        this.backgroundAnimation = new BackgroundAnimation(this.backgroundView);
        this.triangleAnimation = new SpeakingBackAnimation(this.innerBgTriangle, SpeakingBackAnimation.STATE.SPEAKING_BACK);
        this.circleAnimation = new SpeakingBackAnimation((View)this.innerBgCircle, SpeakingBackAnimation.STATE.IDLE);
        this.innerBgListenAnimation = new InnerBgListenAnimation(this.innerBgTriangle);
        this.buttonColorAnimation = new ButtonColorAnimation(this.backgroundView);
        this.colorManager = colorManager;
    }

    public void setState(AlanState alanState) {
        if (this.currentState == AlanState.REPLY && alanState == AlanState.LISTEN) {
            Alan.getInstance(this.backgroundView.getContext()).skipMillis(430);
            this.soundManager.playNext();
        }
        if (this.currentState == AlanState.LISTEN && alanState == AlanState.ONLINE) {
            this.soundManager.playOff();
        }
        if (this.currentState == AlanState.ONLINE && alanState == AlanState.LISTEN) {
            Alan.getInstance(this.backgroundView.getContext()).skipMillis(430);
            this.soundManager.playOn();
        }
        this.currentState = alanState;
        switch (alanState) {
            case ONLINE: {
                this.setIdleState();
                break;
            }
            case OFFLINE: 
            case CONNECTING: {
                this.setDisconnectedState();
                break;
            }
            case LISTEN: {
                this.setListenState();
                break;
            }
            case PROCESS: {
                this.setUnderstoodState();
                break;
            }
            case REPLY: {
                this.setSpeakBackState();
                break;
            }
        }
    }

    void setDisconnectedState() {
        this.buttonColorAnimation.start(this.colorManager.getDisconnectedColor(), new OnAnimationEnd(){

            @Override
            public void onAnimationEnd() {
            }
        });
        this.innerBgTriangle.setVisibility(8);
        this.logoAnimation.stopAnimation();
        this.backgroundAnimation.stopAnimation();
        this.triangleAnimation.stopAnimation();
        this.circleAnimation.stopAnimation();
        this.innerBgListenAnimation.stopAnimation();
        this.logoView1.setImageDrawable(this.buttonContainer.getContext().getResources().getDrawable(R.drawable.button_no_network));
        this.logoView1.setAlpha(1.0f);
        this.logoView2.setAlpha(0.0f);
        this.wakeLockManager.releaseWakeLock();
    }

    void setIdleState() {
        this.buttonColorAnimation.start(this.colorManager.getIdleColor(), new OnAnimationEnd(){

            @Override
            public void onAnimationEnd() {
            }
        });
        this.innerBgTriangle.setVisibility(8);
        this.logoAnimation.stopAnimation();
        this.backgroundAnimation.startNormalAnimation();
        this.triangleAnimation.startRespondingAnimation();
        this.circleAnimation.startSpeakingBackAnimation();
        this.innerBgListenAnimation.stopAnimation();
        this.logoView1.setImageDrawable(this.buttonContainer.getContext().getResources().getDrawable(R.drawable.button_logo_state_01));
        this.logoView1.setAlpha(1.0f);
        this.logoView2.setAlpha(0.0f);
        this.wakeLockManager.releaseWakeLock();
    }

    private void setListenState() {
        this.wakeLockManager.acquireWakeLock();
        this.buttonColorAnimation.start(this.colorManager.getListenColor(), new OnAnimationEnd(){

            @Override
            public void onAnimationEnd() {
            }
        });
        this.innerBgTriangle.setVisibility(0);
        this.logoAnimation.startAnimation();
        this.backgroundAnimation.startRespondingAnimation();
        this.triangleAnimation.startRespondingAnimation();
        this.circleAnimation.startSpeakingBackAnimation();
        this.innerBgListenAnimation.startAnimation();
    }

    private void setUnderstoodState() {
        this.buttonColorAnimation.start(this.colorManager.getProcessColor(), new OnAnimationEnd(){

            @Override
            public void onAnimationEnd() {
            }
        });
        this.innerBgTriangle.setVisibility(0);
    }

    private void setSpeakBackState() {
        this.buttonColorAnimation.start(this.colorManager.getReplyColor(), new OnAnimationEnd(){

            @Override
            public void onAnimationEnd() {
            }
        });
        this.innerBgTriangle.setVisibility(0);
        this.backgroundAnimation.startNormalAnimation();
        this.triangleAnimation.startSpeakingBackAnimation();
        this.circleAnimation.startRespondingAnimation();
        this.innerBgListenAnimation.stopAnimation();
    }

    void setTouchedState() {
        if (this.currentState != AlanState.ONLINE) {
            this.innerBgTriangle.setVisibility(8);
        }
        this.logoView1.setScaleX(0.9f);
        this.logoView1.setScaleY(0.9f);
        this.logoView2.setScaleX(0.9f);
        this.logoView2.setScaleY(0.9f);
        this.shadow.setVisibility(8);
        this.backgroundView.setScaleX(0.9f);
        this.backgroundView.setScaleY(0.9f);
    }

    void setUntouchedState() {
        if (this.currentState != AlanState.ONLINE) {
            this.innerBgTriangle.setVisibility(0);
        }
        this.logoView1.setScaleX(1.0f);
        this.logoView1.setScaleY(1.0f);
        this.logoView2.setScaleX(1.0f);
        this.logoView2.setScaleY(1.0f);
        this.shadow.setVisibility(0);
        this.backgroundView.setScaleX(1.0f);
        this.backgroundView.setScaleY(1.0f);
    }

    public AlanState getState() {
        return this.currentState;
    }
}

