/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alan.alansdk.R;

public class GradientButton
extends View {
    private Paint gradientPaint;
    private Paint basePaint = new Paint();
    private Bitmap blurBitmap;
    private Paint blurPaint = new Paint();
    private Rect blurRect;
    private Rect blurDstRect;
    private boolean isInited = false;
    private int color1 = Color.parseColor((String)"#807D7D8F");
    private int color2 = Color.parseColor((String)"#80B8B8CF");

    public GradientButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    private void init(int color1, int color2) {
        this.gradientPaint = new Paint();
        this.gradientPaint.setAntiAlias(true);
        this.gradientPaint.setDither(false);
        this.gradientPaint.setAlpha(200);
        this.blurBitmap = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.button_blur);
        this.blurRect = new Rect(0, 0, this.blurBitmap.getWidth(), this.blurBitmap.getHeight());
        this.blurDstRect = new Rect(0, 0, this.getWidth(), this.getWidth());
        this.blurPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.OVERLAY));
        this.setColors(color1, color2);
        this.isInited = true;
    }

    public void setColors(int color1, int color2) {
        this.color1 = color1;
        this.color2 = color2;
        if (this.isInited) {
            LinearGradient gradient = new LinearGradient(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), color1, color2, Shader.TileMode.CLAMP);
            this.gradientPaint.setShader((Shader)gradient);
            this.blurPaint.setShader((Shader)gradient);
        }
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isInited) {
            this.init(this.color1, this.color2);
            return;
        }
        canvas.drawBitmap(this.blurBitmap, this.blurRect, this.blurDstRect, this.basePaint);
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.getWidth() / 2.0f, this.blurPaint);
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.getWidth() / 2.0f, this.gradientPaint);
    }
}

