/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import com.alan.alansdk.AlanCallback;
import com.alan.alansdk.AlanState;
import com.alan.alansdk.R;
import com.alan.alansdk.button.AlanButton;
import com.alan.alansdk.button.ColorManager;
import com.alan.alansdk.button.HintHiderTask;
import com.alan.alansdk.events.EventOptions;
import com.alan.alansdk.events.EventParsed;
import com.alan.alansdk.events.EventRecognised;

public class AlanStateListener
extends AlanCallback {
    private AlanButton button;
    private ColorManager colorManager;
    private HintHiderTask hintHiderTask;

    AlanStateListener(AlanButton button, ColorManager colorManager) {
        this.button = button;
        this.colorManager = colorManager;
        this.hintHiderTask = new HintHiderTask(button);
        this.hintHiderTask.start();
    }

    @Override
    public void onAlanStateChanged(@NonNull AlanState alanState) {
        super.onAlanStateChanged(alanState);
        this.button.setState(alanState);
    }

    @Override
    public void onOptionsReceived(EventOptions eventOptions) {
        super.onOptionsReceived(eventOptions);
        if (eventOptions.getAndroidSettings() != null) {
            if (eventOptions.getAndroidSettings().isButtonHidden) {
                this.button.disableButton();
            } else {
                this.button.showButton();
                EventOptions.AndroidSettings.ButtonOptions options = eventOptions.getAndroidSettings().buttonOptions;
                if (options != null) {
                    this.colorManager.setIdleColor(options.idleColor.background);
                    this.colorManager.setListenColor(options.listenColor.background);
                    this.colorManager.setProcessColor(options.processColor.background);
                    this.colorManager.setReplyColor(options.replyColor.background);
                }
                this.button.reset();
            }
        }
    }

    private Activity getActivityFromView(View v) {
        Context context = v.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    @Override
    public void onRecognizedEvent(final EventRecognised eventRecognised) {
        super.onRecognizedEvent(eventRecognised);
        if (this.button.hintPanelVisible()) {
            this.button.showHintPanel();
            this.button.activeHintText.setText((CharSequence)eventRecognised.getText());
            this.button.activeHintText.setTextColor(this.getColor(R.color.hint_recognized_text));
            this.button.activeHintText.setTypeface(null, 2);
            this.button.activeHintPanel.invalidate();
            this.hintHiderTask.set();
        }
        if (eventRecognised.isFinal() && eventRecognised.getReqId() != null && !eventRecognised.getReqId().isEmpty()) {
            this.button.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    AlanStateListener.this.button.getSDK().takeScreenshot(AlanStateListener.this.getActivityFromView((View)AlanStateListener.this.button), eventRecognised.getScreenshotUrl());
                }
            }, 100L);
        }
    }

    @Override
    public void onParsedEvent(EventParsed eventParsed) {
        super.onParsedEvent(eventParsed);
        if (this.button.hintPanelVisible()) {
            this.button.showHintPanel();
            this.button.activeHintText.setText((CharSequence)this.generateHintMarkdown(eventParsed));
            this.button.activeHintText.setTextColor(this.getColor(R.color.hint_final_text));
            this.button.activeHintText.setTypeface(null, 0);
            this.button.activeHintPanel.invalidate();
            this.hintHiderTask.set();
        }
    }

    private SpannableString generateHintMarkdown(EventParsed eventParsed) {
        SpannableString spannable = new SpannableString((CharSequence)eventParsed.getText());
        for (int i = 0; i < eventParsed.getEntities().size(); ++i) {
            EventParsed.ParsedEntity entity = eventParsed.getEntities().get(i);
            if (entity.index == -1 || entity.value.isEmpty()) continue;
            int color2 = entity.type.equals("ITEM") ? R.color.hint_entity_item : R.color.hint_entity_word;
            spannable.setSpan((Object)new ForegroundColorSpan(this.getColor(color2)), entity.index, entity.index + entity.value.length(), 34);
        }
        return spannable;
    }

    private int getColor(@ColorRes int colorRes) {
        return this.button.getContext().getResources().getColor(colorRes);
    }
}

