/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.alanbase.recorder;

import android.media.AudioRecord;
import android.os.Process;
import com.alan.alansdk.alanbase.recorder.DriftCompensator;
import com.alan.alansdk.alanbase.recorder.RecordDumpListener;
import com.alan.alansdk.logging.AlanLogger;

public abstract class RecorderThread
extends Thread {
    protected AudioRecord record;
    private DriftCompensator driftCompensator = new DriftCompensator();
    protected final RecordDumpListener callback;
    boolean shouldContinue = false;

    RecorderThread(RecordDumpListener callback) {
        this.callback = callback;
    }

    public void stopRecording() {
        this.shouldContinue = false;
    }

    public void skipSamples(int samples) {
        this.skip(samples);
    }

    public void skipMillis(int millis) {
        this.skip((int)Math.round((double)((float)millis * 44100.0f) / 1000.0));
    }

    @Override
    public void run() {
        super.run();
        Process.setThreadPriority((int)-16);
        if (!this.prepareRecorder()) {
            AlanLogger.e(new IllegalStateException("Failed to prepare recorder"));
            return;
        }
        this.record.startRecording();
        AlanLogger.d("Start recording");
        while (this.shouldContinue) {
            this.prepareFrames();
        }
        this.record.stop();
        this.record.release();
        AlanLogger.d("Recording stopped.");
    }

    private void prepareFrames() {
        this.driftCompensator.prepare();
        int samplesRead = this.readBuffer();
        this.writeFrames();
        this.driftCompensator.compensate(samplesRead);
    }

    protected abstract void skip(int var1);

    protected abstract void writeFrames();

    protected abstract int readBuffer();

    protected abstract boolean prepareRecorder();
}

