/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.alan.alansdk.AlanCallback;
import com.alan.alansdk.AlanConfig;
import com.alan.alansdk.AlanSDK;
import com.alan.alansdk.AlanState;
import com.alan.alansdk.ScriptMethodCallback;
import com.alan.alansdk.Utils;
import com.alan.alansdk.alanbase.ConnectionState;
import com.alan.alansdk.alanbase.DialogState;
import com.alan.alansdk.alanbase.SdkParams;
import com.alan.alansdk.alanbase.recorder.AlanRecorder;
import com.alan.alansdk.alanbase.speaker.AlanSpeaker;
import com.alan.alansdk.events.EventCommand;
import com.alan.alansdk.events.EventDialogId;
import com.alan.alansdk.events.EventOptions;
import com.alan.alansdk.events.EventParsed;
import com.alan.alansdk.events.EventRecognised;
import com.alan.alansdk.events.EventText;
import com.alan.alansdk.logging.AlanLogger;
import com.alan.alansdk.prefs.AlanPrefs;
import com.alan.alansdk.qr.QRScanActivity;
import com.alan.alansdk.screenshot.ScreenShooter;
import com.alan.alansdk.screenshot.ScreenshotAddon;
import com.alan.alansdk.screenshot.UploadThread;
import com.alan.alansdk.wakeword.DownloadListener;
import com.alan.alansdk.wakeword.FileUtils;
import com.alan.alansdk.wakeword.ModelDownloader;
import com.google.gson.Gson;
import java.util.LinkedHashSet;
import java.util.Set;

public class Alan
implements AlanSDK {
    public static String PLATFORM_SUFFIX;
    public static String PLATFORM_VERSION_SUFFIX;
    public static boolean QR_EVENT_BUS_ENABLED;
    private static final String STAGE_ENDPOINT = "wss://studio.alan-stage.app";
    private static final String PROD_ENDPOINT = "wss://studio.alan.app";
    private static int REQUEST_CODE_QR;
    private static volatile Alan INSTANCE;
    private AlanSpeaker speaker = new AlanSpeaker();
    private AlanRecorder recorder = new AlanRecorder();
    private boolean isInited = false;
    private final String server = "wss://studio.alan.app";
    private DialogState state = DialogState.IDLE;
    private ConnectionState connectionState = ConnectionState.IDLE;
    private static String modelPath;
    private boolean isWakeWordEnabled = false;
    ScreenShooter screenShooter = new ScreenShooter();
    private static Set<AlanCallback> callbacks;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private AlanPrefs prefs;
    private static String lastUsedServer;
    private static String lastUsedProject;
    private static String lastUsedDialog;
    private static String lastUsedAuth;
    private Context context;
    public AlanState alanState;

    private Alan(Context context) {
        this.context = context;
        AlanLogger.init(context);
        this.prefs = new AlanPrefs(context);
        modelPath = this.prefs.getWakeWordModelUrl();
        if (modelPath == null || modelPath.isEmpty()) {
            modelPath = FileUtils.copyTfModel(context);
            this.prefs.setWakeWordModelUrl(modelPath);
        }
        this.isWakeWordEnabled = this.prefs.isWakeWordEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Alan getInstance(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<Alan> clazz = Alan.class;
        synchronized (Alan.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new Alan(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static synchronized void reCreate(Context context) {
        INSTANCE = new Alan(context);
    }

    public void stop() {
        AlanLogger.i("Stopping Alan");
        this.speaker.release();
        this.deactivate();
        this.stopRecording();
        this.stopNative();
    }

    @Deprecated
    public void record() {
        this.recorder.startRecording();
    }

    @Deprecated
    private void stopRecording() {
        this.recorder.stopRecording();
    }

    @Deprecated
    public void speak() {
        this.speaker.startPlaying();
    }

    private void stopPlaying() {
        this.speaker.stopPlaying();
    }

    private void handleOptions(EventOptions options) {
        String localModelName;
        boolean needRestart = false;
        this.prefs.setKeepMicrophoneInBackground(options.getAndroidSettings().keepMicrophoneInBackground);
        if (options.getAndroidSettings().isButtonHidden) {
            this.stopRecording();
            return;
        }
        if (this.prefs.isWakeWordEnabled() != options.getAndroidSettings().isWakeWordEnabled().booleanValue()) {
            this.prefs.setWakeWordState(options.getAndroidSettings().isWakeWordEnabled());
            this.isWakeWordEnabled = options.getAndroidSettings().isWakeWordEnabled();
            needRestart = true;
        }
        if (!this.prefs.getTimeout().equals(options.getAndroidSettings().getTimeout())) {
            this.prefs.setTimeout(options.getAndroidSettings().getTimeout());
            needRestart = true;
        }
        if (this.prefs.hideS2TPanel() != options.getAndroidSettings().shouldHideS2TPanel()) {
            this.prefs.setHideS2TPanel(options.getAndroidSettings().shouldHideS2TPanel());
            needRestart = true;
        }
        if (this.prefs.isScreenshotsEnabled() != options.getAndroidSettings().isScreenShotsEnabled()) {
            this.prefs.setScreenshotsEnabled(options.getAndroidSettings().isScreenShotsEnabled());
            needRestart = true;
        }
        if (!(localModelName = Utils.extractFileNameFromUrl(this.prefs.getWakeWordModelUrl())).equalsIgnoreCase(options.getWakeWordModelName())) {
            new ModelDownloader().download(this.context, new DownloadListener(){

                @Override
                public void onDownloaded(String url) {
                    Alan.this.prefs.setWakeWordModelUrl(url);
                    modelPath = Utils.getWakeWordModelFile(Alan.this.context, Utils.extractFileNameFromUrl(url)).getAbsolutePath();
                    Alan.this.restart();
                }

                @Override
                public void onDownloadFailed() {
                    AlanLogger.e("Failed to download new model");
                }
            }, options.wakeWordPath);
        }
        if (needRestart) {
            AlanLogger.i("Options changed -- need restart");
            this.restart();
        }
    }

    private void handleRecognizedEvent(EventRecognised event) {
    }

    public void takeScreenshot(@Nullable Activity activity, String screenShotUrl) {
        if (this.prefs.isScreenshotsEnabled()) {
            AlanLogger.i("Taking screenshot");
            String image = this.screenShooter.shot(activity, screenShotUrl);
            if (image != null) {
                AlanLogger.i("Saved new screenshot: " + image);
            } else {
                AlanLogger.e("Cannot take screenshot");
            }
        } else {
            AlanLogger.w("Screenshots are disabled!");
        }
    }

    public boolean hideHintPanel() {
        return this.prefs.hideS2TPanel();
    }

    private void handleConnectionState(ConnectionState connectionState) {
        if (connectionState == ConnectionState.CONNECTED && this.isWakeWordEnabled) {
            this.record();
            this.speak();
        }
    }

    private void handleDialogState(DialogState dialogState) {
        if (dialogState == DialogState.IDLE && this.isWakeWordEnabled) {
            this.record();
        }
    }

    private void uploadPendingScreenshots() {
        UploadThread uploader = new UploadThread(this.context, lastUsedServer);
        uploader.start();
    }

    public boolean restart() {
        return this.initWithConfig(null);
    }

    @Keep
    private void onConnectStateChanged(int connectState) {
        ConnectionState newState;
        this.connectionState = newState = ConnectionState.fromInt(connectState);
        AlanLogger.i("SDK object is: " + this.toString());
        AlanLogger.i("Connection state: " + newState.name());
        this.handleConnectionState(newState);
        switch (newState) {
            case CONNECTING: 
            case AUTHORIZING: {
                this.alanState = AlanState.CONNECTING;
                break;
            }
            case CONNECTED: {
                this.alanState = AlanState.ONLINE;
                break;
            }
            case IDLE: {
                break;
            }
            case CLOSED: {
                this.alanState = AlanState.OFFLINE;
            }
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                for (AlanCallback callback : callbacks) {
                    callback.onAlanStateChanged(Alan.this.alanState);
                }
            }
        });
    }

    @Keep
    private void onDialogStateChanged(int dialogState) {
        DialogState newState = DialogState.fromInt(dialogState);
        if (newState == DialogState.IDLE && newState != this.state) {
            this.uploadPendingScreenshots();
        }
        this.state = newState;
        AlanLogger.i("DialogState: " + newState.name());
        switch (newState) {
            case IDLE: {
                this.alanState = AlanState.ONLINE;
                break;
            }
            case LISTEN: {
                this.record();
                this.alanState = AlanState.LISTEN;
                break;
            }
            case PROCESS: {
                this.speak();
                this.alanState = AlanState.PROCESS;
                break;
            }
            case REPLY: {
                this.alanState = AlanState.REPLY;
            }
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                for (AlanCallback callback : callbacks) {
                    callback.onAlanStateChanged(Alan.this.alanState);
                }
            }
        });
    }

    @Keep
    private void onEvent(final String event, final String payload) {
        AlanLogger.event("New event: \"" + event + "\", with payload: " + payload);
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                switch (event) {
                    case "recognized": {
                        EventRecognised eventRecognised = EventRecognised.fromJson(payload);
                        Alan.this.handleRecognizedEvent(eventRecognised);
                        for (AlanCallback callback : callbacks) {
                            callback.onRecognizedEvent(EventRecognised.fromJson(payload));
                        }
                        break;
                    }
                    case "text": {
                        for (AlanCallback callback : callbacks) {
                            callback.onTextEvent(EventText.fromJson(payload));
                        }
                        break;
                    }
                    case "options": {
                        EventOptions eventOptions = EventOptions.fromJson(payload);
                        Alan.this.handleOptions(eventOptions);
                        for (AlanCallback callback : callbacks) {
                            try {
                                callback.onOptionsReceived(eventOptions);
                            }
                            catch (Exception e) {
                                AlanLogger.e(e);
                            }
                        }
                        break;
                    }
                    case "command": {
                        for (AlanCallback callback : callbacks) {
                            callback.onCommandReceived(EventCommand.fromPayload(payload));
                        }
                        break;
                    }
                    case "parsed": {
                        for (AlanCallback callback : callbacks) {
                            callback.onParsedEvent(EventParsed.fromJson(payload));
                        }
                        break;
                    }
                    case "dialogId": {
                        EventDialogId eventDialogId = EventDialogId.fromJson(payload);
                        lastUsedDialog = eventDialogId.getDialogId();
                        break;
                    }
                    default: {
                        for (AlanCallback callback : callbacks) {
                            callback.onEvent(event, payload);
                        }
                    }
                }
            }
        });
    }

    @Keep
    private void onError(final String error) {
        AlanLogger.e("Native error: " + error);
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                for (AlanCallback callback : callbacks) {
                    callback.onError(error);
                }
            }
        });
    }

    @Deprecated
    public boolean init(@Nullable String server, String projectId, String dialogId, String authParams) {
        AlanConfig config = AlanConfig.builder().setServer(server).setProjectId(projectId).setDialogId(dialogId).setDataObject(authParams).build();
        return this.initWithConfig(config);
    }

    @Deprecated
    public boolean init(@Nullable String server, String projectId, String dialogId) {
        return this.init(this.server, projectId, dialogId, null);
    }

    @Deprecated
    public boolean init(String projectId, String dialogId) {
        return this.init(PROD_ENDPOINT, projectId, dialogId, null);
    }

    @Deprecated
    public boolean init(String projectId) {
        return this.init(PROD_ENDPOINT, projectId, null, null);
    }

    public boolean initWithConfig(@Nullable AlanConfig config) {
        this.stop();
        if (config != null) {
            lastUsedServer = config.getServer();
            lastUsedProject = config.getProjectId();
            lastUsedDialog = config.getDialogId();
            lastUsedAuth = config.getDataObject();
        }
        AlanLogger.i("Connecting to the " + lastUsedServer + ", with projectId: " + lastUsedProject + ", dialogId: " + lastUsedDialog + "\nAuthJson: " + lastUsedAuth);
        if (lastUsedProject == null) {
            AlanLogger.e("Project id is null! Aborting connection");
            this.isInited = false;
            return this.isInited;
        }
        String model = this.isWakeWordEnabled ? modelPath : null;
        AlanLogger.d("WakeWord is " + (model == null ? "disabled" : "enabled"));
        String sdkVersion = "4.7.11";
        if (PLATFORM_VERSION_SUFFIX != null && !PLATFORM_VERSION_SUFFIX.isEmpty()) {
            sdkVersion = sdkVersion + ":" + PLATFORM_VERSION_SUFFIX;
        }
        String platform = "android";
        if (PLATFORM_SUFFIX != null && !PLATFORM_SUFFIX.isEmpty()) {
            platform = platform + ":" + PLATFORM_SUFFIX;
        }
        this.isInited = this.initNative(lastUsedServer, lastUsedProject, lastUsedDialog, lastUsedAuth, model, this.prefs.getUUID(), sdkVersion, platform);
        return this.isInited;
    }

    public static void enableLogging(boolean shouldLog) {
        AlanLogger.SHOULD_LOG = shouldLog;
    }

    @Override
    public void setVisualState(String visualState) {
        if (!this.isInited()) {
            throw new IllegalStateException("Init Alan first!");
        }
        this.setParamsNative(visualState);
    }

    @Deprecated
    public void setVisuals(String visuals) {
        this.setVisualState(visuals);
    }

    public boolean isInited() {
        return this.isInited;
    }

    public String getVersion() {
        String sdkVersion = "SDK version: 4.7.11";
        String coreVersion = "AlanBase: " + this.getVersionNative();
        String wakeWordName = "WakeWord model: " + Utils.extractFileNameFromUrl(this.prefs.getWakeWordModelUrl());
        return sdkVersion + "\n" + coreVersion + "\n" + wakeWordName;
    }

    @Override
    public void activate() {
        if (!this.isInited()) {
            throw new IllegalStateException("Init Alan first!");
        }
        this.turn(true);
        this.record();
        this.speak();
    }

    @Deprecated
    public void turnOn() {
        this.activate();
    }

    @Override
    public void deactivate() {
        if (!this.isInited()) {
            AlanLogger.w("Performing stop when sdk is not inited yet");
            return;
        }
        if (!this.isWakeWordEnabled) {
            this.stopRecording();
        }
        this.stopPlaying();
        this.turn(false);
    }

    @Override
    public boolean isActive() {
        return this.alanState == AlanState.LISTEN || this.alanState == AlanState.PROCESS || this.alanState == AlanState.REPLY;
    }

    @Deprecated
    public void turnOff() {
        this.deactivate();
    }

    public void toggle() {
        if (!this.isInited()) {
            AlanLogger.i("Alan is not inited!");
        }
        if (this.connectionState != ConnectionState.CONNECTED) {
            AlanLogger.i("Alan is not connected to backend");
            return;
        }
        if (this.state != DialogState.IDLE) {
            this.deactivate();
        } else {
            this.activate();
        }
    }

    public void registerCallback(AlanCallback callback) {
        callbacks.add(callback);
    }

    public void unregisterCallback(AlanCallback callback) {
        callbacks.remove(callback);
    }

    public void clearCallbacks() {
        callbacks.clear();
    }

    public DialogState getDialogState() {
        return this.state;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void playText(String text) {
        this.callProjectApiInternal("play", "{\"text\":\"" + text + "\"}", null, false);
    }

    @Override
    public void playText(String text, @Nullable ScriptMethodCallback callback) {
        this.callProjectApiInternal("play", "{\"text\":\"" + text + "\"}", callback, false);
    }

    @Override
    public void playCommand(String data, @Nullable ScriptMethodCallback callback) {
        this.callProjectApiInternal("play", "{\"data\":{\"data\":" + data + "}}", callback, false);
    }

    @Deprecated
    public void playData(String data, @Nullable ScriptMethodCallback callback) {
        this.callProjectApiInternal("play", "{\"data\":" + data + "}", callback, false);
    }

    @Override
    public void callProjectApi(String method, String jsonParams) {
        this.callProjectApi(method, jsonParams, null);
    }

    @Override
    public void callProjectApi(String method, String jsonParams, @Nullable ScriptMethodCallback callback) {
        if (method.startsWith("script::")) {
            this.callProjectApiInternal(method, jsonParams, callback, false);
        } else {
            this.callProjectApiInternal("script::" + method, jsonParams, callback, false);
        }
    }

    private void callProjectApiInternal(final String method, String jsonParams, final @Nullable ScriptMethodCallback callback, boolean shouldActivate) {
        if (!this.isInited()) {
            throw new IllegalStateException("Init Alan first!");
        }
        String params = jsonParams;
        if (params == null || params.isEmpty()) {
            params = "{}";
        }
        if (shouldActivate) {
            this.activate();
        }
        final String finalParams = params;
        this.mainHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Alan.this.callScript(method, finalParams, callback);
            }
        }, 300L);
    }

    @Deprecated
    public void call(String method, String jsonParams) {
        this.callProjectApi(method, jsonParams, null);
    }

    @Deprecated
    public void call(String method, String jsonParams, @Nullable ScriptMethodCallback callback) {
        this.callProjectApi(method, jsonParams, callback);
    }

    public static void openQRScanner(Activity activity) {
        activity.startActivityForResult(new Intent((Context)activity, QRScanActivity.class), REQUEST_CODE_QR);
    }

    @Nullable
    public static SdkParams handleActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != REQUEST_CODE_QR) {
            return null;
        }
        if (resultCode == -1 && data != null) {
            String barcode = data.getStringExtra("BARCODE");
            return Alan.extractParamsFromBarcode(barcode);
        }
        return null;
    }

    @Nullable
    public static SdkParams extractParamsFromBarcode(String barcode) {
        AlanLogger.i("Got barcode: " + barcode);
        if (barcode.startsWith("https://")) {
            SdkParams barcodeParams = new SdkParams();
            if (barcode.contains("studio.alan-stage.app")) {
                barcodeParams.server = STAGE_ENDPOINT;
                barcodeParams.projectId = barcode.substring(30);
            } else {
                barcodeParams.server = PROD_ENDPOINT;
                barcodeParams.projectId = barcode.substring(24);
            }
            return barcodeParams;
        }
        try {
            Gson gson = new Gson();
            return (SdkParams)gson.fromJson(barcode, SdkParams.class);
        }
        catch (Exception e) {
            AlanLogger.e("Failed to parse barcode");
            return null;
        }
    }

    public void skipMillis(int millis) {
        this.recorder.skipMillis(millis);
    }

    public void setScreenshotAddon(@Nullable ScreenshotAddon screenshotAddon) {
        if (this.screenShooter != null) {
            this.screenShooter.setAddon(screenshotAddon);
        }
    }

    public void onBackground() {
        if (!this.prefs.keepMicrophoneInBackground()) {
            this.deactivate();
            this.stopRecording();
        }
    }

    public void onForeground() {
        if (this.isWakeWordEnabled) {
            this.record();
        }
    }

    private native boolean callScript(String var1, String var2, ScriptMethodCallback var3);

    private native boolean setParamsNative(String var1);

    private native boolean initNative(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    private native void resetNative();

    private native String getVersionNative();

    private native void turn(boolean var1);

    private native void stopNative();

    static {
        System.loadLibrary("native-lib");
        PLATFORM_SUFFIX = "";
        PLATFORM_VERSION_SUFFIX = "";
        QR_EVENT_BUS_ENABLED = false;
        REQUEST_CODE_QR = 65056;
        callbacks = new LinkedHashSet<AlanCallback>();
    }
}

