/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.wakeword;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Environment;
import com.alan.alansdk.Utils;
import com.alan.alansdk.logging.AlanLogger;
import com.alan.alansdk.wakeword.DownloadListener;
import java.io.File;

public class ModelDownloader {
    private DownloadListener callback;
    private String url;
    private BroadcastReceiver onComplete = new BroadcastReceiver(){

        public void onReceive(Context ctxt, Intent intent) {
            if (ModelDownloader.this.callback != null) {
                ModelDownloader.this.callback.onDownloaded(ModelDownloader.this.url);
            }
        }
    };
    private BroadcastReceiver onNotificationClick = new BroadcastReceiver(){

        public void onReceive(Context ctxt, Intent intent) {
        }
    };

    public void download(Context context, DownloadListener downloadListener, String path) {
        this.callback = downloadListener;
        this.url = path;
        DownloadManager mgr = (DownloadManager)context.getSystemService("download");
        if (mgr == null) {
            if (this.callback != null) {
                this.callback.onDownloadFailed();
            }
            return;
        }
        context.registerReceiver(this.onComplete, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
        context.registerReceiver(this.onNotificationClick, new IntentFilter("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED"));
        this.startDownload(context, mgr, path);
    }

    private void startDownload(Context context, DownloadManager mgr, String modelPath) {
        try {
            Uri uri = Uri.parse((String)modelPath);
            String modelName = Utils.extractFileNameFromUrl(modelPath);
            File localPath = Utils.getWakeWordModelFile(context, modelName);
            long l = mgr.enqueue(new DownloadManager.Request(uri).setAllowedNetworkTypes(3).setAllowedOverRoaming(false).setTitle((CharSequence)"Updating").setDescription((CharSequence)"").setDestinationInExternalFilesDir(context, Environment.DIRECTORY_DOWNLOADS, "wakeword/" + modelName));
        }
        catch (Exception e) {
            AlanLogger.e("Failed to download model: " + modelPath);
        }
    }
}

