/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.screenshot;

import android.content.Context;
import com.alan.alansdk.logging.AlanLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UploadThread
extends Thread {
    private final Context context;
    private final String server;
    private File rootDir;
    private final OkHttpClient client = new OkHttpClient();
    private final MediaType MEDIA_TYPE_MARKDOWN = MediaType.parse((String)"text/plain;");

    public UploadThread(Context context, String server) {
        this.server = server.replaceFirst("wss", "https");
        this.context = context;
    }

    @Override
    public void run() {
        super.run();
        AlanLogger.i("Starting pending screenshot upload");
        this.rootDir = new File(this.context.getFilesDir(), "screenshots");
        List<String> screenshots = this.collectScreenshots();
        for (String screenshotName : screenshots) {
            this.uploadScreenshot(screenshotName);
        }
    }

    private List<String> collectScreenshots() {
        if (this.rootDir == null) {
            AlanLogger.e("Cannot open screenshots folder");
            return new LinkedList<String>();
        }
        String[] fileList = this.rootDir.list();
        if (fileList == null) {
            AlanLogger.i("Screenshot folder is empty");
            return new LinkedList<String>();
        }
        AlanLogger.i("Got " + fileList.length + " pending screenshots");
        return Arrays.asList(fileList);
    }

    private File getScreenshotByName(String name) {
        File screenshot = new File(this.rootDir, name);
        while (screenshot.isDirectory() && screenshot.list().length > 0) {
            screenshot = new File(screenshot, screenshot.list()[0]);
        }
        return screenshot;
    }

    private void uploadScreenshot(String name) {
        Object out = null;
        File screenshot = this.getScreenshotByName(name);
        String screenshotName = screenshot.getAbsolutePath().substring(screenshot.getAbsolutePath().indexOf("media-asset/"));
        String urlString = this.server + "/upload-media/" + screenshotName;
        AlanLogger.i("Uploading to: " + this.server + '/' + screenshotName);
        boolean result = this.upload(screenshot, urlString);
        if (result) {
            AlanLogger.i("Uploaded successfully");
            this.deleteDirectory(name);
        } else {
            AlanLogger.i("Upload failed");
        }
    }

    private void deleteDirectory(String name) {
        File dir = new File(this.rootDir, name);
        this.deleteRecursive(dir);
    }

    private void deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                this.deleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    private boolean upload(File file, String url) {
        Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)this.MEDIA_TYPE_MARKDOWN, (File)file)).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
        }
        catch (IOException e) {
            AlanLogger.e(e);
        }
        return true;
    }
}

