/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.screenshot;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.Base64;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alan.alansdk.logging.AlanLogger;
import com.alan.alansdk.screenshot.ScreenshotAddon;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ScreenShooter {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    static final String SCREENSHOTS_FOLDER = "screenshots";
    @Nullable
    private ScreenshotAddon addon = null;

    public void setAddon(@Nullable ScreenshotAddon addon) {
        this.addon = addon;
    }

    @Nullable
    public String shot(@Nullable Activity activity, String screenshotName) {
        if (activity == null) {
            return null;
        }
        Bitmap additional = null;
        if (this.addon != null) {
            additional = this.addon.getAdditionalBitmap();
        }
        Bitmap screen = this.getScreenBitmap(activity);
        Bitmap composed = Bitmap.createBitmap((int)screen.getWidth(), (int)screen.getHeight(), (Bitmap.Config)screen.getConfig());
        if (additional != null) {
            Canvas canvas = new Canvas(composed);
            canvas.drawBitmap(additional, 0.0f, 0.0f, null);
            screen.eraseColor(-16777216);
            canvas.drawBitmap(screen, 0.0f, 0.0f, null);
            screen = composed;
        }
        ByteArrayOutputStream byteStream = this.compressToJpeg(screen);
        String currentTime = sdf.format(Calendar.getInstance().getTime());
        String filename = currentTime + screenshotName;
        this.dumpToFile((Context)activity, byteStream, filename);
        return filename;
    }

    private Bitmap getScreenBitmap(@NonNull Activity activity) {
        View rootView = activity.getWindow().getDecorView().findViewById(0x1020002);
        View screenView = rootView.getRootView();
        screenView.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)screenView.getDrawingCache());
        screenView.setDrawingCacheEnabled(false);
        return bitmap;
    }

    private ByteArrayOutputStream compressToJpeg(Bitmap bitmap) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)os);
        return os;
    }

    private void dumpToFile(Context context, ByteArrayOutputStream byteArrayOutputStream, String fileName) {
        File screenshot;
        File folder = new File(context.getFilesDir(), SCREENSHOTS_FOLDER);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(screenshot = new File(folder, fileName)).getParentFile().exists()) {
            screenshot.getParentFile().mkdirs();
        }
        try {
            screenshot.createNewFile();
        }
        catch (IOException e) {
            AlanLogger.e("Cannot create file: " + screenshot);
            AlanLogger.e(e);
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(screenshot);){
            byteArrayOutputStream.writeTo(outputStream);
        }
        catch (FileNotFoundException exception) {
            AlanLogger.e(exception);
        }
        catch (IOException ioException) {
            AlanLogger.e(ioException);
        }
    }

    private String base64Encode(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)0);
    }
}

