/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.prefs;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.UUID;

public class AlanPrefs {
    public static final String DEF_WAKEWORD_NAME = "model_20191008.tflite";
    private SharedPreferences prefs;
    private static final String PREF_UUID = "uuid";
    private static final String PREF_WAKE_WORD_ENABLED = "wake_word";
    private static final String PREF_TIMEOUT = "timeout";
    private static final String PREF_WAKE_WORD_MODEL_URL = "wake_word_model_url";
    private static final String PREF_HIDE_S2T_PANEL = "hide_s2t_panel";
    private static final String PREF_SCREENSHOTS_ENABLED = "screenshots_enabled";
    private static final String PREF_KEEP_MICROPHONE_IN_BACKGROUND = "keep_microphone_in_background";
    public static final Boolean DEFAULT_WAKEWORD_STATE = false;
    public static final Long DEFAULT_TIMEOUT = 30000L;

    public AlanPrefs(Context context) {
        this.prefs = context.getSharedPreferences("AlanPrefs", 0);
    }

    public void setWakeWordState(boolean enabled) {
        this.prefs.edit().putBoolean(PREF_WAKE_WORD_ENABLED, enabled).apply();
    }

    public boolean isWakeWordEnabled() {
        return this.prefs.getBoolean(PREF_WAKE_WORD_ENABLED, DEFAULT_WAKEWORD_STATE.booleanValue());
    }

    public void setHideS2TPanel(boolean hide) {
        this.prefs.edit().putBoolean(PREF_HIDE_S2T_PANEL, hide).apply();
    }

    public boolean hideS2TPanel() {
        return this.prefs.getBoolean(PREF_HIDE_S2T_PANEL, false);
    }

    public void setScreenshotsEnabled(boolean screenshotsEnabled) {
        this.prefs.edit().putBoolean(PREF_SCREENSHOTS_ENABLED, screenshotsEnabled).apply();
    }

    public boolean isScreenshotsEnabled() {
        return this.prefs.getBoolean(PREF_SCREENSHOTS_ENABLED, false);
    }

    public void setKeepMicrophoneInBackground(boolean keepMicrophoneInBackground) {
        this.prefs.edit().putBoolean(PREF_KEEP_MICROPHONE_IN_BACKGROUND, keepMicrophoneInBackground).apply();
    }

    public boolean keepMicrophoneInBackground() {
        return this.prefs.getBoolean(PREF_KEEP_MICROPHONE_IN_BACKGROUND, true);
    }

    public void setTimeout(long timeout) {
        this.prefs.edit().putLong(PREF_TIMEOUT, timeout).apply();
    }

    public Long getTimeout() {
        return this.prefs.getLong(PREF_TIMEOUT, DEFAULT_TIMEOUT.longValue());
    }

    public void setWakeWordModelUrl(String url) {
        this.prefs.edit().putString(PREF_WAKE_WORD_MODEL_URL, url).apply();
    }

    public String getWakeWordModelUrl() {
        return this.prefs.getString(PREF_WAKE_WORD_MODEL_URL, "");
    }

    public String getUUID() {
        String uuidPref = this.prefs.getString(PREF_UUID, "");
        if (uuidPref.isEmpty()) {
            uuidPref = UUID.randomUUID().toString();
            this.prefs.edit().putString(PREF_UUID, uuidPref).apply();
        }
        return uuidPref;
    }
}

