/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import com.alan.alansdk.R;
import com.alan.alansdk.button.animations.AnimationConfig;
import com.alan.alansdk.button.animations.BaseAnimation;
import com.alan.alansdk.button.animations.LogoStateAnimationListener;

public class LogoAnimation
extends BaseAnimation {
    private Integer[] logoStates = new Integer[]{R.drawable.button_logo_state_01, R.drawable.button_logo_state_02, R.drawable.button_logo_state_03, R.drawable.button_logo_state_04, R.drawable.button_logo_state_05, R.drawable.button_logo_state_06, R.drawable.button_logo_state_07, R.drawable.button_logo_state_08, R.drawable.button_logo_state_09, R.drawable.button_logo_state_10};
    private ImageView logoView1;
    private ImageView logoView2;

    public LogoAnimation(ImageView logo1, ImageView logo2) {
        this.logoView1 = logo1;
        this.logoView2 = logo2;
    }

    private AnimatorSet getLogoAnimationSet() {
        ObjectAnimator animationX1 = this.getLogoAnimation(this.logoView1, "scaleX");
        ObjectAnimator animationY1 = this.getLogoAnimation(this.logoView1, "scaleY");
        ObjectAnimator animationX2 = this.getLogoAnimation(this.logoView2, "scaleX");
        ObjectAnimator animationY2 = this.getLogoAnimation(this.logoView2, "scaleY");
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(new Animator[]{animationX1, animationX2, animationY1, animationY2});
        return animation;
    }

    private ObjectAnimator getLogoAnimation(ImageView img, String property) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)img, (String)property, (float[])new float[]{1.0f, 0.9f});
        animation.setDuration((long)AnimationConfig.LOGO_SCALE_TIME);
        animation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(-1);
        animation.setRepeatMode(2);
        return animation;
    }

    private ObjectAnimator getLogoStateAnimation(ImageView logoView, int index) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)logoView, (String)"alpha", (float[])new float[]{index == 0 ? 1.0f : 0.0f, index == 0 ? 0.0f : 1.0f});
        animation.setDuration((long)AnimationConfig.LOGO_TRANSACTION_TIME);
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                LogoAnimation.this.logoView1.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animation.setRepeatCount(-1);
        animation.setRepeatMode(2);
        animation.addListener((Animator.AnimatorListener)new LogoStateAnimationListener(this.logoStates, logoView, index));
        return animation;
    }

    @Override
    protected AnimatorSet buildAnimator() {
        this.anim = new AnimatorSet();
        ObjectAnimator alphaAnimation = this.getLogoStateAnimation(this.logoView1, 0);
        ObjectAnimator alphaAnimation2 = this.getLogoStateAnimation(this.logoView2, 1);
        this.anim.playTogether(new Animator[]{alphaAnimation, alphaAnimation2, this.getLogoAnimationSet()});
        return this.anim;
    }
}

