/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.alan.alansdk.button.animations.AnimationConfig;
import com.alan.alansdk.button.animations.BaseAnimation;

public class InnerBgListenAnimation
extends BaseAnimation {
    private View bgView;

    public InnerBgListenAnimation(View bg) {
        this.bgView = bg;
    }

    @Override
    protected AnimatorSet buildAnimator() {
        this.anim = new AnimatorSet();
        ObjectAnimator bgScaleXAnimation = this.getScaleAnimation(this.bgView, "scaleX");
        ObjectAnimator bgScaleYAnimation = this.getScaleAnimation(this.bgView, "scaleY");
        this.anim.playTogether(new Animator[]{bgScaleXAnimation, bgScaleYAnimation});
        return this.anim;
    }

    private ObjectAnimator getScaleAnimation(View view, String property) {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)view, (String)property, (float[])new float[]{1.0f, 0.94f});
        animation.setDuration((long)AnimationConfig.LISTEN_ANIMATION_TIME);
        animation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(-1);
        animation.setRepeatMode(2);
        return animation;
    }

    @Override
    public void stopAnimation() {
        super.stopAnimation();
        this.bgView.setScaleX(1.0f);
        this.bgView.setScaleY(1.0f);
    }
}

