/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.alanbase.speaker;

import android.os.Build;
import com.alan.alansdk.alanbase.speaker.SpeakerApi21;
import com.alan.alansdk.alanbase.speaker.SpeakerApi23;
import com.alan.alansdk.alanbase.speaker.SpeakerDumpListener;
import com.alan.alansdk.alanbase.speaker.SpeakerThread;
import com.alan.alansdk.logging.AlanLogger;

public class AlanSpeaker
implements SpeakerDumpListener {
    private SpeakerThread speakerThread;

    public void stopPlaying() {
        if (this.speakerThread == null) {
            return;
        }
        this.speakerThread.stopPlaying();
    }

    public void release() {
        if (this.speakerThread == null) {
            return;
        }
        try {
            this.speakerThread.release();
            this.speakerThread.join();
        }
        catch (InterruptedException e) {
            AlanLogger.e(e);
        }
    }

    public void startPlaying() {
        if (this.speakerThread == null || !this.speakerThread.isAlive()) {
            this.speakerThread = Build.VERSION.SDK_INT >= 23 ? new SpeakerApi23(this) : new SpeakerApi21(this);
            this.speakerThread.start();
        }
        this.speakerThread.interrupt();
    }

    @Override
    public float[] retrieveAudioBuffer() {
        return this.readFrameNative();
    }

    private native float[] readFrameNative();
}

