/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk.alanbase.recorder;

import android.annotation.TargetApi;
import android.media.AudioRecord;
import com.alan.alansdk.alanbase.recorder.RecordDumpListener;
import com.alan.alansdk.alanbase.recorder.RecorderThread;
import com.alan.alansdk.logging.AlanLogger;
import java.util.Arrays;

@TargetApi(value=21)
public class RecorderApi21
extends RecorderThread {
    private static final int BUFFER_SIZE_FACTOR = 2;
    private int samplesToSkip = 0;
    private short[] audioBuffer;

    @Override
    protected void skip(int samples) {
        this.samplesToSkip = samples;
    }

    public RecorderApi21(RecordDumpListener callback) {
        super(callback);
    }

    @Override
    protected boolean prepareRecorder() {
        int bufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2) * 2;
        if (bufferSize == -1 || bufferSize == -2) {
            bufferSize = 88200;
        }
        this.audioBuffer = new short[bufferSize];
        this.record = new AudioRecord(1, 44100, 16, 2, bufferSize);
        if (this.record.getState() != 1) {
            AlanLogger.e("Audio Record can't initialize!");
            return false;
        }
        this.shouldContinue = true;
        return this.shouldContinue;
    }

    @Override
    protected void writeFrames() {
        if (this.audioBuffer.length > 0) {
            if (this.samplesToSkip > 0) {
                int skip = Math.min(this.audioBuffer.length, this.samplesToSkip);
                this.samplesToSkip -= skip;
                if (skip >= this.audioBuffer.length) {
                    return;
                }
                short[] skippedBuffer = Arrays.copyOfRange(this.audioBuffer, skip, this.audioBuffer.length);
                this.callback.onRecordDump(this.floatMe(skippedBuffer));
            } else {
                this.callback.onRecordDump(this.floatMe(this.audioBuffer));
            }
        }
        if (this.audioBuffer.length > 0) {
            this.callback.onRecordDump(this.floatMe(this.audioBuffer));
        }
    }

    @Override
    protected int readBuffer() {
        return this.record.read(this.audioBuffer, 0, this.audioBuffer.length);
    }

    private float[] floatMe(short[] pcms) {
        float[] floaters = new float[pcms.length];
        for (int i = 0; i < pcms.length; ++i) {
            floaters[i] = pcms[i];
        }
        return floaters;
    }
}

