/*
 * Decompiled with CFR 0.152.
 */
package com.alan.alansdk;

import androidx.annotation.NonNull;
import org.json.JSONObject;

public class AlanConfig
implements Cloneable {
    private String server;
    private String projectId;
    private String dialogId;
    private String authJson;

    public String getProjectId() {
        return this.projectId;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public String getDataObject() {
        return this.authJson;
    }

    public String getServer() {
        if (this.server == null || this.server.isEmpty()) {
            return "wss://studio.alan.app";
        }
        return this.server;
    }

    public void setAuthJson(String authJson) {
        this.authJson = authJson;
    }

    public static Builder builder() {
        AlanConfig alanConfig = new AlanConfig();
        alanConfig.getClass();
        return alanConfig.new Builder();
    }

    @NonNull
    protected Object clone() throws CloneNotSupportedException {
        AlanConfig clone = new AlanConfig();
        clone.server = this.server;
        clone.projectId = this.projectId;
        clone.dialogId = this.dialogId;
        clone.authJson = this.authJson;
        return clone;
    }

    public class Builder {
        private Builder() {
        }

        public Builder setServer(String server) {
            AlanConfig.this.server = server;
            return this;
        }

        public Builder setProjectId(String projectId) {
            AlanConfig.this.projectId = projectId;
            return this;
        }

        public Builder setDialogId(String dialogId) {
            AlanConfig.this.dialogId = dialogId;
            return this;
        }

        public Builder setDataObject(String authJson) {
            AlanConfig.this.authJson = authJson;
            return this;
        }

        public Builder setDataObject(JSONObject authJson) {
            AlanConfig.this.authJson = authJson.toString();
            return this;
        }

        public AlanConfig build() {
            try {
                return (AlanConfig)AlanConfig.this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

