package com.alan.alansdk.qr;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import com.alan.alansdk.Alan;
import com.alan.alansdk.R;
import com.budiyev.android.codescanner.CodeScanner;
import com.budiyev.android.codescanner.CodeScannerView;
import com.budiyev.android.codescanner.DecodeCallback;
import com.google.zxing.Result;

import org.greenrobot.eventbus.EventBus;

public class QRScanActivity extends AppCompatActivity {
    private CodeScanner mCodeScanner;

    private final static int PERMISSION_REQUEST_CODE = 101;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_qr_scan);

        TextView versionView = findViewById(R.id.version_text);
        versionView.setText(Alan.getInstance(this).getVersion());
    }

    @Override
    protected void onResume() {
        super.onResume();

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA)
                != PackageManager.PERMISSION_GRANTED) {

            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.CAMERA},
                    PERMISSION_REQUEST_CODE);
        } else {
            initCodeScanner();
        }
    }

    private void initCodeScanner() {
        CodeScannerView scannerView = findViewById(R.id.scanner_view);
        mCodeScanner = new CodeScanner(this, scannerView);
        mCodeScanner.setDecodeCallback(new DecodeCallback() {
            @Override
            public void onDecoded(@NonNull final Result result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
//                        Toast.makeText(QRScanActivity.this, result.getText(), Toast.LENGTH_SHORT).show();
                        onBarcodeRecognized(result.getText());
                    }
                });
            }
        });

        mCodeScanner.startPreview();
    }

    @Override
    protected void onPause() {
        if (mCodeScanner != null) {
            mCodeScanner.releaseResources();
        }
        super.onPause();
    }

    private void onBarcodeRecognized(String barcode) {
        Intent result = new Intent();
        result.putExtra("BARCODE", barcode);
        if (Alan.QR_EVENT_BUS_ENABLED) {
            EventBus.getDefault().post(new BarcodeEvent(barcode));
        }
        setResult(Activity.RESULT_OK, result);
        finish();
    }
}