/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import org.apache.ws.jaxme.JMManager;
import org.apache.ws.jaxme.Observer;
import org.apache.ws.jaxme.PM;
import org.apache.ws.jaxme.PMException;
import org.apache.ws.jaxme.PMParams;

public abstract class PMImpl
implements PM {
    private JMManager manager;

    public void init(JMManager pManager) throws JAXBException {
        this.manager = pManager;
    }

    public JMManager getManager() {
        return this.manager;
    }

    public void select(Observer pObserver, String pQuery) throws PMException {
        this.select(pObserver, pQuery, null);
    }

    public Iterator select(String pQuery) throws PMException {
        return this.select(pQuery, null);
    }

    public Iterator select(String pQuery, PMParams pPlaceHolderArgs) throws PMException {
        ArrayList result = new ArrayList();
        ListObserver observer = new ListObserver(result);
        this.select(observer, pQuery, pPlaceHolderArgs);
        return result.iterator();
    }

    public Object create() throws JAXBException {
        return this.manager.getFactory().getElement(this.manager.getElementInterface());
    }

    protected String parseQuery(String pQuery, PMParams pPlaceHolderArgs) throws PMException {
        if (pPlaceHolderArgs == null) {
            return pQuery;
        }
        Iterator iter = pPlaceHolderArgs.getParams();
        if (!iter.hasNext()) {
            return pQuery;
        }
        StringBuffer sb = new StringBuffer();
        boolean inStr = false;
        char delim = '\u0000';
        block11: for (int i = 0; i < pQuery.length(); ++i) {
            char c = pQuery.charAt(i);
            if (inStr) {
                if (c == delim) {
                    inStr = false;
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\'': {
                    inStr = true;
                    delim = c;
                    sb.append(c);
                    continue block11;
                }
                case '?': {
                    if (!iter.hasNext()) {
                        throw new PMException("Number of placeholder marks exceeds number of actual parameters");
                    }
                    PMParams.Param param = (PMParams.Param)iter.next();
                    switch (param.getType()) {
                        case 12: {
                            sb.append('\'');
                            sb.append(param.getValue());
                            sb.append('\'');
                            continue block11;
                        }
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            sb.append(param.getValue());
                            continue block11;
                        }
                        case 93: {
                            sb.append('\'');
                            sb.append(DatatypeConverter.printDateTime((Calendar)((Calendar)param.getValue())));
                            sb.append('\'');
                            continue block11;
                        }
                        case 91: {
                            sb.append('\'');
                            sb.append(DatatypeConverter.printDate((Calendar)((Calendar)param.getValue())));
                            sb.append('\'');
                            continue block11;
                        }
                        case 92: {
                            sb.append('\'');
                            sb.append(DatatypeConverter.printTime((Calendar)((Calendar)param.getValue())));
                            sb.append('\'');
                            continue block11;
                        }
                    }
                    throw new PMException("Invalid parameter type: " + param.getType());
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (inStr) {
            throw new PMException("Failed to parse query, expected trailing " + delim + " character: " + pQuery);
        }
        if (iter.hasNext()) {
            throw new PMException("Number of actual parameters exceeds number of placeholder marks.");
        }
        return sb.toString();
    }

    public static class ListObserver
    implements Observer {
        private List list;

        public ListObserver(List pList) {
            this.list = pList;
        }

        public void notify(Object pObservable) {
            this.list.add(pObservable);
        }
    }
}

