/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.generator.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ws.jaxme.generator.Generator;
import org.apache.ws.jaxme.generator.SchemaReader;
import org.apache.ws.jaxme.generator.sg.AttributeSG;
import org.apache.ws.jaxme.generator.sg.AttributeSGChain;
import org.apache.ws.jaxme.generator.sg.ComplexContentSG;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSG;
import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SGFactoryChain;
import org.apache.ws.jaxme.generator.sg.SchemaSGChain;
import org.apache.ws.jaxme.generator.sg.TypeSGChain;
import org.apache.ws.jaxme.generator.sg.impl.AttributeSGImpl;
import org.apache.ws.jaxme.generator.sg.impl.JaxMeSchemaReader;
import org.apache.ws.jaxme.generator.sg.impl.SGFactoryChainImpl;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.pm.generator.jdbc.ConnectionDetails;
import org.apache.ws.jaxme.pm.generator.jdbc.CustomColumnData;
import org.apache.ws.jaxme.pm.generator.jdbc.CustomTableData;
import org.apache.ws.jaxme.pm.generator.jdbc.JdbcSchemaSG;
import org.apache.ws.jaxme.pm.generator.jdbc.JdbcTypeSG;
import org.apache.ws.jaxme.pm.generator.jdbc.TableDetails;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;
import org.apache.ws.jaxme.util.ClassLoader;
import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.parser.XsObjectCreator;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.types.XSBase64Binary;
import org.apache.ws.jaxme.xs.types.XSBoolean;
import org.apache.ws.jaxme.xs.types.XSByte;
import org.apache.ws.jaxme.xs.types.XSDate;
import org.apache.ws.jaxme.xs.types.XSDateTime;
import org.apache.ws.jaxme.xs.types.XSDouble;
import org.apache.ws.jaxme.xs.types.XSFloat;
import org.apache.ws.jaxme.xs.types.XSInt;
import org.apache.ws.jaxme.xs.types.XSShort;
import org.apache.ws.jaxme.xs.types.XSString;
import org.apache.ws.jaxme.xs.types.XSTime;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JaxMeJdbcSG
extends SGFactoryChainImpl {
    Logger log = LoggerAccess.getLogger((Class)(class$org$apache$ws$jaxme$pm$generator$jdbc$JaxMeJdbcSG == null ? (class$org$apache$ws$jaxme$pm$generator$jdbc$JaxMeJdbcSG = JaxMeJdbcSG.class$("org.apache.ws.jaxme.pm.generator.jdbc.JaxMeJdbcSG")) : class$org$apache$ws$jaxme$pm$generator$jdbc$JaxMeJdbcSG));
    public static final String JAXME_JDBC_SCHEMA_URI = "http://ws.apache.org/jaxme/namespaces/jaxme2/jdbc-mapping";
    private SGFactory sgFactory;
    private SQLFactory sqlFactory;
    private String key;
    static /* synthetic */ Class class$org$apache$ws$jaxme$pm$generator$jdbc$JaxMeJdbcSG;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$impl$JaxMeSchemaReader;
    static /* synthetic */ Class class$org$apache$ws$jaxme$sqls$SQLFactory;

    public JaxMeJdbcSG(SGFactoryChain o) {
        super(o);
    }

    public String getKey() {
        return this.key;
    }

    public void init(SGFactory pFactory) {
        super.init(pFactory);
        this.sgFactory = pFactory;
        SchemaReader schemaReader = pFactory.getGenerator().getSchemaReader();
        if (!(schemaReader instanceof JaxMeSchemaReader)) {
            throw new IllegalStateException("The schema reader " + schemaReader.getClass().getName() + " is not an instance of " + (class$org$apache$ws$jaxme$generator$sg$impl$JaxMeSchemaReader == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JaxMeSchemaReader = JaxMeJdbcSG.class$("org.apache.ws.jaxme.generator.sg.impl.JaxMeSchemaReader")) : class$org$apache$ws$jaxme$generator$sg$impl$JaxMeSchemaReader).getName());
        }
        JaxMeSchemaReader jaxmeSchemaReader = (JaxMeSchemaReader)schemaReader;
        jaxmeSchemaReader.addXsObjectCreator(new XsObjectCreator(){

            public XsObject newBean(XsObject pParent, Locator pLocator, XsQName pQName) throws SAXException {
                if (JaxMeJdbcSG.JAXME_JDBC_SCHEMA_URI.equals(pQName.getNamespaceURI())) {
                    if ("table".equals(pQName.getLocalName())) {
                        return new TableDetails(JaxMeJdbcSG.this, pParent);
                    }
                    if ("connection".equals(pQName.getLocalName())) {
                        return new ConnectionDetails(JaxMeJdbcSG.this, pParent);
                    }
                    throw new LocSAXException("Invalid element name: " + pQName, pLocator);
                }
                return null;
            }
        });
        String s = schemaReader.getGenerator().getProperty("jdbc.sqlFactory");
        if (s == null) {
            this.sqlFactory = new SQLFactoryImpl();
        } else {
            Class c;
            try {
                c = ClassLoader.getClass((String)s, (Class)(class$org$apache$ws$jaxme$sqls$SQLFactory == null ? (class$org$apache$ws$jaxme$sqls$SQLFactory = JaxMeJdbcSG.class$("org.apache.ws.jaxme.sqls.SQLFactory")) : class$org$apache$ws$jaxme$sqls$SQLFactory));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("SQLFactory class " + s + ", specified by property jdbc.sqlFactory, not found.");
            }
            try {
                this.sqlFactory = (SQLFactory)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Unable to instantiate SQLFactory class " + c.getName());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Illegal access to the default constructor of SQLFactory class " + c.getName());
            }
        }
        this.key = pFactory.getGenerator().getKey();
    }

    protected SGFactory getSGFactory() {
        return this.sgFactory;
    }

    public Generator getGenerator(SGFactory pFactory) {
        return super.getGenerator(pFactory);
    }

    protected Mode getDatabaseMode(ConnectionDetails pDetails, Connection pConn) throws SQLException {
        if (pDetails == null) {
            String v = pConn.getMetaData().getDatabaseProductName();
            try {
                return Mode.valueOf(v);
            }
            catch (Exception e) {
                return Mode.GENERIC;
            }
        }
        return pDetails.getDbMode();
    }

    protected int getDbType(Mode pDbMode, int pDbType, long pScale, long pPrecision, String pDbTypeName) {
        if (Mode.GENERIC.equals(pDbMode)) {
            return pDbType;
        }
        if (pDbType == 1111) {
            if ("CLOB".equalsIgnoreCase(pDbTypeName)) {
                return 2005;
            }
            if ("BLOB".equalsIgnoreCase(pDbTypeName)) {
                return 2004;
            }
            return 1111;
        }
        if (pDbType == 2 || "NUMBER".equalsIgnoreCase(pDbTypeName)) {
            if (pScale == 0L) {
                if (pPrecision == 0L) {
                    return 6;
                }
                if (pPrecision <= 2L) {
                    return -6;
                }
                if (pPrecision <= 4L) {
                    return 5;
                }
                if (pPrecision <= 9L) {
                    return 4;
                }
                return -5;
            }
            if (pScale == -127L ? pPrecision < 24L : pPrecision < 8L) {
                return 6;
            }
        } else if (pDbType != 2) {
            return pDbType;
        }
        return 8;
    }

    /*
     * WARNING - void declaration
     */
    protected Object addColumn(ComplexTypeSG pTypeSG, XSType pType, Column pColumn) throws SAXException {
        ComplexContentSG cct;
        GroupSG groupSG;
        ParticleSG[] childs;
        String mName = "addColumn";
        this.log.entering("addColumn", (Object)pColumn.getQName());
        ArrayList<Object> allChilds = new ArrayList<Object>();
        AttributeSG[] attributes = pTypeSG.getAttributes();
        if (attributes != null) {
            allChilds.addAll(Arrays.asList(attributes));
        }
        if (!pTypeSG.hasSimpleContent() && (childs = (groupSG = (cct = pTypeSG.getComplexContentSG()).getGroupSG()).getParticles()) != null) {
            for (int i = 0; i < childs.length; ++i) {
                ObjectSG objectSG;
                ParticleSG child = childs[i];
                if (!child.isElement() || (objectSG = child.getObjectSG()).getTypeSG().isComplex()) continue;
                allChilds.add(child);
            }
        }
        AttributeSGImpl theChild = null;
        Iterator iter = allChilds.iterator();
        while (iter.hasNext()) {
            String localName;
            Object currentChild = iter.next();
            if (currentChild instanceof AttributeSG) {
                localName = ((AttributeSG)currentChild).getName().getLocalName();
            } else if (currentChild instanceof ParticleSG) {
                localName = ((ParticleSG)currentChild).getObjectSG().getName().getLocalName();
            } else {
                throw new IllegalStateException("Expected either attribute or element.");
            }
            if (localName == null || !localName.equalsIgnoreCase(pColumn.getName().getName())) continue;
            if (theChild == null) {
                theChild = (AttributeSGImpl)currentChild;
                continue;
            }
            this.log.warn("addColumn", "Multiple matching attributes or child elements found for column " + pColumn.getQName());
        }
        if (theChild == null) {
            void var8_8;
            XSBase64Binary xsType;
            if (pColumn.isBinaryColumn()) {
                xsType = XSBase64Binary.getInstance();
            } else if (pColumn.isStringColumn()) {
                xsType = XSString.getInstance();
            } else {
                Column.Type myType = pColumn.getType();
                if (Column.Type.BIT.equals(myType)) {
                    xsType = XSBoolean.getInstance();
                } else if (Column.Type.DATE.equals(myType)) {
                    xsType = XSDate.getInstance();
                } else if (Column.Type.DOUBLE.equals(myType)) {
                    xsType = XSDouble.getInstance();
                } else if (Column.Type.FLOAT.equals(myType)) {
                    xsType = XSFloat.getInstance();
                } else if (Column.Type.SMALLINT.equals(myType)) {
                    xsType = XSShort.getInstance();
                } else if (Column.Type.TIME.equals(myType)) {
                    xsType = XSTime.getInstance();
                } else if (Column.Type.TIMESTAMP.equals(myType)) {
                    xsType = XSDateTime.getInstance();
                } else if (Column.Type.TINYINT.equals(myType)) {
                    xsType = XSByte.getInstance();
                } else if (Column.Type.INTEGER.equals(myType)) {
                    xsType = XSInt.getInstance();
                } else {
                    throw new IllegalStateException("Unknown column type: " + myType);
                }
            }
            JdbcAttribute attr = new JdbcAttribute((XSObject)pType, pType.getLocator(), new XsQName((String)null, pColumn.getName().getName()), (XSType)var8_8, pColumn.isNullable());
            AttributeSGChain chain = (AttributeSGChain)pTypeSG.newAttributeSG((XSAttribute)attr);
            AttributeSGImpl attributeSG = new AttributeSGImpl(chain);
            pTypeSG.addAttributeSG((AttributeSG)attributeSG);
            theChild = attributeSG;
        }
        return theChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomTableData addTableData(ComplexTypeSG pTypeSG, XSType pType, TableDetails pTableDetails) throws SAXException {
        CustomTableData customTableData;
        block11: {
            String mName = "addTableData";
            this.log.entering("addTableData", new Object[]{pTypeSG, pTableDetails});
            String tableName = pTableDetails.getName();
            Connection conn = pTableDetails.getDriver() == null ? new DatasourceConnector().getConnection(pTableDetails) : new DriverManagerConnector().getConnection(pTableDetails);
            try {
                Table table;
                String schemaName;
                int offset = tableName.indexOf(46);
                if (offset > 0) {
                    schemaName = tableName.substring(0, offset);
                    tableName = tableName.substring(offset + 1);
                } else {
                    schemaName = null;
                }
                try {
                    table = this.sqlFactory.getTable(conn, schemaName, tableName);
                    conn.close();
                    conn = null;
                }
                catch (SQLException e) {
                    throw new SAXException("Failed to read table " + pTableDetails.getName() + ": " + e.getMessage(), e);
                }
                if (table.getPrimaryKey() == null) {
                    throw new IllegalStateException("The table " + table.getQName() + " does not have a primary key.");
                }
                CustomTableData customTableData2 = new CustomTableData(this, table, pTypeSG, pTableDetails);
                Iterator iter = table.getColumns();
                while (iter.hasNext()) {
                    Column col = (Column)iter.next();
                    Object sg = this.addColumn(pTypeSG, pType, col);
                    CustomColumnData colData = new CustomColumnData(col.getName().getName(), sg);
                    col.setCustomData((Object)colData);
                }
                customTableData = customTableData2;
                Object var16_16 = null;
                if (conn == null) break block11;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var16_17 = null;
                    if (conn == null) break block12;
                    try {
                        conn.close();
                    }
                    catch (Throwable ignore) {}
                }
                throw throwable;
            }
            try {
                conn.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return customTableData;
    }

    public Object newTypeSG(SGFactory pController, XSType pType) throws SAXException {
        return new JdbcTypeSG(this, (TypeSGChain)super.newTypeSG(pController, pType), pType);
    }

    public Object newTypeSG(SGFactory pController, XSType pType, XsQName pName) throws SAXException {
        return new JdbcTypeSG(this, (TypeSGChain)super.newTypeSG(pController, pType, pName), pType);
    }

    public Object newTypeSG(SGFactory pController, XSType pType, Context pClassContext, XsQName pName) throws SAXException {
        return new JdbcTypeSG(this, (TypeSGChain)super.newTypeSG(pController, pType, pClassContext, pName), pType);
    }

    public Object newSchemaSG(SGFactory pController, XSSchema pSchema) throws SAXException {
        Object chain = (SchemaSGChain)super.newSchemaSG(pController, pSchema);
        chain = new JdbcSchemaSG(this, (SchemaSGChain)chain);
        return chain;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DatasourceConnector
    implements Connector {
        private DatasourceConnector() {
        }

        public Connection getConnection(TableDetails pTableDetails) throws SAXException {
            DataSource ds;
            InitialContext ic;
            try {
                ic = new InitialContext();
            }
            catch (NamingException e) {
                throw new LocSAXException("Failed to create initial JNDI context: " + e.getClass().getName() + ", " + e.getMessage(), pTableDetails.getLocator(), (Exception)e);
            }
            try {
                ds = (DataSource)ic.lookup(pTableDetails.getDatasource());
            }
            catch (NamingException e) {
                throw new LocSAXException("Failed to lookup datasource " + pTableDetails.getDatasource() + ": " + e.getClass().getName() + ", " + e.getMessage(), pTableDetails.getLocator(), (Exception)e);
            }
            try {
                Connection conn = ds.getConnection(pTableDetails.getUser(), pTableDetails.getPassword());
                if (conn == null) {
                    throw new LocSAXException("Unable to connect to " + pTableDetails.getUrl() + " as user " + pTableDetails.getUser() + ": Datasource returned a null connection", pTableDetails.getLocator());
                }
                return conn;
            }
            catch (SQLException e) {
                throw new LocSAXException("Unable to connect to datasource " + pTableDetails.getUrl() + " as user " + pTableDetails.getUser() + ": SQL State = " + e.getSQLState() + ", error code = " + e.getErrorCode() + ", " + e.getMessage(), pTableDetails.getLocator(), (Exception)e);
            }
        }
    }

    private class DriverManagerConnector
    implements Connector {
        private DriverManagerConnector() {
        }

        public Connection getConnection(TableDetails pTableDetails) throws SAXException {
            Exception ex;
            Class<?> c;
            block10: {
                String mName = "DriverManagerConnector.getConnection";
                c = null;
                ex = null;
                JaxMeJdbcSG.this.log.fine("DriverManagerConnector.getConnection", "Loading driver " + pTableDetails.getDriver());
                try {
                    Class.forName(pTableDetails.getDriver());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (c == null) {
                    try {
                        c = Thread.currentThread().getContextClassLoader().loadClass(pTableDetails.getDriver());
                    }
                    catch (Exception e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
            }
            if (c == null) {
                if (ex == null) {
                    ex = new ClassNotFoundException();
                }
                throw new LocSAXException("Unable to load driver class " + pTableDetails.getDriver() + ": " + ex.getClass().getName() + ", " + ex.getMessage(), pTableDetails.getLocator());
            }
            JaxMeJdbcSG.this.log.fine("DriverManagerConnector.getConnection", "Connecting to database " + pTableDetails.getUrl() + " as " + pTableDetails.getUser());
            try {
                Connection conn = DriverManager.getConnection(pTableDetails.getUrl(), pTableDetails.getUser(), pTableDetails.getPassword());
                if (conn == null) {
                    throw new LocSAXException("Unable to connect to " + pTableDetails.getUrl() + " as user " + pTableDetails.getUser() + ": DriverManager returned a null connection", pTableDetails.getLocator());
                }
                return conn;
            }
            catch (SQLException e) {
                throw new LocSAXException("Unable to connect to " + pTableDetails.getUrl() + " as user " + pTableDetails.getUser() + ": SQL State = " + e.getSQLState() + ", error code = " + e.getErrorCode() + ", " + e.getMessage(), pTableDetails.getLocator(), (Exception)e);
            }
        }
    }

    private static interface Connector {
        public Connection getConnection(TableDetails var1) throws SAXException;
    }

    private class JdbcAttribute
    implements XSAttribute {
        private final Locator locator;
        private final XsQName name;
        private final XSType type;
        private final boolean isOptional;
        private final XSObject parent;

        public JdbcAttribute(XSObject pParent, Locator pLocator, XsQName pName, XSType pType, boolean pOptional) {
            this.parent = pParent;
            this.locator = pLocator;
            this.name = pName;
            this.type = pType;
            this.isOptional = pOptional;
        }

        public boolean isGlobal() {
            return false;
        }

        public void setGlobal(boolean pGlobal) {
            if (!pGlobal) {
                throw new IllegalStateException("This attribute cannot be made global");
            }
        }

        public XsQName getName() {
            return this.name;
        }

        public XSType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public XSAnnotation[] getAnnotations() {
            return new XSAnnotation[0];
        }

        public Locator getLocator() {
            return this.locator;
        }

        public void validate() throws SAXException {
        }

        public boolean isTopLevelObject() {
            return false;
        }

        public XSObject getParentObject() {
            return this.parent;
        }

        public XSSchema getXSSchema() {
            return this.parent.getXSSchema();
        }

        public String getDefault() {
            return null;
        }

        public String getFixed() {
            return null;
        }

        public Attributes getOpenAttributes() {
            return null;
        }
    }

    public static class Mode {
        private String name;
        public static final Mode GENERIC = new Mode("Generic");
        public static final Mode ORACLE = new Mode("Oracle");

        private Mode(String pName) {
            this.name = pName;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Mode)) {
                return false;
            }
            return this.name.equals(((Mode)o).name);
        }

        public static Mode valueOf(String pMode) {
            if ("GENERIC".equalsIgnoreCase(pMode)) {
                return GENERIC;
            }
            if ("ORACLE".equalsIgnoreCase(pMode)) {
                return ORACLE;
            }
            throw new IllegalArgumentException("Valid database modes are either of 'generic' or 'oracle', not " + pMode);
        }
    }
}

