/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.depend;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.depend.DependencyAnalyzer;

public class DependScanner
extends DirectoryScanner {
    public static final String DEFAULT_ANALYZER_CLASS = "org.apache.tools.ant.util.depend.bcel.FullAnalyzer";
    private File basedir;
    private Vector rootClasses;
    private Vector included;
    private DirectoryScanner parentScanner;

    public DependScanner(DirectoryScanner parentScanner) {
        this.parentScanner = parentScanner;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setRootClasses(Vector rootClasses) {
        this.rootClasses = rootClasses;
    }

    public String[] getIncludedFiles() {
        int count = this.included.size();
        String[] files = new String[count];
        for (int i = 0; i < count; ++i) {
            files[i] = (String)this.included.elementAt(i);
        }
        return files;
    }

    public void scan() throws IllegalStateException {
        this.included = new Vector();
        String analyzerClassName = DEFAULT_ANALYZER_CLASS;
        DependencyAnalyzer analyzer = null;
        try {
            Class<?> analyzerClass = Class.forName(analyzerClassName);
            analyzer = (DependencyAnalyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new BuildException("Unable to load dependency analyzer: " + analyzerClassName, (Throwable)e);
        }
        analyzer.addClassPath(new Path(null, this.basedir.getPath()));
        Enumeration e = this.rootClasses.elements();
        while (e.hasMoreElements()) {
            String rootClass = (String)e.nextElement();
            analyzer.addRootClass(rootClass);
        }
        e = analyzer.getClassDependencies();
        String[] parentFiles = this.parentScanner.getIncludedFiles();
        Hashtable<String, String> parentSet = new Hashtable<String, String>();
        for (int i = 0; i < parentFiles.length; ++i) {
            parentSet.put(parentFiles[i], parentFiles[i]);
        }
        while (e.hasMoreElements()) {
            String classname = (String)e.nextElement();
            String filename = classname.replace('.', File.separatorChar);
            File depFile = new File(this.basedir, filename = filename + ".class");
            if (!depFile.exists() || !parentSet.containsKey(filename)) continue;
            this.included.addElement(filename);
        }
    }

    public void addDefaultExcludes() {
    }

    public String[] getExcludedDirectories() {
        return null;
    }

    public String[] getExcludedFiles() {
        return null;
    }

    public String[] getIncludedDirectories() {
        return new String[0];
    }

    public String[] getNotIncludedDirectories() {
        return null;
    }

    public String[] getNotIncludedFiles() {
        return null;
    }

    public void setExcludes(String[] excludes) {
    }

    public void setIncludes(String[] includes) {
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
    }
}

