/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionSet;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionUtil;

public class JarLibAvailableTask
extends Task {
    private File m_file;
    private final Vector m_extensionSets = new Vector();
    private String m_property;
    private ExtensionAdapter m_extension;

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setFile(File file) {
        this.m_file = file;
    }

    public void addConfiguredExtension(ExtensionAdapter extension) {
        if (null != this.m_extension) {
            String message = "Can not specify extension to search for multiple times.";
            throw new BuildException("Can not specify extension to search for multiple times.");
        }
        this.m_extension = extension;
    }

    public void addConfiguredExtensionSet(ExtensionSet extensionSet) {
        this.m_extensionSets.addElement(extensionSet);
    }

    public void execute() throws BuildException {
        this.validate();
        Extension test = this.m_extension.toExtension();
        if (!this.m_extensionSets.isEmpty()) {
            Iterator iterator = ((AbstractList)this.m_extensionSets).iterator();
            while (iterator.hasNext()) {
                ExtensionSet extensionSet = (ExtensionSet)((Object)iterator.next());
                Extension[] extensions = extensionSet.toExtensions(this.getProject());
                int i = 0;
                while (i < extensions.length) {
                    Extension extension = extensions[i];
                    if (extension.isCompatibleWith(test)) {
                        this.getProject().setNewProperty(this.m_property, "true");
                    }
                    ++i;
                }
            }
        } else {
            Manifest manifest = ExtensionUtil.getManifest(this.m_file);
            Extension[] extensions = Extension.getAvailable(manifest);
            int i = 0;
            while (i < extensions.length) {
                Extension extension = extensions[i];
                if (extension.isCompatibleWith(test)) {
                    this.getProject().setNewProperty(this.m_property, "true");
                }
                ++i;
            }
        }
    }

    private void validate() throws BuildException {
        if (null == this.m_extension) {
            String message = "Extension element must be specified.";
            throw new BuildException("Extension element must be specified.");
        }
        if (null == this.m_file && this.m_extensionSets.isEmpty()) {
            String message = "File attribute not specified.";
            throw new BuildException("File attribute not specified.");
        }
        if (null != this.m_file && !this.m_file.exists()) {
            String message = "File '" + this.m_file + "' does not exist.";
            throw new BuildException(message);
        }
        if (null != this.m_file && !this.m_file.isFile()) {
            String message = "'" + this.m_file + "' is not a file.";
            throw new BuildException(message);
        }
    }
}

