/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfo;

public class LineNumberTable
extends AttributeInfo {
    protected int count;
    protected int[] varTable;

    public LineNumberTable(int attr_index, ConstantPool pool) {
        super(attr_index, pool);
    }

    protected void read(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        this.count = dis.readShort();
        this.varTable = new int[this.count * 2];
        int i = 0;
        while (i < this.varTable.length) {
            this.varTable[i] = dis.readShort();
            ++i;
        }
    }

    public int getStartPC(int i) {
        return this.varTable[2 * i];
    }

    public int getLineNumber(int i) {
        return this.varTable[2 * i + 1];
    }

    public int length() {
        return this.count;
    }
}

