/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassFile;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassFilter;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassPathLoader;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.DirectoryFilter;

class DirectoryLoader
implements ClassPathLoader.FileLoader {
    private File directory;

    DirectoryLoader(File dir) {
        this.directory = dir;
    }

    public File getFile() {
        return this.directory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassFile[] getClasses() throws IOException {
        Vector<ClassFile> v = new Vector<ClassFile>();
        Vector files = DirectoryLoader.listFiles(this.directory, new ClassFilter(), true);
        int i = 0;
        while (true) {
            block7: {
                IOException ignored2;
                Object var8_7;
                if (i >= files.size()) {
                    Object[] classes = new ClassFile[v.size()];
                    v.copyInto(classes);
                    return classes;
                }
                File file = (File)files.elementAt(i);
                InputStream is = null;
                try {
                    is = ClassPathLoader.getCachedStream(new FileInputStream(file));
                    ClassFile classFile = new ClassFile(is);
                    is.close();
                    is = null;
                    v.addElement(classFile);
                    var8_7 = null;
                    if (is == null) break block7;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ignored2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ignored2) {}
                is.close();
            }
            ++i;
        }
    }

    public static Vector listFiles(File directory, FilenameFilter filter, boolean recurse) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        Vector list = new Vector();
        DirectoryLoader.listFilesTo(list, directory, filter, recurse);
        return list;
    }

    private static Vector listFilesTo(Vector list, File directory, FilenameFilter filter, boolean recurse) {
        String[] files = directory.list(filter);
        int i = 0;
        while (i < files.length) {
            list.addElement(new File(directory, files[i]));
            ++i;
        }
        files = null;
        if (recurse) {
            String[] subdirs = directory.list(new DirectoryFilter());
            int i2 = 0;
            while (i2 < subdirs.length) {
                DirectoryLoader.listFilesTo(list, new File(directory, subdirs[i2]), filter, recurse);
                ++i2;
            }
        }
        return list;
    }
}

