/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class Ilasm
extends MatchingTask {
    protected static final String exe_name = "ilasm";
    protected static final String file_ext = "il";
    protected static final String file_pattern = "**/*.il";
    protected static final String exe_title = "ilasm";
    private File _srcDir;
    protected String _targetType;
    protected boolean _verbose;
    protected boolean _listing;
    protected File _outputFile;
    protected File _resourceFile;
    protected boolean _failOnError;
    protected boolean _debug;
    private File _keyfile;
    protected String _extraOptions;

    public Ilasm() {
        this.Clear();
        this.setIncludes(file_pattern);
    }

    public void Clear() {
        this._targetType = null;
        this._srcDir = null;
        this._listing = false;
        this._verbose = false;
        this._debug = true;
        this._outputFile = null;
        this._failOnError = true;
        this._resourceFile = null;
        this._extraOptions = null;
    }

    public void setSrcDir(File srcDirName) {
        this._srcDir = srcDirName;
    }

    public void setTargetType(String targetType) throws BuildException {
        if (!(targetType = targetType.toLowerCase()).equals("exe") && !targetType.equals("library")) {
            throw new BuildException("targetType " + targetType + " is not a valid type");
        }
        this._targetType = targetType;
    }

    public String getTargetType() {
        return this._targetType;
    }

    protected String getTargetTypeParameter() {
        if (!this.notEmpty(this._targetType)) {
            return null;
        }
        if (this._targetType.equals("exe")) {
            return "/exe";
        }
        if (this._targetType.equals("library")) {
            return "/dll";
        }
        return null;
    }

    public void setOwner(String s) {
        this.log("This option is not supported by ILASM as of Beta-2, and will be ignored", 1);
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public void setVerbose(boolean b) {
        this._verbose = b;
    }

    protected String getVerboseParameter() {
        return this._verbose ? null : "/quiet";
    }

    public void setListing(boolean b) {
        this._listing = b;
    }

    protected String getListingParameter() {
        return this._listing ? "/listing" : "/nolisting";
    }

    public void setOutputFile(File params) {
        this._outputFile = params;
    }

    protected String getOutputFileParameter() {
        if (this._outputFile == null || this._outputFile.length() == 0L) {
            return null;
        }
        File f = this._outputFile;
        return "/output=" + f.toString();
    }

    public void setResourceFile(File fileName) {
        this._resourceFile = fileName;
    }

    protected String getResourceFileParameter() {
        if (this._resourceFile != null) {
            return "/resource=" + this._resourceFile.toString();
        }
        return null;
    }

    public void setFailOnError(boolean b) {
        this._failOnError = b;
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    public void setDebug(boolean f) {
        this._debug = f;
    }

    public boolean getDebug() {
        return this._debug;
    }

    protected String getDebugParameter() {
        return this._debug ? "/debug" : null;
    }

    public void setKeyfile(File keyfile) {
        this._keyfile = keyfile;
    }

    protected String getKeyfileParameter() {
        if (this._keyfile != null) {
            return "/keyfile:" + this._keyfile.toString();
        }
        return null;
    }

    public void setExtraOptions(String extraOptions) {
        this._extraOptions = extraOptions;
    }

    public String getExtraOptions() {
        return this._extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this._extraOptions != null && this._extraOptions.length() != 0) {
            return this._extraOptions;
        }
        return null;
    }

    public void execute() throws BuildException {
        if (this._srcDir == null) {
            this._srcDir = ((ProjectComponent)this).project.resolveFile(".");
        }
        DirectoryScanner scanner = super.getDirectoryScanner(this._srcDir);
        String[] dependencies = scanner.getIncludedFiles();
        this.log("assembling " + dependencies.length + " file" + (dependencies.length == 1 ? "" : "s"));
        String baseDir = scanner.getBasedir().toString();
        int i = 0;
        while (i < dependencies.length) {
            String targetFile = dependencies[i];
            targetFile = baseDir + File.separator + targetFile;
            this.executeOneFile(targetFile);
            ++i;
        }
    }

    public void executeOneFile(String targetFile) throws BuildException {
        NetCommand command = new NetCommand((Task)this, "ilasm", "ilasm");
        command.setFailOnError(this.getFailFailOnError());
        command.setTraceCommandLine(true);
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getListingParameter());
        command.addArgument(this.getOutputFileParameter());
        command.addArgument(this.getResourceFileParameter());
        command.addArgument(this.getVerboseParameter());
        command.addArgument(this.getKeyfileParameter());
        command.addArgument(this.getExtraOptionsParameter());
        command.addArgument(targetFile);
        command.runCommand();
    }
}

