/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.types;

import java.io.File;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.FileVisitor;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class LibrarySet
extends ProjectComponent {
    private final FileSet set = new FileSet();
    private String ifCond;
    private String unlessCond;
    private String[] libnames = new String[0];
    private boolean explicitCaseSensitive;
    private String dataset;

    public void setProject(Project project) {
        this.set.setProject(project);
        super.setProject(project);
    }

    public void setIf(String propName) {
        this.ifCond = propName;
    }

    public void setUnless(String propName) {
        this.unlessCond = propName;
    }

    protected FileSet getFileSet() {
        return this.set;
    }

    public void setDir(File dir) throws BuildException {
        this.set.setDir(dir);
    }

    public File getDir(Project project) {
        return this.set.getDir(project);
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.explicitCaseSensitive = true;
        this.set.setCaseSensitive(isCaseSensitive);
    }

    public void setLibs(CUtil.StringArrayBuilder libs) throws BuildException {
        this.libnames = libs.getValue();
        if (System.getProperty("os.name").equals("OS/400")) {
            return;
        }
        if (System.getProperty("os.name").equals("OS/390")) {
            return;
        }
        if (!this.isActive(this.getProject())) {
            return;
        }
        int i = 0;
        while (i < this.libnames.length) {
            if (this.libnames[i].indexOf(".") >= 0) {
                throw new BuildException("Library names should not contain periods: " + this.libnames[i]);
            }
            if (this.libnames[i].length() >= 3 && this.libnames[i].substring(0, 3).equalsIgnoreCase("lib")) {
                throw new BuildException("Library names should not start with \"lib\": " + this.libnames[i]);
            }
            ++i;
        }
    }

    public String[] getLibs() {
        String[] retval = (String[])this.libnames.clone();
        return retval;
    }

    public boolean isActive(Project p) {
        String unlessValue;
        if (p == null) {
            throw new NullPointerException("p");
        }
        if (this.ifCond != null) {
            String ifValue = p.getProperty(this.ifCond);
            if (ifValue != null) {
                if (ifValue.equals("no") || ifValue.equals("false")) {
                    throw new BuildException("property " + this.ifCond + " used as if condition has value " + ifValue + " which suggests a misunderstanding of if attributes");
                }
            } else {
                return false;
            }
        }
        if (this.unlessCond != null && (unlessValue = p.getProperty(this.unlessCond)) != null) {
            if (unlessValue.equals("no") || unlessValue.equals("false")) {
                throw new BuildException("property " + this.unlessCond + " used as unless condition has value " + unlessValue + " which suggests a misunderstanding of unless attributes");
            }
            return false;
        }
        return true;
    }

    public void visitLibraries(Project project, Linker linker, File[] libpath, FileVisitor visitor) throws BuildException {
        FileSet localSet = (FileSet)this.set.clone();
        if (!this.explicitCaseSensitive) {
            boolean linkerCaseSensitive = linker.isCaseSensitive();
            localSet.setCaseSensitive(linkerCaseSensitive);
        }
        if (this.libnames != null && this.libnames.length > 0) {
            String[] patterns = linker.getLibraryPatterns(this.libnames);
            int i = 0;
            while (i < patterns.length) {
                PatternSet.NameEntry entry = localSet.createInclude();
                entry.setName(patterns[i]);
                ++i;
            }
        }
        if (localSet.getDir(project) == null) {
            int j = libpath.length - 1;
            while (j >= 0) {
                FileSet clone = (FileSet)localSet.clone();
                clone.setDir(libpath[j]);
                DirectoryScanner scanner = clone.getDirectoryScanner(project);
                File basedir = scanner.getBasedir();
                String[] files = scanner.getIncludedFiles();
                int k = 0;
                while (k < files.length) {
                    visitor.visit(basedir, files[k]);
                    ++k;
                }
                --j;
            }
        } else {
            DirectoryScanner scanner = localSet.getDirectoryScanner(project);
            File basedir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            int k = 0;
            while (k < files.length) {
                visitor.visit(basedir, files[k]);
                ++k;
            }
        }
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void execute() throws BuildException {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }
}

